package com.elitesland.tw.tw5.server.prd.product.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductClassPayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductClassQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductClassService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductClassVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.product.convert.PrdProductClassConvert;
import com.elitesland.tw.tw5.server.prd.product.dao.PrdProductClassDAO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

/**
 * 产品分类
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdProductClassServiceImpl extends BaseServiceImpl implements PrdProductClassService {

    private final PrdProductClassRepo prdProductClassRepo;
    private final PrdProductClassDAO prdProductClassDAO;

    @Override
    public PagingVO<PrdProductClassVO> queryPaging(PrdProductClassQuery query) {
        return prdProductClassDAO.queryPaging(query);
    }

    @Override
    public List<PrdProductClassVO> queryListDynamic(PrdProductClassQuery query) {
        return prdProductClassDAO.queryListDynamic(query);
    }

    @Override
    public PrdProductClassVO queryByKey(Long key) {
        PrdProductClassDO entity = prdProductClassRepo.findById(key).orElseGet(PrdProductClassDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdProductClassVO vo = PrdProductClassConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProductClassVO insert(PrdProductClassPayload payload) {
        String classCode = "";
        //判断是否为产品小类
        if (payload.getClassType().equals("0")) {
            Long seniorId = payload.getSeniorId();
            PrdProductClassVO prdProductClassVO = queryByKey(seniorId);
            List<PrdProductClassDO> subClasses = prdProductClassRepo.findBySeniorId(seniorId);
            classCode = prdProductClassVO.getClassCode() + String.format("%0" + 2 + "d", subClasses.size() + 1);
        } else {
//            List<PrdProductClassDO> bigClasses = prdProductClassRepo.findByClassType("1");
//            classCode = "PROD" + String.format("%0" + 3 + "d",bigClasses.size() + 1);
            classCode = generateSeqNum("PRODUCT_CLASS_NO");
        }
        payload.setClassCode(classCode);
        PrdProductClassDO entityDo = PrdProductClassConvert.INSTANCE.toDo(payload);
        return PrdProductClassConvert.INSTANCE.toVo(prdProductClassRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProductClassVO update(PrdProductClassPayload payload) {
        PrdProductClassDO entity = prdProductClassRepo.findById(payload.getId()).orElseGet(PrdProductClassDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdProductClassDO entityDo = PrdProductClassConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdProductClassConvert.INSTANCE.toVo(prdProductClassRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<PrdProductClassDO> optional = prdProductClassRepo.findById(id);
                if (!optional.isEmpty()) {
                    PrdProductClassDO entity = optional.get();
                    List<PrdProductClassDO> bySeniorId = prdProductClassRepo.findBySeniorIdAndDeleteFlag(id, 0);
                    if (bySeniorId.size() > 0) {
                        throw TwException.error("", "分类" + entity.getClassName() + " 有下级，不能直接删除，请先删除下级分类");
                    }
                }
            });
            prdProductClassDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<PrdProductClassVO> querySubClassBySeniorId(Long seniorId) {
        PrdProductClassQuery query = new PrdProductClassQuery();
        query.setSeniorId(seniorId);
        query.setClassType("0");
        query.setSize(Integer.MAX_VALUE);
        PagingVO<PrdProductClassVO> pagingVO = prdProductClassDAO.queryPaging(query);
        return pagingVO.getRecords();
    }

    @Override
    public List<PrdProductClassVO> getClassTrees(Long pId) {
        List<PrdProductClassVO> rootTrees = new ArrayList<>();
        PrdProductClassQuery query = new PrdProductClassQuery();
        if (pId != null && pId > 0) {
            query.setSeniorId(pId);
        }
        List<PrdProductClassVO> trees = prdProductClassDAO.queryListDynamic(query);
        for (PrdProductClassVO tree : trees) {
            if (tree.getSeniorId() == -1 || tree.getSeniorId().equals(pId)) {
                rootTrees.add(tree);
            }
            for (PrdProductClassVO t : trees) {
                if (t.getSeniorId() != null && t.getSeniorId().equals(tree.getId())) {
                    if (tree.getChild() == null) {
                        List<PrdProductClassVO> myChildrens = new ArrayList<>();
                        myChildrens.add(t);
                        tree.setChild(myChildrens);
                    } else {
                        tree.getChild().add(t);
                    }
                }
            }
        }
//        rootTrees.forEach(item -> {
//            if (!CollectionUtils.isEmpty(item.getChild())) {
//                item.getChild().stream().peek(child -> {
//                    if (child.getSortNo() == null) {
//                        child.setSortNo(0);
//                    }
//                }).collect(Collectors.toList()).sort(Comparator.comparing(TwClassView::getSortNo));//集合排序
//            }
//        });
        return rootTrees;
    }
}
