package com.elitesland.tw.tw5.server.prd.provacation.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * @author : duwh
 * @date : 2024-1-19
 * @desc : 项目假期设置
 */
@Entity
@Table(name = "pro_vacation_setting")
@org.hibernate.annotations.Table(appliesTo = "pro_vacation_setting", comment = "项目假期设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ProVacationSettingDO extends BaseModel {


    /**
     * 项目id
     */
    @Column(name = "project_id", columnDefinition = "bigint(20) comment '项目id'")
    private Long projectId;

    /**
     * 工作小时数
     */
    @Column(name = "work_hours", columnDefinition = "decimal(20,2) comment '工作小时数'")
    private BigDecimal workHours;

    /**
     * 年度
     */
    @Column(name = "year", columnDefinition = "int(11) comment '年度'")
    private Integer year;

    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

}

