package com.elitesland.tw.tw5.server.prd.provacation.model.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;


/**
 * @author : WWW
 * @date : 2024-1-19
 * @desc : 项目假期
 */
@Data
@ApiModel(description = "项目假期")
public class ProVacationPayload extends TwCommonPayload {


    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;

    /**
     * 日期
     */
    @ApiModelProperty("日期")
    private LocalDate naturalDate;

    /**
     * 年份
     */
    @ApiModelProperty("年份")
    private Integer year;


    /**
     * 工作小时数
     */
    @ApiModelProperty("工作小时数")
    private BigDecimal workHours;


    /**
     * 类型 1项目
     */
    @ApiModelProperty("类型 1项目")
    private Integer type;


    @ApiModelProperty("时间/工时集合")
    List<Map<String, BigDecimal>> mapList;
}

