package com.elitesland.tw.tw5.server.prd.purchase.repo;

import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseAgreementDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;

import java.util.Optional;

/**
 * 采购协议
 *
 * @author Echo
 * @date 2023-06-08
 */
public interface PurchaseAgreementRepo extends JpaRepository<PurchaseAgreementDO, Long>, JpaSpecificationExecutor<PurchaseAgreementDO> {

    /**
     * 根据编号查询采购协议
     * @param purchaseAgreementNo 采购协议编号
     * @return 采购协议DO
     */
    Optional<PurchaseAgreementDO> findByPurchaseAgreementNo(String purchaseAgreementNo);
}
