package com.elitesland.tw.tw5.server.prd.salecon.dao;


import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingTypePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingTypeQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConInvSettingTypeDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConInvSettingTypeRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * ConInvSettingTypeController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Repository
@RequiredArgsConstructor
public class ConInvSettingTypeDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final ConInvSettingTypeRepo repo;
    private final QConInvSettingTypeDO qdo = QConInvSettingTypeDO.conInvSettingTypeDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvSettingTypeVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(ConInvSettingTypeVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 开票类型：1 开票 0 退票
                qdo.invOrRefund,
                // 发票类型
                qdo.invType,
                // 是否开票:1 是；0 否
                qdo.invFlag,
                // 邮件通知:1 是；0 否
                qdo.emailFlag,
                // 配置主表id
                qdo.invSettingId
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<ConInvSettingTypeVO> getJpaQueryWhere(ConInvSettingTypeQuery query) {
        JPAQuery<ConInvSettingTypeVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(ConInvSettingTypeQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(ConInvSettingTypeQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 开票类型：1 开票 0 退票 精确 */
        if (!ObjectUtils.isEmpty(query.getInvOrRefund())) {
            list.add(qdo.invOrRefund.eq(query.getInvOrRefund()));
        }
        /** 发票类型 精确 */
        if (!ObjectUtils.isEmpty(query.getInvType())) {
            list.add(qdo.invType.eq(query.getInvType()));
        }
        /** 是否开票:1 是；0 否 精确 */
        if (!ObjectUtils.isEmpty(query.getInvFlag())) {
            list.add(qdo.invFlag.eq(query.getInvFlag()));
        }
        /** 邮件通知:1 是；0 否 精确 */
        if (!ObjectUtils.isEmpty(query.getEmailFlag())) {
            list.add(qdo.emailFlag.eq(query.getEmailFlag()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public ConInvSettingTypeVO queryByKey(Long id) {
        JPAQuery<ConInvSettingTypeVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<ConInvSettingTypeVO> queryListDynamic(ConInvSettingTypeQuery query) {
        JPAQuery<ConInvSettingTypeVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<ConInvSettingTypeVO> queryPaging(ConInvSettingTypeQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<ConInvSettingTypeVO> jpaQuery = getJpaQueryWhere(query);
        List<ConInvSettingTypeVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<ConInvSettingTypeVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public ConInvSettingTypeDO save(ConInvSettingTypeDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<ConInvSettingTypeDO> saveAll(List<ConInvSettingTypeDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(ConInvSettingTypePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 开票类型：1 开票 0 退票
        if (payload.getInvOrRefund() != null) {
            update.set(qdo.invOrRefund, payload.getInvOrRefund());
        }
        // 发票类型
        if (payload.getInvType() != null) {
            update.set(qdo.invType, payload.getInvType());
        }
        // 是否开票:1 是；0 否
        if (payload.getInvFlag() != null) {
            update.set(qdo.invFlag, payload.getInvFlag());
        }
        // 邮件通知:1 是；0 否
        if (payload.getEmailFlag() != null) {
            update.set(qdo.emailFlag, payload.getEmailFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 开票类型：1 开票 0 退票
            if (nullFields.contains("invOrRefund")) {
                update.setNull(qdo.invOrRefund);
            }
            // 发票类型
            if (nullFields.contains("invType")) {
                update.setNull(qdo.invType);
            }
            // 是否开票:1 是；0 否
            if (nullFields.contains("invFlag")) {
                update.setNull(qdo.invFlag);
            }
            // 邮件通知:1 是；0 否
            if (nullFields.contains("emailFlag")) {
                update.setNull(qdo.emailFlag);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

