package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;

/**
 * 外包费用确认单
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Entity
@Table(name = "con_epiboly_cost_con", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "con_epiboly_cost_con", comment = "外包费用确认单")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ConEpibolyCostConDO extends BaseModel implements Serializable  {
    /** 合同ID */
    @Comment("合同ID")
    @Column()
    private Long contractId;
    /** 外包费用单号 */
    @Comment("外包费用单号")
    @Column()
    private String epibolyCostNo;
    /** 申请人 */
    @Comment("申请人")
    @Column()
    private Long applyUserId;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /** 申请BU */
    @Comment("申请BU")
    @Column()
    private Long applyBuId;

    /** 4.0id */
    @Comment("4.0id")
    @Column()
    private Long costConIdV4;

    public void copy(ConEpibolyCostConDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
