package com.elitesland.tw.tw5.server.prd.salecon.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 部门毛利率配置
 *
 * @author wangly
 * @date 2024-04-01
 */
@Entity
@Table(name = "org_gross_profit_rate_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "org_gross_profit_rate_setting", comment = "部门毛利率配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class OrgGrossProfitRateSettingDO extends BaseModel implements Serializable {
    /**
     * 部门id
     */
    @Comment("部门id")
    @Column()
    private Long orgId;
    /**
     * 工作类型 [salecon:work_type]
     */
    @Comment("工作类型 [salecon:work_type]")
    @Column()
    private String workType;
    /**
     * 部门毛利率
     */
    @Comment("部门毛利率")
    @Column()
    private BigDecimal orgGrossProfitRate;
    /**
     * 过单毛利率
     */
    @Comment("过单毛利率")
    @Column()
    private BigDecimal orderGrossProfitRate;
    /**
     * 开始日期
     */
    @Comment("开始日期")
    @Column()
    private LocalDate startDate;
    /**
     * 结束日期
     */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /**
     * 排序号
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /**
     * 拓展字段1
     */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /**
     * 拓展字段2
     */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /**
     * 拓展字段3
     */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /**
     * 拓展字段4
     */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /**
     * 拓展字段5
     */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    /**
     * 资源经理
     */
    @Comment("资源经理")
    @Column()
    private Long resManagerId;

    public void copy(OrgGrossProfitRateSettingDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
