package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemShortcutPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemShortcutQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 系统快捷入口
 *
 * @folder 系统快捷入口
 * @author wangly
 * @date 2024-03-28
 */
@Api(tags = "系统快捷入口")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/prdSystemShortcut")
@Slf4j
public class PrdSystemShortcutController {

private final PrdSystemShortcutService prdSystemShortcutService;

    /**
     * 系统快捷入口-新增
     *
     * @folder 系统快捷入口
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("系统快捷入口-新增")
    public TwOutputUtil<PrdSystemShortcutVO> insert(@RequestBody PrdSystemShortcutPayload payload){
         return TwOutputUtil.ok(prdSystemShortcutService.insert(payload));
    }

    /**
     * 系统快捷入口-更新
     *
         * @folder 系统快捷入口
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("系统快捷入口-更新")
    public TwOutputUtil<PrdSystemShortcutVO> update(@RequestBody PrdSystemShortcutPayload payload){
        return TwOutputUtil.ok(prdSystemShortcutService.update(payload));
    }

    /**
     * 系统快捷入口-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 系统快捷入口
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("系统快捷入口-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdSystemShortcutPayload payload){
        return TwOutputUtil.ok(prdSystemShortcutService.updateByKeyDynamic(payload));
    }

    /**
     * 系统快捷入口-主键查询
     *
     * @folder 系统快捷入口
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("系统快捷入口-主键查询")
    public TwOutputUtil<PrdSystemShortcutVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(prdSystemShortcutService.queryByKey(key));
    }

    /**
     * 系统快捷入口-分页
     *
         * @folder 系统快捷入口
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("系统快捷入口-分页")
    public TwOutputUtil<PagingVO<PrdSystemShortcutVO>> paging(PrdSystemShortcutQuery query) {
        return TwOutputUtil.ok(prdSystemShortcutService.queryPaging(query));
    }

    /**
     * 系统快捷入口-查询列表
     *
     * @folder 系统快捷入口
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("系统快捷入口-查询列表")
    public TwOutputUtil<List<PrdSystemShortcutVO>> queryList(PrdSystemShortcutQuery query) {
        return TwOutputUtil.ok(prdSystemShortcutService.queryListDynamic(query));
    }

    /**
     * 系统快捷入口-删除
     *
         * @folder 系统快捷入口
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("系统快捷入口-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         prdSystemShortcutService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 系统快捷入口-查询所有图标
     *
     * @folder 系统快捷入口
     * @return result
     */
    @GetMapping("/queryAllIcon")
    @ApiOperation("系统快捷入口-查询本人所有图标")
    public TwOutputUtil<PrdUserDataVO> queryAllIcon() {
        return TwOutputUtil.ok(prdSystemShortcutService.queryAllIcon());
    }
}

