package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;

/**
 * 财务年度
 *
 * @author likunpeng
 * @date 2023-04-12
 */
@Entity
@Table(name = "prd_system_fin_year", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_system_fin_year", comment = "财务年度")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemFinYearDO extends BaseModel implements Serializable  {
    /** 财务年度 */
    @Comment("财务年度")
    @Column()
    private Integer finYear;
    /** 开始日期 */
    @Comment("开始日期")
    @Column()
    private LocalDate beginDate;
    /** 结束日期 */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /** 财年状态 */
    @Comment("财年状态")
    @Column()
    private String yearStatus;
    /** 4.0财务年度id */
    @Comment("4.0财务期间id")
    @Column()
    private Long finYearIdV4;

    public void copy(PrdSystemFinYearDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
