package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author Lemon
 */
@Entity
@Table(name = "prd_system_problem_feedback")
@org.hibernate.annotations.Table(appliesTo = "prd_system_problem_feedback", comment = "问题反馈表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemProblemFeedbackDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 7368430966293178247L;

    @Comment("反馈标题")
    @Column()
    private String feedbackTitle;

    @Comment("问题url")
    @Column()
    private String problemUrl;

    @Comment("附件")
    @Column()
    private String fileCodes;

    @Comment("反馈状态")
    @Column()
    private String feedbackStatus;

    @Comment("关闭理由")
    @Column()
    private String closeReason;

    @Comment("加急标识，0：不加急，1：加急")
    private Integer urgentFlag;

    @Comment("回复状态")
    @Column()
    private String replyStatus;

    @Comment("内容")
    @Column()
    private String content;

    @Comment("问题类型")
    @Column()
    private String problemType;

    @Comment("所属功能id")
    @Column()
    private Long functionId;

    @Comment("所属功能Code")
    @Column()
    private Long functionCode;

    @Comment("负责人")
    @Column()
    private Long directorUserId;

    @Comment("阅览量")
    @Column()
    private Long readAmount;

    @Comment("标签")
    @Column()
    private String tags;

    @Comment("常用问题标识")
    private Integer commonFlag;

    @Comment("严重程度")
    private String level;
}
