package com.elitesland.tw.tw5.server.prd.system.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.query.PrdOrgEmployeeConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdOrgEmployeeConfigVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemShortcutPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemShortcutQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemShortcutService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutJsonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemShortcutVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.PrdOrgEmployeeConfigTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdOrgEmployeeConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdSystemShortcutIconTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemShortcutConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemShortcutDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemShortcutDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemShortcutRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 系统快捷入口
 *
 * @author wangly
 * @date 2024-03-28
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemShortcutServiceImpl extends BaseServiceImpl implements PrdSystemShortcutService {

    private final PrdSystemShortcutRepo prdSystemShortcutRepo;
    private final PrdSystemShortcutDAO prdSystemShortcutDAO;
    private final CacheUtil cacheUtil;
    private final String SHORTCUT_PREFIX = "/cloudt/system/com/file/v1/";
    private final String SHORTCUT_SUFFIX = "/show";
    private final PrdOrgEmployeeConfigDAO prdOrgEmployeeConfigDAO;
    private final FileUtil fileUtil;

    @Override
    public PagingVO<PrdSystemShortcutVO> queryPaging(PrdSystemShortcutQuery query) {
        return prdSystemShortcutDAO.queryPaging(query);
    }

    @Override
    public List<PrdSystemShortcutVO> queryListDynamic(PrdSystemShortcutQuery query) {
        return prdSystemShortcutDAO.queryListDynamic(query);
    }

    @Override
    public PrdSystemShortcutVO queryByKey(Long key) {
        PrdSystemShortcutDO entity = prdSystemShortcutRepo.findById(key).orElseGet(PrdSystemShortcutDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemShortcutVO vo = PrdSystemShortcutConvert.INSTANCE.toVo(entity);
        vo.setShortcutIconData(fileUtil.getFileDatas(vo.getShortcutIcon()));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemShortcutVO insert(PrdSystemShortcutPayload payload) {
        PrdSystemShortcutDO entityDo = PrdSystemShortcutConvert.INSTANCE.toDo(payload);
        return PrdSystemShortcutConvert.INSTANCE.toVo(prdSystemShortcutRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemShortcutVO update(PrdSystemShortcutPayload payload) {
        PrdSystemShortcutDO entity = prdSystemShortcutRepo.findById(payload.getId()).orElseGet(PrdSystemShortcutDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemShortcutDO entityDo = PrdSystemShortcutConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdSystemShortcutConvert.INSTANCE.toVo(prdSystemShortcutRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdSystemShortcutPayload payload) {
        PrdSystemShortcutDO entity = prdSystemShortcutRepo.findById(payload.getId()).orElseGet(PrdSystemShortcutDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdSystemShortcutDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdSystemShortcutDAO.deleteSoft(keys);
        }
    }

    @Override
    public PrdUserDataVO queryAllIcon() {
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeConfigQuery query = new PrdOrgEmployeeConfigQuery();
        query.setUserId(loginUserId);
        query.setConfigType("icon");
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = queryEmployeeConfigListDynamic(query);

        List<PrdSystemShortcutJsonVO> prdSystemShortcutJsonVOSFromEmployeeConfig = new ArrayList<>();
        if (!prdOrgEmployeeConfigVOS.isEmpty()) {
            PrdOrgEmployeeConfigVO prdOrgEmployeeConfigVO = prdOrgEmployeeConfigVOS.get(0);
            String contentJson = prdOrgEmployeeConfigVO.getContentJson();
            if (StringUtils.hasText(contentJson)) {
                prdSystemShortcutJsonVOSFromEmployeeConfig = JSON.parseArray(contentJson, PrdSystemShortcutJsonVO.class);
            }
        }
        // 查询所有有效的图标
        PrdSystemShortcutQuery prdSystemShortcutQuery = new PrdSystemShortcutQuery();
        prdSystemShortcutQuery.setShortcutStatus(1);
        List<PrdSystemShortcutVO> shortcutVOs = prdSystemShortcutDAO.queryListDynamic(prdSystemShortcutQuery);

        Set<String> configNames = prdSystemShortcutJsonVOSFromEmployeeConfig.stream().map(e -> e.getTitle()).collect(Collectors.toSet());
        // 将配置过的图标从全部图标里面移除
        shortcutVOs.removeIf(obj -> configNames.contains(obj.getShortcutName()));

        PrdUserDataVO vo = new PrdUserDataVO();
        if (!CollectionUtils.isEmpty(shortcutVOs)) {

            // 系统图标处理
            // 业务伙伴图标权限 true 有 false 没有
            Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(),
                    RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));

            List<PrdSystemShortcutJsonVO> prdSystemShortcutJsonVOS = new ArrayList<>();
            shortcutVOs.stream().forEach(shortcutVO -> {
                if (!rolePermission && shortcutVO.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())) {
                    return;
                }
                PrdSystemShortcutJsonVO prdSystemShortcutJsonVO = new PrdSystemShortcutJsonVO();
                prdSystemShortcutJsonVO.setType(shortcutVO.getType());
                prdSystemShortcutJsonVO.setFixFlag(shortcutVO.getFixFlag());
                prdSystemShortcutJsonVO.setIcon(SHORTCUT_PREFIX + shortcutVO.getShortcutIcon() + SHORTCUT_SUFFIX);
                prdSystemShortcutJsonVO.setTitle(shortcutVO.getShortcutName());
                prdSystemShortcutJsonVO.setBadge("");
                prdSystemShortcutJsonVO.setShowBadgeFlag(false);
                prdSystemShortcutJsonVO.setExt1("");
                prdSystemShortcutJsonVO.setExt2("");
                prdSystemShortcutJsonVO.setExt3("");
                prdSystemShortcutJsonVOS.add(prdSystemShortcutJsonVO);
            });
            prdSystemShortcutJsonVOSFromEmployeeConfig.addAll(prdSystemShortcutJsonVOS);
        }
        if (!CollectionUtils.isEmpty(prdSystemShortcutJsonVOSFromEmployeeConfig)) {
            vo.setShortcutJson(JSON.toJSONString(prdSystemShortcutJsonVOSFromEmployeeConfig));
        }
        return vo;
    }

    // 查询个人配置图标
    private List<PrdOrgEmployeeConfigVO> queryEmployeeConfigListDynamic(PrdOrgEmployeeConfigQuery query) {
        // 查询个人配置的所有图标
        List<PrdOrgEmployeeConfigVO> prdOrgEmployeeConfigVOS = prdOrgEmployeeConfigDAO.queryListDynamic(query);
        if (PrdOrgEmployeeConfigTypeEnum.icon.getCode().equals(query.getConfigType())) {
            Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.FINANCE_MEMBER.getCode(),
                    RoleEnum.BUSINESS_PARTNER_MANAGER.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
            if (!CollectionUtils.isEmpty(prdOrgEmployeeConfigVOS)) {
                prdOrgEmployeeConfigVOS.forEach(vo -> {
                    if (StringUtils.hasText(vo.getContentJson())) {
                        //判断有没有业务伙伴图标的权限 有的话查询更多功能和业务伙伴图标 没有的话只查询更多功能图标
                        PrdSystemShortcutQuery prdSystemShortcutQuery = new PrdSystemShortcutQuery();
                        if (rolePermission) {
                            prdSystemShortcutQuery.setTypeList(Arrays.asList(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode(), PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode()));
                        } else {
                            prdSystemShortcutQuery.setType(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode());
                        }
                        prdSystemShortcutQuery.setShortcutStatus(1);
                        List<PrdSystemShortcutVO> prdSystemShortcutVOS = queryListDynamic(prdSystemShortcutQuery);

                        List<PrdSystemShortcutJsonVO> prdSystemShortcutJsonVOS = JSON.parseArray(vo.getContentJson(), PrdSystemShortcutJsonVO.class);
                        //过滤更多功能图标
                        PrdSystemShortcutVO moreFunctionShortcutVO = prdSystemShortcutVOS.stream().filter(item -> item.getType().equals(PrdSystemShortcutIconTypeEnum.MORE_FUNCTION.getCode())).findFirst().orElse(null);
                        if(moreFunctionShortcutVO!=null){
                            PrdSystemShortcutJsonVO moreFunctionVO = new PrdSystemShortcutJsonVO();
                            moreFunctionVO.setType(moreFunctionShortcutVO.getType());
                            moreFunctionVO.setFixFlag(moreFunctionShortcutVO.getFixFlag());
                            moreFunctionVO.setIcon(SHORTCUT_PREFIX + moreFunctionShortcutVO.getShortcutIcon() + SHORTCUT_SUFFIX);
                            moreFunctionVO.setTitle(moreFunctionShortcutVO.getShortcutName());
                            moreFunctionVO.setBadge("");
                            moreFunctionVO.setShowBadgeFlag(false);
                            moreFunctionVO.setExt1("");
                            moreFunctionVO.setExt2("");
                            moreFunctionVO.setExt3("");
                            prdSystemShortcutJsonVOS.add(11, moreFunctionVO);
                        }

                        // 如果有权限并且个人配置的图标里没有业务伙伴图标 就给他加上图标
                        if (rolePermission) {
                            boolean match = prdSystemShortcutJsonVOS.stream().anyMatch(p -> p.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode()));
                            if (!match) {
                                PrdSystemShortcutJsonVO prdSystemShortcutJsonVO = new PrdSystemShortcutJsonVO();
                                //过滤业务伙伴图标
                                PrdSystemShortcutVO businessPartnerShortcutVO = prdSystemShortcutVOS.stream().filter(item -> item.getType().equals(PrdSystemShortcutIconTypeEnum.BUSINESS_PARTNER.getCode())).findFirst().orElse(null);
                                prdSystemShortcutJsonVO.setType(businessPartnerShortcutVO.getType());
                                prdSystemShortcutJsonVO.setFixFlag(businessPartnerShortcutVO.getFixFlag());
                                prdSystemShortcutJsonVO.setIcon(SHORTCUT_PREFIX + businessPartnerShortcutVO.getShortcutIcon() + SHORTCUT_SUFFIX);
                                prdSystemShortcutJsonVO.setTitle(businessPartnerShortcutVO.getShortcutName());
                                prdSystemShortcutJsonVO.setBadge("");
                                prdSystemShortcutJsonVO.setShowBadgeFlag(false);
                                prdSystemShortcutJsonVO.setExt1("");
                                prdSystemShortcutJsonVO.setExt2("");
                                prdSystemShortcutJsonVO.setExt3("");
                                prdSystemShortcutJsonVOS.add(prdSystemShortcutJsonVO);
                            }
                        }
                        vo.setContentJson(JSON.toJSONString(prdSystemShortcutJsonVOS));
                    }
                });
            }
            return prdOrgEmployeeConfigVOS;
        } else {
            return prdOrgEmployeeConfigVOS;

        }
    }

}
