package com.elitesland.tw.tw5.server.prd.task.common;

import lombok.Getter;

/**
 * 任务状态枚举
 *
 * @author carl
 */
public enum TaskStatusEnum {
    APPROVED("1", "激活"),
    DISTRIBUTING("2", "派发中"),
    CREATE("3", "新建"),
    RETURN("4", "退回"),
    PENDING("5", "暂挂"),
    FINISH("6", "已完成"),
    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    TaskStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TaskStatusEnum getByCode(String code) {
        for (TaskStatusEnum value : TaskStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
