package com.elitesland.tw.tw5.server.prd.task.dao;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.task.convert.PmsTaskRouteDtlConvert;
import com.elitesland.tw.tw5.server.prd.task.entity.PmsTaskRouteDtlDO;
import com.elitesland.tw.tw5.server.prd.task.entity.QPmsTaskRouteDtlDO;
import com.elitesland.tw.tw5.server.prd.task.repo.PmsTaskRouteDtlRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;


/**
 * 任务路线图明细dao
 * @author wangxl
 * @date 2024/4/28
 */
@RequiredArgsConstructor
@Component
public class PmsTaskRouteDtlDao {

    private static final QPmsTaskRouteDtlDO qdo = QPmsTaskRouteDtlDO.pmsTaskRouteDtlDO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsTaskRouteDtlRepo repo;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsTaskRouteDtlVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsTaskRouteDtlVO.class,
                qdo.id,
                qdo.tenantId,
                qdo.belongOrgId,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                qdo.updater,
                qdo.modifyTime,
                qdo.tenantOrgId,
                qdo.remark,
                qdo.deleteFlag,
                qdo.taskId,
                qdo.executionDesc,
                qdo.parentId,
                qdo.projectId,
                qdo.masId
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<Long> getJpaQuerySelectCount() {
        return jpaQueryFactory.select(qdo.id.count()).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     */
    private void jpaQueryWhere(JPAQuery<?> jpaQuery, PmsTaskRouteDtlQuery query) {
        if (!ObjectUtils.isEmpty(query.getRemark())) {
            jpaQuery.where(qdo.remark.eq(query.getRemark()));
        }
        if (!ObjectUtils.isEmpty(query.getTaskId())) {
            jpaQuery.where(qdo.taskId.eq(query.getTaskId()));
        }
        if (!ObjectUtils.isEmpty(query.getExecutionDesc())) {
            jpaQuery.where(qdo.executionDesc.eq(query.getExecutionDesc()));
        }
        if (!ObjectUtils.isEmpty(query.getParentId())) {
            jpaQuery.where(qdo.parentId.eq(query.getParentId()));
        }
        if (!ObjectUtils.isEmpty(query.getProjectId())) {
            jpaQuery.where(qdo.projectId.eq(query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty(query.getMasId())) {
            jpaQuery.where(qdo.masId.eq(query.getMasId()));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
    }

    /**
     * 分页查询
     * @param query 查询参数
     * @return result
     */
    public PagingVO<PmsTaskRouteDtlVO> queryPage(PmsTaskRouteDtlQuery query) {
        // 查询总行数total
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long nullAbleCount = jpaQuerySelectCount.fetchOne();
        long count = nullAbleCount == null ? 0 : nullAbleCount;
        // 如果总行数为0则直接返回
        if(count == 0){
            return PagingVO.<PmsTaskRouteDtlVO>builder()
                    .total(count)
                    .records(Collections.emptyList())
                    .build();
        }
        JPAQuery<PmsTaskRouteDtlVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        // 分页
        SqlUtil.handlePage(jpaQuerySelect, query);
        return PagingVO.<PmsTaskRouteDtlVO>builder()
                .total(count)
                .records(jpaQuerySelect.fetch())
                .build();
    }

    /**
     * 查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsTaskRouteDtlVO> queryList(PmsTaskRouteDtlQuery query) {
        JPAQuery<PmsTaskRouteDtlVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQueryWhere(jpaQuerySelect, query);
        // 动态排序
        jpaQuerySelect.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuerySelect.fetch();
    }

    /**
     * 查询count
     *
     * @param query 查询参数
     * @return count
     */
    public long queryCount(PmsTaskRouteDtlQuery query) {
        JPAQuery<Long> jpaQuerySelectCount = getJpaQuerySelectCount();
        jpaQueryWhere(jpaQuerySelectCount, query);
        Long count = jpaQuerySelectCount.fetchOne();
        return count==null?0:count;
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsTaskRouteDtlVO queryByKey(Long id) {
        JPAQuery<PmsTaskRouteDtlVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 调用jpa的保存
     *
     * @param payload payload
     * @return 保存后的对象
     */
    public PmsTaskRouteDtlVO save(PmsTaskRouteDtlPayload payload) {
        PmsTaskRouteDtlDO ado = PmsTaskRouteDtlConvert.INSTANCE.toEntity(payload);
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(ado);
        repo.save(ado);
        return PmsTaskRouteDtlConvert.INSTANCE.toVO(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsTaskRouteDtlDO> saveAll(List<PmsTaskRouteDtlDO> dos) {
        // 创建单据的时候审计字段会被前端传的值影响，强制清空相关字段
        SqlUtil.clearAuditFields(dos);
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(PmsTaskRouteDtlPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        if (payload.getRemark() != null) {
            update.set(qdo.remark, payload.getRemark());
        }
        if (payload.getTaskId() != null) {
            update.set(qdo.taskId, payload.getTaskId());
        }
        if (payload.getExecutionDesc() != null) {
            update.set(qdo.executionDesc, payload.getExecutionDesc());
        }
        if (payload.getParentId() != null) {
            update.set(qdo.parentId, payload.getParentId());
        }
        if (payload.getProjectId() != null) {
            update.set(qdo.projectId, payload.getProjectId());
        }
        if (payload.getMasId() != null) {
            update.set(qdo.masId, payload.getMasId());
        }
        // 处理要设置成空的字段(nullField处理)
        SqlUtil.handleNullFieldsUpdate(payload,qdo,update);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

    public Long deleteByMasId(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.masId.in(ids));
        return update.execute();

    }
}