package com.elitesland.tw.tw5.server.prd.task.service;

import cn.hutool.core.lang.Assert;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.change.payload.ComChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.ComChangeVO;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleDetailService;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.BuProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.query.TaskPackageQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskCommonService;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoExcelExport;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.task.common.PricingMethodEnum;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskInfoConvert;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import com.elitesland.tw.tw5.server.prd.task.entity.TaskInfoDO;
import com.elitesland.tw.tw5.server.prd.task.service.event.BatchAddTaskEvent;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.Period;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * 任务
 *
 * @author xxb
 * @date 2023-11-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskInfoServiceImpl extends BaseServiceImpl implements TaskInfoService {

    private final TaskInfoDAO taskInfoDAO;
    private final TaskPackageDAO taskPackageDAO;
    private final ComChangeService changeService;

    private final WorkflowUtil workflowUtil;

    private final CacheUtil cacheUtil;
    private final PmsDistributeService pmsDistributeService;

    private final TaskCommonService taskCommonService;
    private final BudgetCommonService budgetCommonService;
    private final CalTaskSettleDetailService calTaskSettleDetailService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    @Autowired(required = false)
    private Map<String, BatchAddTaskEvent> batchAddTaskEventMap;

    private final TaskSceneService taskSceneService;
    private final TaskCategoryService taskCategoryService;
    private final StateFlowService stateFlowService;
    private final PrdSystemLogService logService;
    @Override
    public List<String> getEffectiveTaskStatus() {
        List<String> effectiveTaskStatus = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());

        return effectiveTaskStatus;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateTask(TaskInfoPayload payload) {
        if (ObjectUtils.isEmpty(payload.getId())) {
            throw TwException.error("", "任务ID不能为空，请核验！");
        }
        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey0(payload.getId());
        if (!TaskStatusEnum.CREATE.getCode().equals(taskInfoVO.getTaskStatus())) {
            throw TwException.error("", "只有新建状态的任务可以修改！");
        }
        taskInfoDAO.save(getData(payload));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchAddTask(TaskPayload taskPayload) {


        Assert.notNull(taskPayload.getTaskSceneId(), "任务场景id不能为空");
        // 根据场景id查找定义id
        StateFlowVO defStateFlow = stateFlowService.getDefStateFlowByScenId(taskPayload.getTaskSceneId());

        List<TaskInfoPayload> taskInfoPayloads = taskPayload.getTaskInfoPayloads();
        //任务派发校验
        checkData(taskInfoPayloads);

        taskInfoPayloads.forEach(taskInfoPayload -> {
            taskInfoPayload.setTaskSceneId(taskPayload.getTaskSceneId());
            taskInfoPayload.setTaskApplyFlag(0);
            taskInfoPayload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            taskInfoPayload.setDisterResId(null);
            // 设置默认状态流
            if (null != defStateFlow) {
                taskInfoPayload.setStateFlowId(defStateFlow.getId());
                taskInfoPayload.setStateFlowCode(defStateFlow.getCode());
                taskInfoPayload.setStateFlowVersionNo(defStateFlow.getVersionNo());
            }
        });

        // 保存任务信息
        List<TaskInfoVO> taskInfoVOS = batchSave(taskInfoPayloads);
        // 判断是否要发起派发流程
        if (taskPayload.getDistributeFlag()) {
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                //任务派发
                startDistributeProcess(taskInfoVO.getId());
            }
        }

        // 处理产品分层的注册事件
        if(!batchAddTaskEventMap.isEmpty()){
            Collection<BatchAddTaskEvent> events = batchAddTaskEventMap.values();
            events.forEach(event -> {
                event.execute(taskPayload);
            });
        }
    }

    /**
     * 任务派发校验
     *
     * @param taskInfoPayloads
     */
    void checkData(List<TaskInfoPayload> taskInfoPayloads) {
        if (ObjectUtils.isEmpty(taskInfoPayloads)) {
            throw TwException.error("", "任务不能为空，请核验！");
        }
        List<Long> taskPackageIds = new ArrayList<>();
        taskInfoPayloads.forEach(taskInfoPayload -> {
            if (taskInfoPayload.getTaskPackageId() == null) {
                throw TwException.error("", "归属任务包不可为空");
            }
            taskPackageIds.add(taskInfoPayload.getTaskPackageId());
        });

        List<TaskPackageVO> taskPackageVOS = taskPackageDAO.queryByKeys(taskPackageIds);
        if (taskPackageVOS.size() == 0) {
            throw TwException.error("", "归属任务包不存在");
        }
        Map<Long, TaskPackageVO> taskPackageMap = taskPackageVOS.stream().collect(Collectors.toMap(TaskPackageVO::getId, Function.identity()));
        taskInfoPayloads.forEach(taskInfoPayload -> {
            TaskPackageVO taskPackageVO = taskPackageMap.get(taskInfoPayload.getTaskPackageId());
            if (taskPackageVO == null || !taskPackageVO.getTaskPackageStatus().equals(TaskStatusEnum.INPROCESS.getCode())) {
                throw TwException.error("", "仅支持处理中的任务包任务创建");
            }
        });

    }

    @Override
    public TaskInfoVO queryByKey(Long taskId, Boolean needTaskPackage) {
        if (!ObjectUtils.isEmpty(needTaskPackage) && needTaskPackage) {
            return taskInfoDAO.queryByKey(taskId);
        } else {
            return taskInfoDAO.queryByKey0(taskId);
        }
    }

    @Override
    public TaskInfoVO queryByTaskNo(String taskNo) {
        return taskInfoDAO.queryByTaskNo(taskNo);
    }

    @Override
    public List<TaskInfoVO> queryList(TaskInfoQuery taskInfoQuery) {
        //列表查询处理中的任务
        if (!StringUtils.hasText(taskInfoQuery.getTaskStatus())) {
            taskInfoQuery.setTaskStatuss(getEffectiveTaskStatus());
        }
        List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryListDynamic(taskInfoQuery);
//        if (!ObjectUtils.isEmpty(taskInfoVOS)) {
//            taskInfoVOS.forEach(vo ->
//                    vo.setEffectiveEqva(vo.getTotalEqva().subtract(vo.getUsedEqva() == null ? BigDecimal.ZERO : vo.getUsedEqva()))
//            );
//            taskInfoVOS = taskInfoVOS.stream().filter(e -> e.getEffectiveEqva().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
//        }


        return taskInfoVOS;
    }

    @Override
    public List<TaskInfoVO> queryListCommon(TaskInfoQuery taskInfoQuery) {
        List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryListDynamic(taskInfoQuery);
        if (!ObjectUtils.isEmpty(taskInfoVOS)) {
            taskInfoVOS.forEach(vo ->
                    vo.setEffectiveEqva(vo.getTotalEqva().subtract(vo.getUsedEqva() == null ? BigDecimal.ZERO : vo.getUsedEqva()))
            );
        }
        return taskInfoVOS;
    }

    @Override
    public PagingVO<TaskInfoVO> queryPage(TaskInfoQuery taskInfoQuery) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        taskInfoQuery.setLoginUserId(loginUserId);
        if (taskInfoQuery.getSearchType() != null) {
            if (taskInfoQuery.getSearchType() == 1) {
                //我接收的
                taskInfoQuery.setTaskResId(loginUserId);
                taskInfoQuery.setTaskStatusFlag(0);
                List<String> strings = Arrays.asList(TaskStatusEnum.CREATE.getCode(), TaskStatusEnum.DISPATCH.getCode());
                taskInfoQuery.setTaskStatuss(strings);
            }
            if (taskInfoQuery.getSearchType() == 2) {
                //我派发的
                taskInfoQuery.setDisterResId(loginUserId);
            }
        } else {
            //处理权限
            operPermissionFlag(taskInfoQuery);

        }
        PagingVO<TaskInfoVO> taskInfoVOPagingVO = taskInfoDAO.queryPaging(taskInfoQuery);
        //判断是否 是否逾期 及 逾期天数
        if (taskInfoVOPagingVO.getTotal() > 0) {
            LocalDate currentDate = LocalDate.now();
            taskInfoVOPagingVO.getRecords().forEach(taskInfoVO -> {
                BigDecimal totalEqva = taskInfoVO.getTotalEqva();
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal occupyEqva = totalEqva.subtract(settledEqva);
                taskInfoVO.setOccupyEqva(occupyEqva);
                taskInfoVO.setCreator(cacheUtil.getUserName(taskInfoVO.getCreateUserId()));
                List<String> strings = Arrays.asList(TaskStatusEnum.FINISHED.getCode(), TaskStatusEnum.CLOSED.getCode());

                if (strings.contains(taskInfoVO.getTaskStatus())) {
                    taskInfoVO.setOverdue("否");
                } else {
                    if (taskInfoVO.getPlanEndDate() != null) {
                        Period period = Period.between(taskInfoVO.getPlanEndDate(), currentDate);
                        int overdueDays = period.getDays();
                        if (overdueDays > 0) {
                            taskInfoVO.setOverdue("是");
                            taskInfoVO.setOverdueDays(overdueDays);
                        } else {
                            taskInfoVO.setOverdue("否");
                        }
                    }
                }
                if (!ObjectUtils.isEmpty(taskInfoVO.getStateFlowId())) {
                    StateFlowVO stateFlowVO = stateFlowService.get(taskInfoVO.getStateFlowId());
                    if (null != stateFlowVO) {
                        taskInfoVO.setStateFlowName(stateFlowVO.getName());
                        taskInfoVO.setReferenceTaskProgress(stateFlowVO.getProgressPercentage());
                    }

                }
                dealNullStateFlowNane(taskInfoVO);
            });

        }
        return taskInfoVOPagingVO;
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(TaskInfoQuery query) {

        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TASK_ADMIN.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            //1.获取合同项目ids
            //作为组织负责人所有组织id
            List<Long> orgIds = cacheUtil.getOrgIdsByManageId(query.getLoginUserId());
            PmsProjectQuery queryProject = new PmsProjectQuery();
            if (orgIds.size() > 0) {
                queryProject.setDeliBuIds(orgIds);
            }
            queryProject.setPermissionFlag(true);
            List<PmsProjectVO> pmsProjectVOS = pmsProjectService.queryListDynamic(queryProject);
            if (pmsProjectVOS.size() > 0) {
                List<Long> collect = pmsProjectVOS.stream().map(PmsProjectVO::getId).collect(Collectors.toList());
                query.setPmsProjIds(collect);
            }
            //2.获取bu项目ids
            BuProjectQuery buProject = new BuProjectQuery();
            buProject.setLoginUserId(query.getLoginUserId());
            buProject.setPermissionFlag(true);
            List<BuProjectVO> buProjectVOS = buProjectService.queryListDynamic(buProject);
            if (buProjectVOS.size() > 0) {
                List<Long> collect = buProjectVOS.stream().map(BuProjectVO::getId).collect(Collectors.toList());
                query.setBuProjIds(collect);
            }
            //3.获取项目ids
            CrmOpportunityQuery queryOpportunity = new CrmOpportunityQuery();
            //  queryOpportunity.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            queryOpportunity.setPreSaleOrgIds(orgIds);
            queryOpportunity.setLoginUserId(query.getLoginUserId());
            queryOpportunity.setIsPermission(true);
            List<CrmOpportunityListVO> crmOpportunityListVOS = opportunityService.queryListDynamic(queryOpportunity);
            if (crmOpportunityListVOS.size() > 0) {
                List<Long> collect = crmOpportunityListVOS.stream().map(CrmOpportunityListVO::getProjectId).collect(Collectors.toList());
                query.setOppProjIds(collect);
            }


        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<TaskInfoVO> batchSave(List<TaskInfoPayload> taskInfoPayloads) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        //数据转换
        List<TaskInfoDO> taskInfoDOS = taskInfoPayloads.stream().map(taskInfoPayload -> {
            //校验和处理数据
            TaskInfoDO data = getData(taskInfoPayload);
            if (data.getDisterResId() == null) {
                data.setDisterResId(loginUserId);
            }
            return data;
        }).collect(Collectors.toList());
        //校验预算数据
        checkBudget(taskInfoPayloads);
        return TaskInfoConvert.INSTANCE.toVoList(taskInfoDAO.saveAll(taskInfoDOS));
    }

    /**
     * 校验预算数据
     *
     * @param taskInfoPayloads
     */
    void checkBudget(List<TaskInfoPayload> taskInfoPayloads) {
        Map<String, List<TaskInfoPayload>> projMap = new HashMap<>();
        taskInfoPayloads.forEach(taskInfoPayload -> {
            //拆分任务不用校验预算
            if (taskInfoPayload.getTaskParentId() == null) {
                String reasonType = taskInfoPayload.getReasonType();
                Long reasonId = taskInfoPayload.getReasonId();
                String key = reasonType + "-" + reasonId;
                List<TaskInfoPayload> taskInfoPayloads1 = projMap.get(key);
                if (taskInfoPayloads1 == null) {
                    taskInfoPayloads1 = new ArrayList<>();
                }
                taskInfoPayloads1.add(taskInfoPayload);
                projMap.put(key, taskInfoPayloads1);
            }
        });
        //校验项目总预算
        projMap.forEach((key, value) -> {
            String[] split = key.split("-");
            String reasonType = split[0];
            Long reasonId = Long.valueOf(split[1]);
            //总的计划当量
            BigDecimal planAllEqva = value.stream()
                    .map(TaskInfoPayload::getPlanEqva)
                    .filter(Objects::nonNull)
                    .reduce(BigDecimal::add)
                    .orElse(BigDecimal.ZERO);
            budgetCommonService.checkBudgetEqva(reasonId, reasonType, null, planAllEqva);
            //校验预算活动
            Map<Long, List<TaskInfoPayload>> collect = value.stream().filter(pay -> pay.getRelatedActId() != null).collect(Collectors.groupingBy(TaskInfoPayload::getRelatedActId));
            collect.forEach((key0, value0) -> {
                //总的计划当量
                BigDecimal planAllEqva0 = value.stream()
                        .map(TaskInfoPayload::getPlanEqva)
                        .filter(Objects::nonNull)
                        .reduce(BigDecimal::add)
                        .orElse(BigDecimal.ZERO);
                budgetCommonService.checkBudgetEqva(reasonId, reasonType, key0, planAllEqva0);
            });
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskDecompose(TaskPayload taskPayload) {
        Long taskParentId = taskPayload.getTaskParentId();
        if (ObjectUtils.isEmpty(taskParentId)) {
            throw TwException.error("", "上级任务ID不能为空，请核验！");
        }
        TaskInfoVO taskParent = taskInfoDAO.queryByKey(taskParentId);
        if (ObjectUtils.isEmpty(taskParent)) {
            throw TwException.error("", "上级任务不存在，请核验！");
        }
        //只有处理中的任务才可以进行任务拆解
        if (!TaskStatusEnum.INPROCESS.getCode().equals(taskParent.getTaskStatus())) {
            throw TwException.error("", "只有处理中的任务才可以进行任务拆解");
        }
        String taskParentName = taskParent.getTaskName();
        // 任务分解：对于派发给自己的任务，可对该任务进行拆分，分配给该项目中有任务包的其他成员  所以先判断下权限
        if (!taskParent.getTaskResId().equals(GlobalUtil.getLoginUserId())) {
            throw TwException.error("", "任务分解失败，您没有权限进行该操作！");
        }
        //所分解的任务的所有当量数之和不能大于上级任务的任务当量数-已结算当量数-拆分当量数
        List<TaskInfoPayload> taskInfoPayloads = taskPayload.getTaskInfoPayloads();
        if (!ObjectUtils.isEmpty(taskInfoPayloads)) {
            // 求所分解的任务的所有当量数之和
            BigDecimal totalQuantity = taskInfoPayloads.stream().filter(v -> !ObjectUtils.isEmpty(v.getPlanEqva())).map(TaskInfoPayload::getPlanEqva).reduce(BigDecimal.ZERO, BigDecimal::add);
//            // 求上级任务的剩余当量数 = 上级任务的任务当量数-已结算当量数-拆分当量数
//            BigDecimal remainingQuantity = taskParent.getPlanEqva().subtract(taskParent.getSettledEqva()).subtract(taskParent.getSplitEqva());
            // 求上级任务的剩余当量数 = 上级任务的任务总当量数-(已填工时当量数或结算当量）
            BigDecimal usedEqva = taskParent.getUsedEqva() == null ? BigDecimal.ZERO : taskParent.getUsedEqva();
            BigDecimal approvedEqva = taskParent.getApprovedEqva() == null ? BigDecimal.ZERO : taskParent.getApprovedEqva();
            if (approvedEqva.compareTo(usedEqva) > 0) {
                usedEqva = approvedEqva;
            }
            BigDecimal settledEqva = taskParent.getSettledEqva() == null ? BigDecimal.ZERO : taskParent.getSettledEqva();
            if (settledEqva.compareTo(usedEqva) > 0) {
                //考虑任务包结算方式，总价可以不填工时就结算，所以结算可能大于已填工时，单价肯定是填完工时后审批通过才能结算，所以取最大值
                usedEqva = settledEqva;
            }
            BigDecimal remainingQuantity = taskParent.getTotalEqva().subtract(usedEqva);
            //
            if (totalQuantity.compareTo(remainingQuantity) > 0) {
                throw TwException.error("", "所分解的任务的所有当量数之和不能大于上级任务的剩余当量数");
            }
            Set<Long> packageIds = new HashSet<>();
            // 批量新增任务
            taskInfoPayloads.forEach(info -> {
                if (ObjectUtils.isEmpty(info.getPlanEqva()) || info.getPlanEqva().compareTo(BigDecimal.ZERO) <= 0) {
                    throw TwException.error("", "拆分任务当量不合规");
                }
                info.setId(null);
                info.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                info.setTaskParentId(taskParentId);
                info.setTaskParentName(taskParentName);
                info.setTaskApplyFlag(0);
                info.setReasonType(taskParent.getReasonType());
                info.setReasonId(taskParent.getReasonId());
//                //标记拆分任务，不用校验预算
//                info.setSplitFlag(987);
                if (info.getTaskPackageId() == null) {
                    throw TwException.error("", "归属任务包不可为空");
                }
                packageIds.add(info.getTaskPackageId());
            });

            List<TaskPackageVO> taskPackageVOS = taskPackageDAO.queryByKeys(new ArrayList<>(packageIds));
            if (taskPackageVOS.size() != packageIds.size()) {
                throw TwException.error("", "归属任务包不存在");
            }

            taskInfoPayloads.forEach(info -> {
                Optional<TaskPackageVO> first = taskPackageVOS.stream().filter(vo -> vo.getId().equals(info.getTaskPackageId()) && vo.getReceiverResId().equals(info.getTaskResId())).findFirst();
                if (!first.isPresent()) {
                    throw TwException.error("", "【" + info.getTaskName() + "】任务负责人与归属任务包不匹配");
                }
                TaskPackageVO taskPackageVO = first.get();

                if (!info.getReasonType().equals(taskPackageVO.getReasonType())) {
                    throw TwException.error("", "【" + info.getTaskName() + "】关联任务包【" + taskPackageVO.getTaskPackageName() + "】事由类型不匹配");
                }
                if (!info.getReasonId().equals(taskPackageVO.getReasonId())) {
                    throw TwException.error("", "【" + info.getTaskName() + "】关联任务包【" + taskPackageVO.getTaskPackageName() + "】事由不匹配");
                }
                if (!StringUtils.hasText(taskPackageVO.getTaskPackageStatus()) || !TaskStatusEnum.INPROCESS.getCode().equals(taskPackageVO.getTaskPackageStatus())) {
                    throw TwException.error("", "【" + taskPackageVO.getTaskPackageName() + "】任务包状态不在处理中，不可派发任务");
                }
                //先置为null，任务保存的时候会再次赋值
                info.setDisterResId(null);
            });
            // 保存任务信息
            List<TaskInfoVO> taskInfoVOS = batchSave(taskInfoPayloads);
            // 判断是否要发起派发流程
            if (taskPayload.getDistributeFlag()) {
                // 更新上级任务总当量和拆分当量
                TaskInfoPayload taskParentPayload = new TaskInfoPayload();
                taskParentPayload.setId(taskParentId);
                //新的任务当量
                BigDecimal newTotalEqva = taskParent.getTotalEqva().subtract(totalQuantity);
                BigDecimal splitEqva = taskParent.getSplitEqva() == null ? BigDecimal.ZERO : taskParent.getSplitEqva();
                //新的拆解当量
                BigDecimal newSplitEqva = splitEqva.add(totalQuantity);
                //新的计划值
                BigDecimal newPlanEqva = newTotalEqva.add(newSplitEqva);
                if (taskParent.getPlanEqva() == null || newPlanEqva.compareTo(taskParent.getPlanEqva()) != 0) {
                    throw TwException.error("", "任务计划当量不匹配，请联系管理员");
                }
                taskParentPayload.setTotalEqva(newTotalEqva);
                taskParentPayload.setSplitEqva(newSplitEqva);

                taskInfoDAO.updateByKeyDynamic(taskParentPayload);

                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    //任务派发
                    startDistributeProcess(taskInfoVO.getId());
                }
            }
        }

    }

    @Override
    public void taskAutoCreate(TaskPayload taskPayload) {
        //校验及初始化数据
        List<Long> userIds = checkAndInitData(taskPayload);
        TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
        taskPackageQuery.setReasonType(taskPayload.getReasonType());
        taskPackageQuery.setReasonId(taskPayload.getReasonId());
        taskPackageQuery.setReceiverResIds(userIds);
        taskPackageQuery.setTaskPackageStatus(TaskStatusEnum.INPROCESS.getCode());
        List<TaskPackageVO> taskPackageVOS = taskCommonService.queryTaskPackageList(taskPackageQuery);
        taskPayload.getTaskInfoPayloads().forEach(taskInfoPayload -> {
            List<TaskPackageVO> collect = taskPackageVOS.stream().filter(vo -> vo.getReceiverResId().equals(taskInfoPayload.getTaskResId())).collect(Collectors.toList());
            if (ObjectUtils.isEmpty(collect)) {
                throw TwException.error("", "派发资源不存在改项目下的任务包");
            }
            TaskPackageVO taskPackageVO = collect.get(0);
            taskInfoPayload.setTaskPackageId(taskPackageVO.getId());
        });
        //批量保存任务
        batchSave(taskPayload.getTaskInfoPayloads());
    }

    @Override
    public List<TaskInfoVO> queryTaskSimpleList(TaskInfoQuery taskInfoQuery) {
        return taskInfoDAO.queryTaskSimpleList(taskInfoQuery);
    }

    @Override
    public void batchExport(HttpServletResponse response, TaskInfoQuery taskInfoQuery) throws IOException {


        Long loginUserId = GlobalUtil.getLoginUserId();
        taskInfoQuery.setLoginUserId(loginUserId);
        if (taskInfoQuery.getSearchType() != null) {
            if (taskInfoQuery.getSearchType() == 1) {
                //我接收的
                taskInfoQuery.setTaskResId(loginUserId);
                taskInfoQuery.setTaskStatusFlag(0);
                List<String> strings = Arrays.asList(TaskStatusEnum.CREATE.getCode(), TaskStatusEnum.DISPATCH.getCode());
                taskInfoQuery.setTaskStatuss(strings);
            }
            if (taskInfoQuery.getSearchType() == 2) {
                //我派发的
                taskInfoQuery.setDisterResId(loginUserId);
            }
        } else {
            //处理权限
            operPermissionFlag(taskInfoQuery);

        }
        PagingVO<TaskInfoVO> taskInfoVOPagingVO = taskInfoDAO.queryPaging(taskInfoQuery);
        //判断是否 是否逾期 及 逾期天数
        if (taskInfoVOPagingVO.getTotal() > 0) {
            LocalDate currentDate = LocalDate.now();
            taskInfoVOPagingVO.getRecords().forEach(taskInfoVO -> {
                BigDecimal totalEqva = taskInfoVO.getTotalEqva();
                BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                BigDecimal occupyEqva = totalEqva.subtract(settledEqva);
                taskInfoVO.setOccupyEqva(occupyEqva);
                taskInfoVO.setCreator(cacheUtil.getUserName(taskInfoVO.getCreateUserId()));
                List<String> strings = Arrays.asList(TaskStatusEnum.FINISHED.getCode(), TaskStatusEnum.CLOSED.getCode());

                if (strings.contains(taskInfoVO.getTaskStatus())) {
                    taskInfoVO.setOverdue("否");
                } else {
                    if (taskInfoVO.getPlanEndDate() != null) {
                        Period period = Period.between(taskInfoVO.getPlanEndDate(), currentDate);
                        int overdueDays = period.getDays();
                        if (overdueDays > 0) {
                            taskInfoVO.setOverdue("是");
                            taskInfoVO.setOverdueDays(overdueDays);
                        } else {
                            taskInfoVO.setOverdue("否");
                        }
                    }
                }
            });
        }


        //定义文件名称
        String sheetName = "任务数据";

        List<TaskInfoVO> records = taskInfoVOPagingVO.getRecords();
//        int order = 1;
//        for (TaskInfoVO record : records) {
//            record.setOrder(String.valueOf(order));
//            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
//            Integer isNeedPartner = record.getIsNeedPartner();
//            String isNeedPartnerStr = isNeedPartner == null ? "否" : isNeedPartner == 0 ? "是" : "否";
//            record.setIsNeedPartnerStr(isNeedPartnerStr);
//            record.setSourceType(record.getSourceType() == null ? null : record.getSourceType().equals("inside") ? "内部" : "外部");
//            Integer isOldCust = record.getIsOldCust();
//            String isOldCustStr = isOldCust == null ? "否" : isOldCust == 0 ? "是" : "否";
//            record.setIsOldCustStr(isOldCustStr);
//
//            List<PrjProjectMemberVO> memberVOS = record.getMemberVOS();
//            if (memberVOS != null && !memberVOS.isEmpty()) {
//                List<String> collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
//                String members = String.join(",", collect);
//                record.setMembers(members);
//            }
//            order++;
//        }
//        records = udcUtil.translateList(records);
//        List<CrmOpportunityExcelExport> resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);
//        resultList.forEach(e->e.setIsOldCust(e.getIsOldCustStr()));
        List<TaskInfoExcelExport> taskInfoExcelExportList = TaskInfoConvert.INSTANCE.toExcel(records);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), TaskInfoExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, TaskInfoExcelExport.class, null);

        for (TaskInfoExcelExport taskInfoExcelExport : taskInfoExcelExportList) {
            if (null != taskInfoExcelExport.getPlanStartDate()) {
                taskInfoExcelExport.setPlanStartDateStr(taskInfoExcelExport.getPlanStartDate().toString());
            }
            if (null != taskInfoExcelExport.getPlanEndDate()) {
                taskInfoExcelExport.setPlanEndDateStr(taskInfoExcelExport.getPlanEndDate().toString());
            }
            if (null != taskInfoExcelExport.getCreateTime()) {
                taskInfoExcelExport.setCreateTimeStr(taskInfoExcelExport.getCreateTime().toString());
            }

            // 剩余可用当量
            if (null != taskInfoExcelExport.getTotalEqva() && null != taskInfoExcelExport.getUsedEqva()) {
                taskInfoExcelExport.setEffectiveEqva(taskInfoExcelExport.getTotalEqva().subtract(taskInfoExcelExport.getUsedEqva()));
            }

            String evalStr = "否";
            if (taskInfoExcelExport.getEvaluationflag() != null && taskInfoExcelExport.getEvaluationflag() == 1) {
                evalStr = "是";
            }
            taskInfoExcelExport.setEvaluationflagStr(evalStr);
            // 任务负责人
            taskInfoExcelExport.setTaskRes(cacheUtil.getUserName(taskInfoExcelExport.getTaskResId()));
            taskInfoExcelExport.setDisterResName(cacheUtil.getUserName(taskInfoExcelExport.getDisterResId()));
            taskInfoExcelExport.setAss(cacheUtil.getUserName(taskInfoExcelExport.getAssId()));

            // udc
            taskInfoExcelExport.setReasonTypeDesc(cacheUtil.getSystemSelectionNameByValue("PMS:PROJECT:TYPE", taskInfoExcelExport.getReasonType()));
            taskInfoExcelExport.setTaskTypeDesc(cacheUtil.getSystemSelectionNameByValue("work:assignment:assignment_type", taskInfoExcelExport.getTaskType()));
            taskInfoExcelExport.setTaskStatusDesc(cacheUtil.getSystemSelectionNameByValue("PMS:TASK:STATUS", taskInfoExcelExport.getTaskStatus()));
        }
        //写入
        sheet.doWrite(taskInfoExcelExportList);

    }

    /**
     * 校验及赋值数据
     *
     * @param taskPayload
     */
    private List<Long> checkAndInitData(TaskPayload taskPayload) {
        if (!StringUtils.hasText(taskPayload.getReasonType())) {
            throw TwException.error("", "事由类型不可为空");
        }
        if (!StringUtils.hasText(taskPayload.getSourceType())) {
            throw TwException.error("", "任务来源类型不可为空");
        }
        if (taskPayload.getReasonId() == null) {
            throw TwException.error("", "事由id不可为空");
        }
        if (taskPayload.getSourceId() == null) {
            throw TwException.error("", "来源数据id不可为空");
        }
        if (ObjectUtils.isEmpty(taskPayload.getTaskInfoPayloads())) {
            throw TwException.error("", "派发任务不可为空");
        }
        Map<Long, TaskInfoPayload> userTaskInfoMap = new HashMap<>();
        taskPayload.getTaskInfoPayloads().forEach(taskInfoPayload -> {
            if (taskInfoPayload.getTaskResId() == null) {
                throw TwException.error("", "任务负责人不可为空");
            }
            if (taskInfoPayload.getPlanEqva() == null) {
                throw TwException.error("", "任务派发当量不可为空");
            }
            TaskInfoPayload taskInfoPayload1 = userTaskInfoMap.get(taskInfoPayload.getTaskResId());
            if (taskInfoPayload1 == null) {
                userTaskInfoMap.put(taskInfoPayload.getTaskResId(), taskInfoPayload);
            } else {
                //重新赋值计划当量
                taskInfoPayload1.setPlanEqva(taskInfoPayload1.getPlanEqva().add(taskInfoPayload.getPlanEqva()));
            }
            //赋值基础数据
            taskInfoPayload.setReasonId(taskPayload.getReasonId());
            taskInfoPayload.setReasonType(taskPayload.getReasonType());
            taskInfoPayload.setSourceId(taskPayload.getSourceId());
            taskInfoPayload.setSourceType(taskPayload.getSourceType());
            taskInfoPayload.setTaskApplyFlag(0);
            taskInfoPayload.setDisterResId(null);
            if (taskInfoPayload.getPlanStartDate() == null) {
                taskInfoPayload.setPlanStartDate(taskPayload.getPlanStartDate());
            }
            if (taskInfoPayload.getPlanEndDate() == null) {
                taskInfoPayload.setPlanEndDate(taskPayload.getPlanEndDate());
            }
            if (taskPayload.getSourceType().equals(TaskSourceTypeEnum.REWARD.getCode())) {
                //奖励假任务状态设为暂挂
                taskInfoPayload.setTaskName(taskPayload.getReasonName() + "-" + LocalDate.now() + "-奖励假");
                taskInfoPayload.setTaskStatus(TaskStatusEnum.PENDING.getCode());
                //默认当量全部审批通过
                taskInfoPayload.setApprovedEqva(taskInfoPayload.getPlanEqva());
            }
        });
        List<TaskInfoPayload> collect = userTaskInfoMap.values().stream().collect(Collectors.toList());
        //赋值合并后的任务
        taskPayload.setTaskInfoPayloads(collect);

        return userTaskInfoMap.keySet().stream().collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveChangeLog(TaskInfoPayload payload) {
        Long taskId = payload.getId();
        if (ObjectUtils.isEmpty(taskId)) {
            throw TwException.error("", "任务ID不能为空，请核验！");
        }
        BigDecimal additionEqva = payload.getAdditionEqva();
        if (ObjectUtils.isEmpty(additionEqva)) {
            throw TwException.error("", "变更当量数不能为空，请核验！");
        }
        BigDecimal planEqva = payload.getPlanEqva();
        if (ObjectUtils.isEmpty(planEqva)) {
            throw TwException.error("", "变更后任务当量数不能为空，请核验！");
        }
        Long taskPackageId = payload.getTaskPackageId();
        if (ObjectUtils.isEmpty(taskPackageId)) {
            throw TwException.error("", "任务包id不能为空，请核验！");
        }
        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(taskId);
        if (ObjectUtils.isEmpty(taskInfoVO)) {
            throw TwException.error("", "任务不存在，请核验！");
        }
        if (taskInfoVO.getTaskParentId() != null) {
            throw TwException.error("", "拆分任务不能当量调整");
        }
        if (!GlobalUtil.getLoginUserId().equals(taskInfoVO.getCreateUserId())) {
            throw TwException.error("", "只有发任务人可以对已发出的任务进行当量的调整");
        }
        //只有处理中的任务才可以进行任务的调整，发起调整流程后，状态变为暂挂
        if (!TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskStatus())) {
            throw TwException.error("", "只有处理中的任务才可以进行任务的调整");
        }
        // 变更逻辑要求 调整后的任务当量数不能小于已结算当量、  调整后的任务当量数不能小于拆分当量数
        if (taskInfoVO.getSettledEqva() != null) {
            if (planEqva.compareTo(taskInfoVO.getSettledEqva()) < 0) {
                throw TwException.error("", "当量数不能小于已结算当量，请核验！");
            }
        }
        if (taskInfoVO.getSplitEqva() != null) {
            if (planEqva.compareTo(taskInfoVO.getSplitEqva()) < 0) {
                throw TwException.error("", "当量数不能小于拆分当量数，请核验！");
            }
        }
        // 调整后的任务当量数 验证当量是否超出预算
        budgetCommonService.checkBudgetEqva(taskInfoVO.getReasonId(), taskInfoVO.getReasonType(), payload.getRelatedActId(), additionEqva);
        Long changeId = payload.getChangeId();

        ComChangePayload changePayload = new ComChangePayload();
        changePayload.setId(changeId);
        changePayload.setChangeContent(JSONObject.toJSONString(payload));
        //变更前值
        changePayload.setExtString1(taskInfoVO.getPlanEqva().toString());
        //变更后值
        changePayload.setExtString2(planEqva.toString());
        //变更值
        changePayload.setExtString3(additionEqva.toString());
        // 变更说明
        changePayload.setExtString4(payload.getChangeDes());
        //业务单据id
        changePayload.setChangeDocId(payload.getId() + "");
        if (ObjectUtils.isEmpty(changeId)) {
            changeId = changeService.save(ChangeTypeEnum.PMS_TASK_CHANGE.getCode(), taskInfoVO, payload, taskId.toString());
            changePayload.setId(changeId);
        } else {
            ComChangeVO comChangeVO = changeService.queryByKey(changeId);
            changePayload.setProcInstId(comChangeVO.getProcInstId());
        }
        if (payload.getChangeFlag()) {
            if (ObjectUtils.isEmpty(changePayload.getProcInstId())) {
                //发起变更审批流程
                // 总变更值
                BigDecimal totalAdditionEqva = taskInfoVO.getAdditionEqva().add(additionEqva);
                submitChangeProc(payload, changePayload, totalAdditionEqva);
            } else {
                changePayload.setApprStatus(ProcInstStatus.APPROVING.name());
                changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                changeService.updateByKeyDynamic(changePayload);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys, Boolean... isCheck) {
        //只有新建状态的任务可以删除
        if (CollectionUtils.isNotEmpty(keys)) {
            if (isCheck == null || isCheck.length == 0 || isCheck[0]) {
                List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByKeys(keys);
                if (CollectionUtils.isNotEmpty(taskInfoVOS)) {
                    for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                        if (!TaskStatusEnum.CREATE.getCode().equals(taskInfoVO.getTaskStatus())) {
                            throw TwException.error("", "只有新建状态的任务可以删除！");
                        }
                    }
                }
            }
            taskInfoDAO.deleteSoft(keys);
        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void taskApply(TaskPayload taskPayload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<TaskInfoPayload> taskInfoPayloads = taskPayload.getTaskInfoPayloads();
        if (ObjectUtils.isEmpty(taskInfoPayloads)) {
            throw TwException.error("", "任务不能为空，请核验！");
        }
        Set<Long> packageIds = new HashSet<>();
        taskInfoPayloads.forEach(v -> {
            if (v.getTaskPackageId() == null) {
                throw TwException.error("", "归属任务包不可为空");
            }
            v.setTaskApplyFlag(1);
            v.setTaskResId(loginUserId);
            packageIds.add(v.getTaskPackageId());
        });
        List<TaskPackageVO> taskPackageVOS = taskPackageDAO.queryByKeys(new ArrayList<>(packageIds));
        if (taskPackageVOS.size() != packageIds.size()) {
            throw TwException.error("", "归属任务包不存在");
        }
        BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(loginUserId, LocalDate.now());
        taskInfoPayloads.forEach(v -> {
            TaskPackageVO taskPackageVO = taskPackageVOS.stream().filter(packageVO -> packageVO.getId().equals(v.getTaskPackageId())).findFirst().get();
            if (taskPackageVO.getReceiverResId().longValue() != loginUserId.longValue()) {
                throw TwException.error("", "关联任务包不属于本人");
            }
            if ((taskPackageVO.getEqvaRatio() == null ? BigDecimal.ZERO : taskPackageVO.getEqvaRatio()).compareTo(eqvaRatio) != 0) {
                throw TwException.error("", "关联任务包当量系数:" + taskPackageVO.getEqvaRatio() + " 和当前系数不匹配:" + eqvaRatio);
            }
            v.setDisterResId(taskPackageVO.getDisterResId());
        });
//
//        long count = taskPackageVOS.stream().filter(vo -> vo.getReceiverResId().longValue() != loginUserId.longValue()).count();
//        if (count > 0) {
//            throw TwException.error("", "关联任务包不属于本人");
//        }
//        taskInfoVOS.forEach(vo -> {
//            TaskPackageVO taskPackageVO = taskPackageVOS.stream().filter(packageVO -> packageVO.getId().equals(vo.getTaskPackageId())).findFirst().get();
//            vo.setDisterResId(taskPackageVO.getDisterResId());
//            vo.setAcceptorId(taskPackageVO.getAcceptorId());
//        });
//        // 任务id集合
//        List<Long> taskIds = taskInfoVOS.stream().map(TaskInfoVO::getId).collect(Collectors.toList());
        //taskInfoVOS = taskInfoDAO.queryByKeys(taskIds);

        // 保存任务信息
        List<TaskInfoVO> taskInfoVOS = batchSave(taskInfoPayloads);
        // 判断是否要开启 申请流程
        if (taskPayload.getDistributeFlag()) {
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                submitApplyProc(taskInfoVO);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void operationTaskFinish(Long key, String operationStatus) {
        TaskInfoVO infoVO = taskInfoDAO.queryByKey0(key);
        if (infoVO != null && infoVO.getTaskStatus().equals(TaskStatusEnum.VALIDATING.getCode())) {
            if (!infoVO.getDisterResId().equals(GlobalUtil.getLoginUserId())) {
                throw TwException.error("", "仅支持派发资源操作");
            }
            TaskInfoPayload payload = new TaskInfoPayload();
            payload.setId(key);
            if (StringUtils.hasText(operationStatus) && "1".equals(operationStatus)) {
                payload.setTaskStatus(TaskStatusEnum.FINISHED.getCode());
//                payload.setReleaseEqva(infoVO.getTotalEqva().subtract(infoVO.getSettledEqva()));
//                payload.setTotalEqva(infoVO.getSettledEqva());
                payload.setTaskProgress(new BigDecimal(100));
            } else {
                payload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            }
            taskInfoDAO.updateByKeyDynamic(payload);
        } else {
            throw TwException.error("", "仅支持验收中的任务处理");
        }

    }

    @Override
    public void taskFinish(List<Long> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByKeys(keys);
            if (CollectionUtils.isNotEmpty(taskInfoVOS)) {
                Long loginUserId = GlobalUtil.getLoginUserId();
                // 只有接包人可以点击完工 只有处理中的任务才可以点击完工
                List<Long> taskIds = new ArrayList<>();
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    if (!loginUserId.equals(taskInfoVO.getTaskResId())) {
                        throw TwException.error("", "只有接包人可以点击完工");
                    }
                    if (!TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskStatus())) {
                        throw TwException.error("", "只有处理中的任务才可以点击完工");
                    }
                    taskIds.add(taskInfoVO.getId());
                }
                //关闭校验
                closeCheck(taskIds);
                // 完工时 任务总当量数 = 已结算当量数  , 任务进度变成100 , 状态改为验收中
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    TaskInfoPayload payload = new TaskInfoPayload();
                    payload.setId(taskInfoVO.getId());
//                    payload.setReleaseEqva(taskInfoVO.getTotalEqva().subtract(taskInfoVO.getSettledEqva()));
//                    payload.setTotalEqva(taskInfoVO.getSettledEqva());
//                    payload.setTaskProgress(new BigDecimal(100));
                    payload.setTaskStatus(TaskStatusEnum.VALIDATING.getCode());
                    taskInfoDAO.updateByKeyDynamic(payload);
                }
            }
        }
    }

    @Override
    public void taskClose(List<Long> keys) {
        if (CollectionUtils.isNotEmpty(keys)) {
            List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByKeys(keys);
            if (CollectionUtils.isNotEmpty(taskInfoVOS)) {
                Long loginUserId = GlobalUtil.getLoginUserId();
                // 只有接包人可以点击完工 只有处理中的任务才可以点击完工
                List<Long> taskIds = new ArrayList<>();
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    if (!loginUserId.equals(taskInfoVO.getDisterResId()) && !loginUserId.equals(taskInfoVO.getDisterPackegeResId())) {
                        throw TwException.error("", "没有关闭权限");
                    }
                    //List<String> strings = Arrays.asList(TaskStatusEnum.INPROCESS.getCode(), TaskStatusEnum.VALIDATING.getCode(), TaskStatusEnum.FINISHED.getCode());
                    if (!getEffectiveTaskStatus().contains(taskInfoVO.getTaskStatus())) {
                        throw TwException.error("", "存在不支持关闭的任务状态");
                    }
                    taskIds.add(taskInfoVO.getId());
                }
                //关闭校验
                closeCheck(taskIds);
                // 完工时 任务总当量数 = 已结算当量数  , 任务进度变成100 , 状态改为验收中

                //0424 关闭任务 任务总当量=已使用当量
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    TaskInfoPayload payload = new TaskInfoPayload();
                    payload.setId(taskInfoVO.getId());
                    BigDecimal settledEqva = taskInfoVO.getSettledEqva() == null ? BigDecimal.ZERO : taskInfoVO.getSettledEqva();
                    BigDecimal usedEqva = taskInfoVO.getUsedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getUsedEqva();
                    BigDecimal approvedEqva = taskInfoVO.getApprovedEqva() == null ? BigDecimal.ZERO : taskInfoVO.getApprovedEqva();
                    if (approvedEqva.compareTo(usedEqva) > 0) {
                        usedEqva = approvedEqva;
                    }
                    if (settledEqva.compareTo(usedEqva) > 0) {
                        usedEqva = settledEqva;
                    }

                    payload.setReleaseEqva(taskInfoVO.getTotalEqva().subtract(usedEqva));
                    payload.setTotalEqva(usedEqva);
                    payload.setTaskProgress(new BigDecimal(100));
                    payload.setTaskStatus(TaskStatusEnum.CLOSED.getCode());
                    taskInfoDAO.updateByKeyDynamic(payload);
                }
            }
        }
    }

    /**
     * 关闭任务校验
     *
     * @param taskIds
     */
    void closeCheck(List<Long> taskIds) {
        /**
         *  1.要检验有没有审批中的工时
         *  2.有没有在结算中的申请
         */
//                List<String> strings = Arrays.asList(TimesheetStatus.APPROVING.getCode(), TimesheetStatus.REJECTED.getCode());
//                List<TimesheetVO> timesheetVOS = taskCommonService.queryTaskTimeSheets(taskIds, strings);
//                if (!ObjectUtils.isEmpty(timesheetVOS)) {
//                    throw TwException.error("", "存在审批中或已退回工时");
//                }
        List<String> settleStatus = Arrays.asList(CalSettleStatusEnum.CREATE.getCode(), CalSettleStatusEnum.IN_PROCESS.getCode(), CalSettleStatusEnum.REJECTED.getCode());

        List<String> settleDetails = calTaskSettleDetailService.queryTaskSettleDetails(taskIds, settleStatus);
        if (!ObjectUtils.isEmpty(settleDetails)) {
            throw TwException.error("", "存在结算中或结算未通过结算单,结算单号【" + String.join(",", settleDetails) + "】");
        }
    }

    @Override
    public long findAcceptCount(Long userId) {
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskStatus(TaskStatusEnum.VALIDATING.getCode());
        taskInfoQuery.setDisterResId(userId);
        List<TaskInfoVO> list = taskInfoDAO.queryListDynamic(taskInfoQuery);
        if (!ObjectUtils.isEmpty(list)) {
            return list.size();
        }
        return 0;
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey0(Long.valueOf(businessKey));

        if (taskInfoVO != null) {
            TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
            taskInfoPayload.setId(Long.parseLong(businessKey));
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                case INVALID://作废 删除单据
                    taskInfoPayload.setDeleteFlag(1);
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.CREATE.getCode());
                    break;
                case APPROVED:
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
                    break;
                case APPROVING:
                    taskInfoPayload.setTaskStatus(TaskStatusEnum.APPLYING.getCode());
                    break;
            }
            taskInfoDAO.updateByKeyDynamic(taskInfoPayload);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processChangeStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        ComChangeVO comChangeVO = changeService.queryByKey(Long.valueOf(businessKey));
        if (comChangeVO != null) {
            ComChangePayload changePayload = new ComChangePayload();
            changePayload.setId(comChangeVO.getId());
            changePayload.setApprStatus(procInstStatus.name());
            changePayload.setProcInstId(comChangeVO.getProcInstId());

            TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
            taskInfoPayload.setId(Long.valueOf(comChangeVO.getChangeDocId()));
            taskInfoPayload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    changePayload.setChangeStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"草稿",并且将单据上的"流程实例状态"，"流程实例ID"清成null(不是空字符串)
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    changePayload.setChangeStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    changePayload.setProcInstId(null);
                    changePayload.setDeleteFlag(1);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    changePayload.setChangeStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                case APPROVED:
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    taskInfoPayload = JSON.parseObject(comChangeVO.getChangeContent(), TaskInfoPayload.class);
                    TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(taskInfoPayload.getId());
                    BigDecimal addEqva = taskInfoPayload.getAdditionEqva();
                    taskInfoPayload.setAdditionEqva(taskInfoVO.getAdditionEqva().add(addEqva));

                    taskInfoPayload.setTotalEqva(taskInfoVO.getTotalEqva().add(addEqva));
                    break;
                case APPROVING:
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    break;
            }
            taskInfoDAO.updateByKeyDynamic(taskInfoPayload);
            changeService.updateWorkFlow(changePayload);
        }
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(TaskInfoPayload payload) {
        return taskInfoDAO.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional
    public void updateTaskProgress(Long key, BigDecimal progress) {
        // 进度在0 和100之间
        if (progress.compareTo(BigDecimal.ZERO) < 0 || progress.compareTo(BigDecimal.valueOf(100)) > 0) {
            throw TwException.error("", "进度必须在0和100之间");
        }
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(key);
        payload.setTaskProgress(progress);
        taskInfoDAO.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional
    public void updateSettledEqva(Long key, BigDecimal eqva) {
        if (ObjectUtils.isEmpty(key)) {
            throw TwException.error("", "任务主键不能为空");
        }
        if (ObjectUtils.isEmpty(eqva) && eqva.compareTo(BigDecimal.ZERO) < 0) {
            throw TwException.error("", "结算当量不能小于0");
        }
        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(key);
        if (ObjectUtils.isEmpty(taskInfoVO)) {
            throw TwException.error("", "任务不存在");
        }
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(key);
        BigDecimal settledEqva = taskInfoVO.getSettledEqva();
        payload.setSettledEqva(settledEqva == null ? eqva : settledEqva.add(eqva));

        // 判断是否要单价结算
        if (PricingMethodEnum.SINGLE.getCode().equals(taskInfoVO.getPricingMethod())) {
            // 只有执行中 可以完工
            if (TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskStatus())) {
                // 如果总当量 == 已结算当量  自动发完工
                if (taskInfoVO.getTotalEqva().compareTo(payload.getSettledEqva()) == 0) {
                    payload.setReleaseEqva(BigDecimal.ZERO);
                    payload.setTaskProgress(new BigDecimal(100));
                    payload.setTaskStatus(TaskStatusEnum.VALIDATING.getCode());
                    //  taskInfoDAO.updateByKeyDynamic(payload);
                }
            }
        }
        log.info("taskInfoVO::3");
        if (StringUtils.hasText(taskInfoVO.getSourceType()) && TaskSourceTypeEnum.REWARD.getCode().equals(taskInfoVO.getSourceType())) {
            log.info("taskInfoVO::4");
            //奖励假任务包
            payload.setReleaseEqva(BigDecimal.ZERO);
            payload.setTaskProgress(new BigDecimal(100));
            payload.setTaskStatus(TaskStatusEnum.CLOSED.getCode());
            payload.setUsedEqva(eqva);
            payload.setApprovedEqva(eqva);
        }
        taskInfoDAO.updateByKeyDynamic(payload);
    }


    /**
     * 发起任务申请流程
     */
    void submitApplyProc(TaskInfoVO taskInfoVO) {
        //流程启动成功后，回写业务表数据
        TaskInfoPayload payload = new TaskInfoPayload();
        payload.setId(taskInfoVO.getId());
        if (!StringUtils.hasText(taskInfoVO.getTaskApplyProcessId())) {
            HashMap<String, Object> variables = new HashMap<>();
            // 发包人确认
            variables.put("Activity_0os8qgd", taskInfoVO.getDisterResId());
            //T05.任务名称-申请(接包人)
            String procInstName = "T05." + taskInfoVO.getTaskName() + "-申请(" + cacheUtil.getUserName(taskInfoVO.getTaskResId()) + ")";
            //发起流程审批
            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    PmsProcDefKey.PMS_TASK_APPLY.name(),
                    procInstName,
                    taskInfoVO.getId() + "",
                    variables)
            );

            payload.setTaskApplyProcessId(processInfo.getProcInstId());
            if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
                payload.setTaskStatus(TaskStatusEnum.APPLYING.getCode());
            } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
                payload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            }
        } else {
            payload.setTaskApplyProcessId(taskInfoVO.getTaskApplyProcessId());
            payload.setTaskStatus(TaskStatusEnum.APPLYING.getCode());
        }
        taskInfoDAO.updateByKeyDynamic(payload);
    }

    /**
     * 发起变更审批流程
     */
    void submitChangeProc(TaskInfoPayload payload, ComChangePayload changePayload, BigDecimal totalAdditionEqva) {
        HashMap<String, Object> variables = new HashMap<>();
        // 任务负责人确认
        variables.put("Activity_1qxwk5g", payload.getTaskResId());
        //T03.任务名称-变更(派发人-接收人)
        String procInstName = "T03." + payload.getTaskName() + "-变更(" + cacheUtil.getUserName(payload.getCreateUserId()) + "-" + cacheUtil.getUserName(payload.getTaskResId()) + ")";
        //发起流程审批
        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                PmsProcDefKey.PMS_TASK_CHANGE.name(),
                procInstName,
                changePayload.getId() + "",
                variables)
        );
        //流程启动成功后，回写业务表数据
        changePayload.setProcInstId(processInfo.getProcInstId());

        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            // 发起调整流程后，状态变为暂挂
            TaskInfoPayload payload0 = new TaskInfoPayload();
            payload0.setId(payload.getId());
            payload0.setTaskStatus(TaskStatusEnum.PENDING.getCode());
            taskInfoDAO.updateByKeyDynamic(payload0);

            changePayload.setApprStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        } else if (ProcInstStatus.APPROVED.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            payload.setTaskStatus(TaskStatusEnum.INPROCESS.getCode());
            payload.setAdditionEqva(totalAdditionEqva);
            payload.setTotalEqva(payload.getPlanEqva());
            taskInfoDAO.updateByKeyDynamic(payload);
            changePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        }
        changeService.updateByKeyDynamic(changePayload);
    }


    /**
     * 数据 验证
     *
     * @param taskInfoPayload
     */
    TaskInfoDO getData(TaskInfoPayload taskInfoPayload) {
        if (ObjectUtils.isEmpty(taskInfoPayload.getTaskPackageId())) {
            throw TwException.error("", "任务包ID不能为空，请核验！");
        }
        String reasonType = taskInfoPayload.getReasonType();
        if (ObjectUtils.isEmpty(reasonType)) {
            throw TwException.error("", "事由类型不能为空，请核验！");
        }
        Long reasonId = taskInfoPayload.getReasonId();
        if (ObjectUtils.isEmpty(reasonId)) {
            throw TwException.error("", "事由Id不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskInfoPayload.getTaskResId())) {
            throw TwException.error("", "任务负责人不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskInfoPayload.getPlanStartDate())) {
            throw TwException.error("", "预计开始日期不能为空，请核验！");
        }
        if (ObjectUtils.isEmpty(taskInfoPayload.getPlanEndDate())) {
            throw TwException.error("", "预计结束日期不能为空，请核验！");
        }
        if (taskInfoPayload.getPlanEqva() == null || taskInfoPayload.getPlanEqva().compareTo(BigDecimal.ZERO) <= 0) {
            throw TwException.error("", "派发当量不合规，请核验！");
        }
//        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
//            if (ObjectUtils.isEmpty(taskInfoPayload.getRelatedActId())) {
//                throw TwException.error("", "活动Id不能为空，请核验！");
//            }
//            if (ObjectUtils.isEmpty(taskInfoPayload.getRelatedAct())) {
//                throw TwException.error("", "活动名称不能为空，请核验！");
//            }
//        }
        if (!ObjectUtils.isEmpty(taskInfoPayload.getRelatedActId())) {
            if (ObjectUtils.isEmpty(taskInfoPayload.getRelatedAct())) {
                throw TwException.error("", "活动名称不能为空，请核验！");
            }
        }
        if (ObjectUtils.isEmpty(taskInfoPayload.getId())) {
            // TK+两位年份+两位月份+两位日期+三位序列号 TK231130001
            taskInfoPayload.setTaskNo(generateSeqNum("TASK_NO"));
        }
        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(taskInfoPayload.getTaskResId());
        if (!employee.getResourceStatus().equals(SystemDefaultEnum.DefaultResourceStatus.getCode()) && !employee.getResourceStatus().equals(SystemDefaultEnum.LeaveIngResourceStatus.getCode())) {
            throw TwException.error("", "接包资源状态暂不可接收任务派发");
        }
        if (!employee.getHrStatus().equals(SystemDefaultEnum.DefaultHrStatus.getCode())) {
            throw TwException.error("", "接包资源状态暂不可接收任务派发");
        }
        taskInfoPayload.setOriginalEqva(taskInfoPayload.getPlanEqva());
        taskInfoPayload.setSettledEqva(BigDecimal.ZERO);
        taskInfoPayload.setAdditionEqva(BigDecimal.ZERO);
        taskInfoPayload.setSplitEqva(BigDecimal.ZERO);
        taskInfoPayload.setUsedEqva(BigDecimal.ZERO);
        taskInfoPayload.setReleaseEqva(BigDecimal.ZERO);
        taskInfoPayload.setApprovedEqva(BigDecimal.ZERO);
        taskInfoPayload.setValidEqva(BigDecimal.ZERO);
        taskInfoPayload.setEvaluationflag(0);
        taskInfoPayload.setTaskProgress(BigDecimal.ZERO);
        taskInfoPayload.setTotalEqva(taskInfoPayload.getPlanEqva());
        return TaskInfoConvert.INSTANCE.toDo(taskInfoPayload);
    }

    @Override
    public List<TaskInfoVO> queryTaskSettleList(TaskInfoQuery taskInfoQuery) {
        return taskInfoDAO.queryTaskSettleList(taskInfoQuery);
    }

    @Override
    public void taskAssign(List<Long> keys) {
        //只有新建状态的任务可以派发
        if (CollectionUtils.isNotEmpty(keys)) {
            List<TaskInfoVO> taskInfoVOS = taskInfoDAO.queryByKeys(keys);
            if (CollectionUtils.isNotEmpty(taskInfoVOS)) {
                for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                    if (!TaskStatusEnum.CREATE.getCode().equals(taskInfoVO.getTaskStatus())) {
                        throw TwException.error("", "只有新建状态的任务可以派发！");
                    }
                }
            }
            List<PmsDistributeVO> pmsDistributeVOS = pmsDistributeService.queryByReasons(keys, DistributeEnum.distType.TASK.getCode());
            if (!ObjectUtils.isEmpty(pmsDistributeVOS)) {
                throw TwException.error("", "任务【" + pmsDistributeVOS.get(0).getReasonName() + "】已创建派发流程，请在“流程代办”中再次派发处理");
            }
            // 发起派发流程
            for (TaskInfoVO taskInfoVO : taskInfoVOS) {
                //任务派发
                startDistributeProcess(taskInfoVO.getId());
            }
        }
    }

    @Override
    public void taskOpertionBySource(String sourceType, Long sourceId, ProcInstStatus procInstStatus) {
        if (!StringUtils.hasText(sourceType)) {
            throw TwException.error("", "任务来源类型不可为空");
        }
        if (sourceId == null) {
            throw TwException.error("", "来源数据id不可为空");
        }
        if (procInstStatus == null) {
            throw TwException.error("", "审批状态不可为空");
        }
        log.info("sourceType:" + sourceType + " /sourceId:" + sourceId + " /procInstStatus:" + procInstStatus.name());
        //0:不处理，1：开启结算，2：//删除任务
        int operType = 0;
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                //一般情况将单据状态变成"新建",流程状态改为未提交
                operType = 2;
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                operType = 2;
                break;
            case INVALID://作废 先删除流程再删除单据
                //一般情况将单据状态变成"作废" ，或直接删除单据
                operType = 2;
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                //将单据状态变为新建状态
                operType = 2;
                break;
            case APPROVED:
                //一般情况将单据状态变成"激活"
                operType = 1;
                break;
            case APPROVING:
                break;
        }
        if (operType > 0) {
            //进行数据处理
            TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
            taskInfoQuery.setTaskStatus(TaskStatusEnum.PENDING.getCode());
            taskInfoQuery.setSourceType(sourceType);
            taskInfoQuery.setSourceId(sourceId);
            List<TaskInfoVO> taskInfoVOS = queryTaskSimpleList(taskInfoQuery);
            if (!ObjectUtils.isEmpty(taskInfoVOS)) {
//                if (operType == 1) {
//                    //240516 奖励假逻辑修改，不再自动结算#17097
//                    //发起结算
//                    taskInfoVOS.forEach(vo -> vo.setApprovedEqva(vo.getPlanEqva()));
//                    Map<Long, List<TaskInfoVO>> maps = taskInfoVOS.stream().collect(Collectors.groupingBy(TaskInfoVO::getTaskPackageId));
//                    TaskPackageQuery taskPackageQuery = new TaskPackageQuery();
//                    taskPackageQuery.setIds(new ArrayList<>(maps.keySet()));
//                    List<TaskPackageVO> taskPackageVOS = taskPackageService.taskPackageList(taskPackageQuery);
//                    if (!ObjectUtils.isEmpty(taskPackageVOS)) {
//                        //自动结算
//                        taskAutoSettle(maps, taskPackageVOS, new ArrayList<Long>().add(0L));
//
//                    }
//                }
                if (operType == 2) {
                    //删除任务
                    List<Long> collect = taskInfoVOS.stream().map(TaskInfoVO::getId).collect(Collectors.toList());
                    deleteSoft(collect, false);
                }

            }
        }

    }

    /**
     * 任务派发
     *
     * @param key
     */
    void startDistributeProcess(Long key) {
        PmsDistributePayload payload = new PmsDistributePayload();
        payload.setReasonType(DistributeEnum.distType.TASK.getCode());
        payload.setReasonId(key);

        TaskInfoVO taskInfoVO = taskInfoDAO.queryByKey(key);
        if (!StringUtils.hasText(taskInfoVO.getTaskPackageStatus()) || !TaskStatusEnum.INPROCESS.getCode().equals(taskInfoVO.getTaskPackageStatus())) {
            throw TwException.error("", "仅支持处理中任务包下的任务派发");
        }
        BigDecimal eqvaRatio = prdOrgEmployeeEqvaRatioService.getEqvaRatio(taskInfoVO.getTaskResId(), LocalDate.now());
        if ((taskInfoVO.getEqvaRatio() == null ? BigDecimal.ZERO : taskInfoVO.getEqvaRatio()).compareTo(eqvaRatio) != 0) {
            throw TwException.error("", "关联任务包当量系数:" + taskInfoVO.getEqvaRatio() + " 和当前系数不匹配:" + eqvaRatio);
        }
        payload.setReasonName(taskInfoVO.getTaskName());
        payload.setDisterResId(taskInfoVO.getDisterResId());
        payload.setDisterResName(cacheUtil.getUserName(taskInfoVO.getDisterResId()));
        payload.setReceiverResId(taskInfoVO.getTaskResId());
        payload.setReceiverResName(cacheUtil.getUserName(taskInfoVO.getTaskResId()));
        payload.setDistMethod(DistributeEnum.distMethod.DESIGNATE.getCode());
        payload.setDistDesc(taskInfoVO.getTaskDes());
        // payload.setCapasetLevelId();
        payload.setPlanStartDate(taskInfoVO.getPlanStartDate());
        payload.setPlanEndDate(taskInfoVO.getPlanEndDate());
        pmsDistributeService.insertOrUpdate(payload);
    }

    @Override
    public Long countBySceneId(Long x) {
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setTaskSceneId(x);
        long res = taskInfoDAO.count(taskInfoQuery);
        return res;
    }

    @Override
    public Long countByFlowId(List<Long> ids) {
        TaskInfoQuery taskInfoQuery = new TaskInfoQuery();
        taskInfoQuery.setStateFlowIds(ids);
        long count = taskInfoDAO.count(taskInfoQuery);
        return count;
    }
    @Override
    public List<TaskProBoardVO> boardView(TaskInfoQuery taskInfoQuery) {

        Assert.notNull(taskInfoQuery.getTaskSceneId(), "任务场景id不能为空");
        List<TaskProBoardVO> resultList = new ArrayList<>();
        // 根据任务场景id查询状态流id
        TaskSceneVO taskSceneVO = taskSceneService.queryByKey(taskInfoQuery.getTaskSceneId());

        TaskCategoryVO taskCategoryVO = taskCategoryService.queryByKey(taskSceneVO.getCategoryId());

        StateFlowQuery stateFlowQuery = new StateFlowQuery();

        stateFlowQuery.setObjId(taskCategoryVO.getId());
        OrderItem orderItem = OrderItem.desc("sort");
        OrderItem orderItem2 = OrderItem.asc("createTime");
        List<OrderItem> orderItemList = new ArrayList<>();
        orderItemList.add(orderItem);
        orderItemList.add(orderItem2);
        stateFlowQuery.setOrders(orderItemList);
        List<StateFlowVO> stateFlowVOList = stateFlowService.getList(stateFlowQuery);
        for (StateFlowVO stateFlowVO : stateFlowVOList) {
            TaskProBoardVO taskProBoardVO = new TaskProBoardVO();
            taskProBoardVO.setName(stateFlowVO.getName());
            taskProBoardVO.setState(stateFlowVO.getState());
            taskProBoardVO.setStateFlowCode(stateFlowVO.getCode());
            taskProBoardVO.setStateFlowId(stateFlowVO.getId());
            taskProBoardVO.setBackgroundColor(stateFlowVO.getBackgroundColor());
            taskProBoardVO.setFontColor(stateFlowVO.getFontColor());
            taskProBoardVO.setVersionId(stateFlowVO.getVersionId());
            taskProBoardVO.setVersionNo(stateFlowVO.getVersionNo());
            taskProBoardVO.setProgressPercentage(stateFlowVO.getProgressPercentage());
            // 获取任务列表

            taskInfoQuery.setStateFlowCode(stateFlowVO.getCode());
            taskInfoQuery.setStateFlowId(null);
            Long loginUserId = GlobalUtil.getLoginUserId();
            if (taskInfoQuery.getSearchType() != null) {

                if (taskInfoQuery.getSearchType() == 1) {
                    //我接收的
                    taskInfoQuery.setTaskResId(loginUserId);
                    taskInfoQuery.setTaskStatusFlag(0);
//                    List<String> strings = Arrays.asList(TaskStatusEnum.INPROCESS.getCode());
                    List<String> strings = Arrays.asList(TaskStatusEnum.CREATE.getCode(), TaskStatusEnum.DISPATCH.getCode());
                    taskInfoQuery.setTaskStatuss(strings);
                }
                if (taskInfoQuery.getSearchType() == 2) {
                    //我派发的
                    taskInfoQuery.setDisterResId(loginUserId);
                }
            } else {
                //处理权限
                taskInfoQuery.setLoginUserId(loginUserId);
                operPermissionFlag(taskInfoQuery);

            }
            List<TaskInfoVO> taskInfoVOS = queryListCommon(taskInfoQuery);
            List<OrderItem> taskOrderItemList = new ArrayList<>();
//            taskOrderItemList.add(OrderItem.desc("topFlag"));
//            taskOrderItemList.add(OrderItem.desc("topModifyTime"));
//            taskOrderItemList.add(OrderItem.desc("sort"));
//            taskOrderItemList.add(OrderItem.desc("createTime"));
//            taskInfoVOS.setOrders(taskOrderItemList);
            taskProBoardVO.setTaskList(taskInfoVOS);
            resultList.add(taskProBoardVO);
        }

        return resultList;
    }

    @Override
    public List<TaskInfoVO> relateList(Long id) {
        TaskInfoVO taskInfoVO = this.queryByKey(id, false);
        if (taskInfoVO == null) {
            throw new BusinessException("id有误:" + id);
        }
        // 查询上下级任务
        List<TaskInfoVO> taskInfoVOList = this.queryRelateTaskList(taskInfoVO);
        taskInfoVOList.forEach(x -> {
            if (x.getTaskParentId() != null) {
                if (taskInfoVO.getId().equals(x.getTaskParentId())) {
                    x.setRelateDesc("子级任务");
                }
            }
            if (taskInfoVO.getTaskParentId() != null) {
                if (taskInfoVO.getTaskParentId().equals(x.getId())) {
                    x.setRelateDesc("父级任务");
                }
            }


            BigDecimal totalEqva = x.getTotalEqva();
            BigDecimal settledEqva = x.getSettledEqva() == null ? BigDecimal.ZERO : x.getSettledEqva();
            BigDecimal occupyEqva = totalEqva.subtract(settledEqva);
            x.setOccupyEqva(occupyEqva);
            x.setCreator(cacheUtil.getUserName(x.getCreateUserId()));
            if (x.getPlanEndDate() != null) {
                Period period = Period.between(x.getPlanEndDate(), LocalDate.now());
                int overdueDays = period.getDays();
                if (overdueDays > 0) {
                    x.setOverdue("是");
                    x.setOverdueDays(overdueDays);
                } else {
                    x.setOverdue("否");
                }
            }
            if (!ObjectUtils.isEmpty(x.getStateFlowId())) {
                StateFlowVO stateFlowVO = stateFlowService.get(x.getStateFlowId());
                x.setStateFlowName(stateFlowVO.getName());
                x.setReferenceTaskProgress(stateFlowVO.getProgressPercentage());
            }
            this.dealNullStateFlowNane(x);

        });

        return taskInfoVOList;
    }
    private void dealNullStateFlowNane(TaskInfoVO taskInfoVO) {
        if (taskInfoVO != null) {
            if (taskInfoVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())
                    || taskInfoVO.getTaskStatus().equals(TaskStatusEnum.DISPATCH.getCode())) {
                taskInfoVO.setStateFlowName(Strings.EMPTY);
                taskInfoVO.setStateFlowId(null);
                taskInfoVO.setStateFlowCode(Strings.EMPTY);
            }

        }
    }
    private List<TaskInfoVO> queryRelateTaskList(TaskInfoVO taskInfoVO) {

        Assert.notNull(taskInfoVO.getId(), "id不能为空");
        List<TaskInfoVO> res = taskInfoDAO.queryRelateTaskList(taskInfoVO);
        return res;
    }
    @Override
    @Transactional
    public Long updateTaskStateFlowId(TaskInfoPayload taskInfoPayload) {

        TaskInfoVO taskInfoVO = this.queryByKey(taskInfoPayload.getId(), false);

        StateFlowVO stateFlowOldVO = stateFlowService.get(taskInfoVO.getStateFlowId());

        Assert.notNull(taskInfoPayload.getId(), "id不能为空");
        Assert.notNull(taskInfoPayload.getStateFlowId(), "stateFlowId不能为空");
        Assert.notNull(taskInfoPayload.getStateFlowCode(), "stateFlowCode不能为空");
        Assert.notNull(taskInfoPayload.getStateFlowVersionNo(), "stateFlowVersionNo不能为空");

        StateFlowVO stateFlowNewVO = stateFlowService.get(taskInfoPayload.getStateFlowId());
        if (null != stateFlowNewVO) {
            if (stateFlowNewVO.getState() == 3) {
                // 修改任务状态为已完成
                taskInfoPayload.setTaskStatus(TaskStatusEnum.FINISHED.getCode());
                taskInfoPayload.setTaskProgress(new BigDecimal("100"));
            }
        }
        // 修改任务
        Long res = taskInfoDAO.updateByKeyDynamic(taskInfoPayload);

        String userName = GlobalUtil.getLoginUserName();
        String oldFlowName = "";
        if (null != stateFlowOldVO) {
            oldFlowName = stateFlowOldVO.getName();
        }
        String newFlowName = "";
        if (null != stateFlowNewVO) {
            newFlowName = stateFlowNewVO.getName();
        }

        logService.saveNewLog(taskInfoPayload.getId(), "PMS_TASK_PRO", userName + "状态：由" + oldFlowName + " 修改为 " + newFlowName);

        return res;
    }

    @Override
    @Transactional
    public Long updateDynamic(TaskInfoPayload taskInfoPayload) {

        Assert.notNull(taskInfoPayload.getId(), "id不能为空");
        long res = taskInfoDAO.updateByKeyDynamic(taskInfoPayload);
        return res;
    }
}
