package com.elitesland.tw.tw5.server.prd.task.service.inf;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRouteDtlPayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteDtlQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteDtlVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import java.util.List;


/**
 * 任务路线图明细service
 * @author wangxl
 * @date 2024/4/28
 */
public interface PmsTaskRouteDtlService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsTaskRouteDtlVO>> queryPage(PmsTaskRouteDtlQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsTaskRouteDtlVO>> queryList(PmsTaskRouteDtlQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsTaskRouteDtlQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsTaskRouteDtlVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsTaskRouteDtlVO> insert(PmsTaskRouteDtlPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsTaskRouteDtlVO> update(PmsTaskRouteDtlPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsTaskRouteDtlVO> updateDynamic(PmsTaskRouteDtlPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

    /**
     * 获取路线图列表-子集
     * @param query
     * @return
     */
    TwOutputUtil<PmsTaskRouteDtlVO> childList(PmsTaskRouteDtlQuery query);
}