package com.elitesland.tw.tw5.server.prd.task.service.inf;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRoutePayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteQuery;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import java.util.List;


/**
 * 任务路线图service
 * @author wangxl
 * @date 2024/4/18
 */
public interface PmsTaskRouteService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PmsTaskRouteVO>> queryPage(PmsTaskRouteQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PmsTaskRouteVO>> queryList(PmsTaskRouteQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PmsTaskRouteQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PmsTaskRouteVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsTaskRouteVO> insert(PmsTaskRoutePayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsTaskRouteVO> update(PmsTaskRoutePayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PmsTaskRouteVO> updateDynamic(PmsTaskRoutePayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

    /**
     * 获取任务路线图列表查询
     * @param query
     * @return
     */
    TwOutputUtil<List<PmsTaskRouteVO>> childList(PmsTaskRouteQuery query);
}