package com.elitesland.tw.tw5.server.prd.taskpro.constants;

import lombok.Getter;

/**
 * task-pro事件枚举
 *
 * @author duwh
 * @date 2024/03/06
 */
public enum TaskProEventEnum {

    WBS_ACT_LIST("WBS_ACT_LIST", "活动清单"),

    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    TaskProEventEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TaskProEventEnum getByCode(String code) {
        for (TaskProEventEnum value : TaskProEventEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
