package com.elitesland.tw.tw5.server.prd.taskpro.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskSceneCategoryRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneCategoryRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneCategoryRefVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneCategoryRefService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 任务场景类别关系表
 *
 * @author duwh
 * @date 2024-01-31
 */
@Api(tags = "任务场景类别关系表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/taskSceneCategoryRef")
@Slf4j
public class TaskSceneCategoryRefController {

    private final TaskSceneCategoryRefService taskSceneCategoryRefService;

    /**
     * 任务场景类别关系表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("任务场景类别关系表-新增")
    public TwOutputUtil<TaskSceneCategoryRefVO> insert(@RequestBody TaskSceneCategoryRefPayload payload){
        return TwOutputUtil.ok(taskSceneCategoryRefService.insert(payload));
    }

    /**
     * 任务场景类别关系表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("任务场景类别关系表-更新")
    public TwOutputUtil<TaskSceneCategoryRefVO> update(@RequestBody TaskSceneCategoryRefPayload payload){
        return TwOutputUtil.ok(taskSceneCategoryRefService.update(payload));
    }

    /**
     * 任务场景类别关系表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("任务场景类别关系表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TaskSceneCategoryRefPayload payload){
        return TwOutputUtil.ok(taskSceneCategoryRefService.updateByKeyDynamic(payload));
    }

    /**
     * 任务场景类别关系表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("任务场景类别关系表-主键查询")
    public TwOutputUtil<TaskSceneCategoryRefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskSceneCategoryRefService.queryByKey(key));
    }

    /**
     * 任务场景类别关系表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("任务场景类别关系表-分页")
    public TwOutputUtil<PagingVO<TaskSceneCategoryRefVO>>  paging(TaskSceneCategoryRefQuery query) {
        return TwOutputUtil.ok(taskSceneCategoryRefService.queryPaging(query));
    }

    /**
     * 任务场景类别关系表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("任务场景类别关系表-查询列表")
    public TwOutputUtil<List<TaskSceneCategoryRefVO>> queryList(TaskSceneCategoryRefQuery query) {
        return TwOutputUtil.ok(taskSceneCategoryRefService.queryListDynamic(query));
    }

    /**
     * 任务场景类别关系表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务场景类别关系表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskSceneCategoryRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
