package com.elitesland.tw.tw5.server.prd.taskpro.model.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 任务类别
 *
 * @author duwh
 * @date 2024-01-31
 */
@Entity
@Table(name = "pms_task_category", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_task_category", comment = "任务类别")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskCategoryDO extends BaseModel implements Serializable  {
    /** 任务类别名称 */
    @Comment("任务类别名称")
    @Column()
    private String name;
    /** 任务类别说明 */
    @Comment("任务类别说明")
    @Column()
    private String content;
    /** 是否启用 */
    @Comment("是否启用")
    @Column()
    private Boolean enabled;
    /** 排序 */
    @Comment("排序")
    @Column()
    private Integer sort;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(TaskCategoryDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
