package com.elitesland.tw.tw5.server.prd.taskpro.model.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
@Entity
@Table(name = "pms_task_pro", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "pms_task_pro", comment = "任务主档")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TaskProDO extends BaseModel implements Serializable {
    /**
     * 父主键
     */
    @Comment("父主键")
    @Column()
    private Long parentId;
    /**
     * 事由类型
     */
    @Comment("事由类型")
    @Column()
    private String reasonType;
    /**
     * 事由id
     */
    @Comment("事由id")
    @Column()
    private Long reasonId;
    @Comment("活动清单主键 pms_project_wbs.id")
    @Column()
    private Long wbsId;
    @Comment("活动清单名称（冗余 pms_project_wbs.wbs_name")
    @Column()
    private String wbsName;
    /**
     * 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]
     */
    @Comment("可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]")
    @Column()
    @FieldUpdateLog(fieldName = "可见范围", selectionKey = "PMS:TASK_PRO:SHOW_SCOPE")
    private String showScope;
    /**
     * 任务编号
     */
    @Comment("任务编号")
    @Column()
    private String taskNo;
    /**
     * 任务名称
     */
    @Comment("任务名称")
    @Column()
    @FieldUpdateLog(fieldName = "任务标题")
    private String taskName;
    /**
     * 任务状态
     */
    @Comment("任务状态 udc[PMS:TASK_PRO:STATUS]")
    @Column()
    private String taskStatus;
    /**
     * 状态流id
     */
    @Comment("状态流id")
    @Column()
    private Long stateFlowId;
    /**
     * 状态流名称(冗余）
     */
    @Comment("状态流名称(冗余）")
    @Column()
    @FieldUpdateLog(fieldName = "状态")
    private String stateFlowName;

    /**
     * 任务类别
     */
    @Comment("任务类别")
    @Column()
    private Long taskCategoryId;
    /**
     * 任务类别名称
     */
    @Comment("任务类别名称")
    @Column()
    @FieldUpdateLog(fieldName = "任务类别")
    private String taskCategoryName;
    /**
     * 优先级 UDC[PMS:TASK_PRO:PRIORITY]
     */
    @Comment("优先级 UDC[PMS:TASK_PRO:PRIORITY]")
    @Column()
    @FieldUpdateLog(fieldName = "优先级", selectionKey = "PMS:TASK_PRO:PRIORITY")
    private String priority;
    /**
     * 发包userId
     */
    @Comment("发包userId")
    @Column()
    private Long disterUserId;
    /**
     * 负责人userId
     */
    @Comment("负责人userId")
    @Column()
    private Long directorUserId;
    /**
     * 负责人相关方id pro_related_parties.id
     */
    @Comment("负责人相关方id pro_related_parties.id")
    @Column()
    private Long directorRelatedPartiesId;
    @Transient
    @FieldUpdateLog(fieldName = "负责人")
    private String directorRelatedPartiesName;
    /**
     * 费用承担bu_id
     */
    @Comment("费用承担bu_id")
    @Column()
    private Long expenseBuId;
    /**
     * 接收资源bu_id
     */
    @Comment("接收资源bu_id")
    @Column()
    private Long receiverBuId;
    /**
     * 接收userId
     */
    @Comment("接收userId")
    @Column()
    private Long receiverUserId;
    /**
     * 资源来源类型
     */
    @Comment("资源来源类型")
    @Column()
    private String resSourceType;
    /**
     * 预估工时
     */
    @Comment("预估工时")
    @Column()
    private BigDecimal predictWorkHours;
    @Transient
    @FieldUpdateLog(fieldName = "预估工时")
    private Integer predictWorkHoursChangeLog;

    public Integer getPredictWorkHoursChangeLog() {
        if (null != predictWorkHours) {
            return predictWorkHours.intValue();
        }
        return predictWorkHoursChangeLog;
    }

    /**
     * 实际工时
     */
    @Comment("实际工时")
    @Column()
    private BigDecimal actualWorkHours;
    @Transient
    @FieldUpdateLog(fieldName = "实际工时")
    private Integer actualWorkHoursChangeLog;

    public Integer getActualWorkHoursChangeLog() {
        if (null != actualWorkHours) {
            return actualWorkHours.intValue();
        }
        return actualWorkHoursChangeLog;
    }

    /**
     * 完工百分比
     */
    @Comment("完工百分比")
    @Column()
    private BigDecimal finishRate;
    /**
     * 计划开始日期
     */
    @Comment("计划开始日期")
    @Column()
    @FieldUpdateLog(fieldName = "开始日期")
    private LocalDate planStartDate;
    /**
     * 计划结束日期
     */
    @Comment("计划结束日期")
    @Column()
    @FieldUpdateLog(fieldName = "结束日期")
    private LocalDate planEndDate;
    /**
     * 实际开始日期
     */
    @Comment("实际开始日期")
    @Column()
    @FieldUpdateLog(fieldName = "实际开始日期")
    private LocalDate actualStartDate;
    /**
     * 实际结束日期
     */
    @Comment("实际结束日期")
    @Column()
    @FieldUpdateLog(fieldName = "实际结束日期")
    private LocalDate actualEndDate;
    /**
     * 任务类型
     */
    @Comment("任务类型")
    @Column()
    private String taskType;
    /**
     * 任务包关闭时间
     */
    @Comment("任务包关闭时间")
    @Column()
    private LocalDateTime closedTime;
    /**
     * 发包日期
     */
    @Comment("发包日期")
    @Column()
    private LocalDate distDate;
    /**
     * 系统自动建包
     */
    @Comment("系统自动建包")
    @Column()
    private Boolean autoCreateFlag;
    /**
     * 描述内容
     */
    @Comment("描述内容")
    @Column()
    @FieldUpdateLog(fieldName = "描述")
    private String content;
    /**
     * 排序
     */
    @Comment("排序")
    @Column()
    private Integer sort;
    /**
     * 是否置顶
     */
    @Comment("是否置顶")
    @Column()
    private Boolean topFlag;
    /**
     * 置顶操作时间
     */
    @Comment("置顶操作时间")
    @Column()
    private LocalDateTime topModifyTime;

    @Comment("创建人相关方id pro_related_parties.id")
    @Column()
    private Long createRelatedPartiesId;
    @Comment("创建人相关方id pro_related_parties.name (冗余)")
    @Column()
    private String createRelatedPartiesName;
    /**
     * 拓展字段1
     */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /**
     * 拓展字段2
     */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /**
     * 拓展字段3
     */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /**
     * 拓展字段4
     */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /**
     * 拓展字段5
     */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    public void copy(TaskProDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
