package com.elitesland.tw.tw5.server.prd.taskpro.model.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
@Getter
@Setter
public class TaskProPayload extends TwCommonPayload  implements Serializable {
    /** 父主键 */
    @ApiModelProperty("父主键")
    private Long parentId;
    /** 事由类型 */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /** 事由id */
    @ApiModelProperty("事由id")
    private Long reasonId;

    /**
     * 活动清单主键 pms_project_wbs.id
     */
    private Long wbsId;

    /**
     * 活动清单名称
     */
    private String wbsName;

    /** 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE] */
    @ApiModelProperty("可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]")
    private String showScope;
    /** 任务编号 */
    @ApiModelProperty("任务编号")
    private String taskNo;
    /** 任务名称 */
    @ApiModelProperty("任务名称")
    private String taskName;
    /** 任务状态  udc[PMS:TASK_PRO:STATUS] */
    @ApiModelProperty("任务状态 udc[PMS:TASK_PRO:STATUS]")
    private String taskStatus;
    /** 任务类别 */
    @ApiModelProperty("任务类别")
    private Long taskCategoryId;
    /** 任务类别名称（冗余） */
    @ApiModelProperty("任务类别名称（冗余）")
    private String taskCategoryName;
    /**
     * 状态流id
     */
    private Long stateFlowId;
    /**
     * 状态流名称(冗余）
     */
    private String stateFlowName;
    /** 优先级 UDC[PMS:TASK_PRO:PRIORITY] */
    @ApiModelProperty("优先级 UDC[PMS:TASK_PRO:PRIORITY]")
    private String priority;
    /** 发包userId */
    @ApiModelProperty("发包userId")
    private Long disterUserId;
    /** 负责人userId */
    @ApiModelProperty("负责人userId")
    private Long directorUserId;
    /** 负责人相关方id pro_related_parties.id */
    @ApiModelProperty("负责人相关方id pro_related_parties.id")
    private Long directorRelatedPartiesId;

    /**
     * 负责人相关方 项目角色主键
     */
    private Long directorRelatedPartiesRoleId;
    /** 费用承担bu_id */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /** 接收资源bu_id */
    @ApiModelProperty("接收资源bu_id")
    private Long receiverBuId;
    /** 接收userId */
    @ApiModelProperty("接收userId")
    private Long receiverUserId;
    /** 资源来源类型 */
    @ApiModelProperty("资源来源类型")
    private String resSourceType;
    /** 预估工时 */
    @ApiModelProperty("预估工时")
    private BigDecimal predictWorkHours;
    /** 实际工时 */
    @ApiModelProperty("实际工时")
    private BigDecimal actualWorkHours;
    /** 完工百分比 */
    @ApiModelProperty("完工百分比")
    private BigDecimal finishRate;
    /** 计划开始日期 */
    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    /** 计划结束日期 */
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    /** 实际开始日期 */
    @ApiModelProperty("实际开始日期")
    private LocalDate actualStartDate;
    /** 实际结束日期 */
    @ApiModelProperty("实际结束日期")
    private LocalDate actualEndDate;
    /** 任务类型 */
    @ApiModelProperty("任务类型")
    private String taskType;
    /** 任务包关闭时间 */
    @ApiModelProperty("任务包关闭时间")
    private LocalDateTime closedTime;
    /** 发包日期 */
    @ApiModelProperty("发包日期")
    private LocalDate distDate;
    /** 系统自动建包 */
    @ApiModelProperty("系统自动建包")
    private Boolean autoCreateFlag;
    /** 描述内容 */
    @ApiModelProperty("描述内容")
    private String content;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 是否置顶 */
    @ApiModelProperty("是否置顶")
    private Boolean topFlag;
    /** 置顶操作时间 */
    @ApiModelProperty("置顶操作时间")
    private LocalDateTime topModifyTime;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    // 参与人(相关方)
    private List<Long> memberFollowIdList;
    // 参与人（相关方））
    private List<Long> memberPartIdList;


    /**
     * 创建人相关方id
     */
    private Long createRelatedPartiesId;
    /**
     * 创建关联方名称
     */
    private String createRelatedPartiesName;


}
