package com.elitesland.tw.tw5.server.prd.taskpro.model.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 任务类别
 *
 * @author duwh
 * @date 2024-01-31
 */
@Getter
@Setter
public class TaskCategoryQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * id不等于
     */
    private Long idNeq;
    private List<Long> idList;
    /** 任务类别名称 模糊 */
    @ApiModelProperty("任务类别名称")
    private String name;
    private String nameEq;
    /** 任务类别说明 精确 */
    @ApiModelProperty("任务类别说明")
    private String content;
    /** 是否启用 精确 */
    @ApiModelProperty("是否启用")
    private Boolean enabled;
    /** 排序 精确 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 精确 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 精确 */
    @ApiModelProperty("拓展字段5")
    private String ext5;
}
