package com.elitesland.tw.tw5.server.prd.taskpro.model.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
@Getter
@Setter
public class TaskProQuery extends TwQueryParam implements Serializable {

    private String searchType;
    /**
     * 相对方id列表
     */
    private Collection<Long> relatedIdList;
    /**
     * 主键 精确
     */
    @ApiModelProperty("主键")
    private Long id;
    /**
     * id集合
     */
    private List<Long> idList;
    /**
     * 父主键 精确
     */
    @ApiModelProperty("父主键")
    private Long parentId;
    @ApiModelProperty("是否只查询一级任务")
    private Boolean parentNullFlag = false;
    /**
     * 事由类型 精确
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /**
     * 事由id 精确
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 活动清单主键 pms_project_wbs.id
     */
    private Long wbsId;
    /**
     * 活动清单名称
     */
    private String wbsName;
    /**
     * 事由id 精确
     */
    @ApiModelProperty("事由id集合")
    private List<Long> reasonIdList;
    /**
     * 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE] 精确
     */
    @ApiModelProperty("可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]")
    private String showScope;
    /**
     * 任务编号 精确
     */
    @ApiModelProperty("任务编号")
    private String taskNo;
    /**
     * 任务名称 精确
     */
    @ApiModelProperty("任务名称")
    private String taskName;
    /**
     * 任务状态 精确
     */
    @ApiModelProperty("任务状态 udc[PMS:TASK_PRO:STATUS]")
    private String taskStatus;
    /**
     * 任务类别 精确
     */
    @ApiModelProperty("任务类别")
    private Long taskCategoryId;
    /**
     * 任务类别名称 精确
     */
    @ApiModelProperty("任务类别名称")
    private String taskCategoryName;
    /**
     * 状态流id
     */
    private Long stateFlowId;

    private List<Long> stateFlowIdList;
    /**
     * 状态流名称(冗余）
     */
    private String stateFlowName;
    /**
     * 优先级 UDC[PMS:TASK_PRO:PRIORITY] 精确
     */
    @ApiModelProperty("优先级 UDC[PMS:TASK_PRO:PRIORITY]")
    private String priority;
    /**
     * 发包userId 精确
     */
    @ApiModelProperty("发包userId")
    private Long disterUserId;
    /**
     * 负责人userId 精确
     */
    @ApiModelProperty("负责人userId")
    private Long directorUserId;
    /**
     * 负责人userIdList 精确
     */
    @ApiModelProperty("负责人userIdList")
    private List<Long> directorUserIdList;
    /**
     * 负责人相关方id pro_related_parties.id 精确
     */
    @ApiModelProperty("负责人相关方id pro_related_parties.id")
    private Long directorRelatedPartiesId;
    /**
     * 费用承担bu_id 精确
     */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /**
     * 接收资源bu_id 精确
     */
    @ApiModelProperty("接收资源bu_id")
    private Long receiverBuId;
    /**
     * 接收userId 精确
     */
    @ApiModelProperty("接收userId")
    private Long receiverUserId;
    /**
     * 资源来源类型 精确
     */
    @ApiModelProperty("资源来源类型")
    private String resSourceType;
    /**
     * 预估工时 精确
     */
    @ApiModelProperty("预估工时")
    private BigDecimal predictWorkHours;
    /**
     * 实际工时 精确
     */
    @ApiModelProperty("实际工时")
    private BigDecimal actualWorkHours;
    /**
     * 完工百分比 精确
     */
    @ApiModelProperty("完工百分比")
    private BigDecimal finishRate;
    /**
     * 计划开始日期 精确
     */
    @ApiModelProperty("计划开始日期")
    private LocalDate planStartDate;
    /**
     * 计划结束日期 精确
     */
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    /**
     * 实际开始日期 精确
     */
    @ApiModelProperty("实际开始日期")
    private LocalDate actualStartDate;
    /**
     * 实际结束日期 精确
     */
    @ApiModelProperty("实际结束日期")
    private LocalDate actualEndDate;
    /**
     * 任务类型 精确
     */
    @ApiModelProperty("任务类型")
    private String taskType;
    /**
     * 任务包关闭时间 精确
     */
    @ApiModelProperty("任务包关闭时间")
    private LocalDateTime closedTime;
    /**
     * 发包日期 精确
     */
    @ApiModelProperty("发包日期")
    private LocalDate distDate;
    /**
     * 系统自动建包 精确
     */
    @ApiModelProperty("系统自动建包")
    private Boolean autoCreateFlag;
    /**
     * 描述内容 精确
     */
    @ApiModelProperty("描述内容")
    private String content;
    /**
     * 排序 精确
     */
    @ApiModelProperty("排序")
    private Integer sort;
    /**
     * 是否置顶 精确
     */
    @ApiModelProperty("是否置顶")
    private Boolean topFlag;
    /**
     * 置顶操作时间 精确
     */
    @ApiModelProperty("置顶操作时间")
    private LocalDateTime topModifyTime;
    /**
     * 拓展字段1 精确
     */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /**
     * 拓展字段2 精确
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3 精确
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4 精确
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5 精确
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    @ApiModelProperty("负责人相关方id pro_related_parties.id")
    private List<Long> directorRelatedPartiesIdList;

    /**
     * 创建人相关方id
     */
    private Long createRelatedPartiesId;
    /**
     * 创建关联方名称
     */
    private String createRelatedPartiesName;


}
