package com.elitesland.tw.tw5.server.prd.taskpro.model.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;


/**
  * 任务主档
  *
  * @author duwh
  * @date 2024-02-01
  */
@Data
@ExcelIgnoreUnannotated
public class TaskProExcelVO {
    /** 父主键 */
    @ApiModelProperty("父主键")
    private Long parentId;
    /** 事由类型 */
    @ApiModelProperty("事由类型")
    private String reasonType;
    /** 事由id */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /** 可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE] */
    @ApiModelProperty("可见范围 UDC[PMS:TASK_PRO:SHOW_SCOPE]")
    private String showScope;
    @UdcName(udcName = "PMS:TASK_PRO:SHOW_SCOPE", codePropName = "showScope")
    private String showScopeDesc;
    /** 任务编号 */
    @ApiModelProperty("任务编号")
    @ExcelProperty(value = "任务编号",index = 0)
    private String taskNo;
    /** 任务名称 */
    @ApiModelProperty("任务名称")
    @ExcelProperty(value = "任务标题",index = 1)
    private String taskName;
    /** 任务状态 */
    @ApiModelProperty("任务状态 udc[PMS:TASK_PRO:STATUS]")
    private String taskStatus;
    @UdcName(udcName = "PMS:TASK_PRO:STATUS", codePropName = "taskStatus")

    private String taskStatusDesc;
    /** 任务类别 */
    @ApiModelProperty("任务类别")
    private Long taskCategoryId;
    /** 任务类别名称 */
    @ApiModelProperty("任务类别名称")
    private String taskCategoryName;
    /**
     * 状态流id
     */
    private Long stateFlowId;
    /**
     * 状态流名称(冗余）
     */
    @ExcelProperty(value = "状态",index = 2)
    private String stateFlowName;
    /** 优先级 UDC[PMS:TASK_PRO:PRIORITY] */
    @ApiModelProperty("优先级 UDC[PMS:TASK_PRO:PRIORITY]")
    private String priority;
    @UdcName(udcName = "PMS:TASK_PRO:PRIORITY", codePropName = "priority")
    private String priorityDesc;
    /** 发包userId */
    @ApiModelProperty("发包userId")
    private Long disterUserId;
    /** 负责人userId */
    @ApiModelProperty("负责人userId")
    private Long directorUserId;
    /** 负责人用户名 **/
    @UdcName(udcName = "USER", codePropName = "directorUserId")
    private String directorUserName;
    /** 负责人相关方id pro_related_parties.id */
    @ApiModelProperty("负责人相关方id pro_related_parties.id")
    private Long directorRelatedPartiesId;
    /*
     * 负责人相关方名称
     */
    @ExcelProperty(value = "负责人",index = 4)
    private String directorRelatedPartiesName;
    /** 费用承担bu_id */
    @ApiModelProperty("费用承担bu_id")
    private Long expenseBuId;
    /** 接收资源bu_id */
    @ApiModelProperty("接收资源bu_id")
    private Long receiverBuId;
    /** 接收userId */
    @ApiModelProperty("接收userId")
    private Long receiverUserId;
    @UdcName(udcName = "USER", codePropName = "receiverUserId")
    private String receiverUserName;
    /** 资源来源类型 */
    @ApiModelProperty("资源来源类型")
    private String resSourceType;
    /** 预估工时 */
    @ApiModelProperty("预估工时")
    private BigDecimal predictWorkHours;
    /** 实际工时 */
    @ApiModelProperty("实际工时")
    private BigDecimal actualWorkHours;
    /** 完工百分比 */
    @ApiModelProperty("完工百分比")
    private BigDecimal finishRate;
    /** 计划开始日期 */
    @ApiModelProperty("计划开始日期")

    private LocalDate planStartDate;
    @ExcelProperty(value = "开始时间",index = 5)
    private String planStartDateStr;
    /** 计划结束日期 */
    @ApiModelProperty("计划结束日期")
    private LocalDate planEndDate;
    @ExcelProperty(value = "结束时间",index = 6)
    private String planEndDateStr;

    public String getPlanStartDateStr() {
        if (null != planStartDate) {
            String format = planStartDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return format;
        }
        return planStartDateStr;
    }

    public String getPlanEndDateStr() {
        if (null != planEndDate) {
            String format = planEndDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return format;
        }
        return planEndDateStr;
    }

    /** 实际开始日期 */
    @ApiModelProperty("实际开始日期")
    private LocalDate actualStartDate;
    /** 实际结束日期 */
    @ApiModelProperty("实际结束日期")
    private LocalDate actualEndDate;
    /** 任务类型 */
    @ApiModelProperty("任务类型")
    private String taskType;
    /** 任务包关闭时间 */
    @ApiModelProperty("任务包关闭时间")
    private LocalDateTime closedTime;
    /** 发包日期 */
    @ApiModelProperty("发包日期")
    private LocalDate distDate;
    /** 系统自动建包 */
    @ApiModelProperty("系统自动建包")
    private Boolean autoCreateFlag;
    /** 描述内容 */
    @ApiModelProperty("描述内容")
    private String content;
    /** 排序 */
    @ApiModelProperty("排序")
    private Integer sort;
    /** 是否置顶 */
    @ApiModelProperty("是否置顶")
    private Boolean topFlag;
    /** 置顶操作时间 */
    @ApiModelProperty("置顶操作时间")
    private LocalDateTime topModifyTime;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /** 拓展字段4 */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /** 拓展字段5 */
    @ApiModelProperty("拓展字段5")
    private String ext5;

    /** 通用任务成员关系集合 */
    @ApiModelProperty("通用任务成员关系集合")
    private List<TaskMemberRefVO> taskMemberRefList;

    // 关注人(相关方)
    private List<Long> memberFollowIdList;
    private List<String> memberFollowNameList;

    private String memberFollowNames;

    public String getMemberFollowNames() {
        if (memberFollowNameList != null && memberFollowNameList.size() > 0) {
            memberFollowNames = memberFollowNameList.stream().collect(Collectors.joining(","));
        } else {
            memberFollowNames = "";
        }
        return memberFollowNames;
    }

    public String getMemberPartNames() {
        if (memberPartNameList != null && memberPartNameList.size() > 0) {
            memberPartNames = memberPartNameList.stream().collect(Collectors.joining(","));
        } else {
            memberPartNames = "";
        }
        return memberPartNames;
    }

    // 参与人（相关方））
    private List<Long> memberPartIdList;
    private List<String> memberPartNameList;
    @ExcelProperty(value = "参与人",index = 3)
    private String memberPartNames;


}
