package com.elitesland.tw.tw5.server.prd.taskpro.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskSceneCategoryRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneCategoryRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneCategoryRefVO;

import java.util.List;

/**
 * 任务场景类别关系表
 *
 * @author duwh
 * @date 2024-01-31
 */
public interface TaskSceneCategoryRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskSceneCategoryRefVO}>
     */
    PagingVO<TaskSceneCategoryRefVO> queryPaging(TaskSceneCategoryRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskSceneCategoryRefVO}>
     */
    List<TaskSceneCategoryRefVO> queryListDynamic(TaskSceneCategoryRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskSceneCategoryRefVO}
     */
    TaskSceneCategoryRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskSceneCategoryRefVO}
     */
    TaskSceneCategoryRefVO insert(TaskSceneCategoryRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskSceneCategoryRefVO}
     */
    TaskSceneCategoryRefVO update(TaskSceneCategoryRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TaskSceneCategoryRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 按场景id删除soft
     *
     * @param sceneId 场景id
     * @return long
     */
    long deleteSoftBySceneId(Long sceneId);

    long deleteSoftBySceneIdList(List<Long> sceneIdList);
}
