package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskMemberRefConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskMemberRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskMemberRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskMemberRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskMemberRefRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskMemberRefDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskMemberRefService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 通用任务成员关系
 *
 * @author duwh
 * @date 2024-02-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskMemberRefServiceImpl extends BaseServiceImpl implements TaskMemberRefService {

    private final TaskMemberRefRepo taskMemberRefRepo;
    private final TaskMemberRefDAO taskMemberRefDAO;

    @Override
    public PagingVO<TaskMemberRefVO> queryPaging(TaskMemberRefQuery query){
        return taskMemberRefDAO.queryPaging(query);
    }

    @Override
    public List<TaskMemberRefVO> queryListDynamic(TaskMemberRefQuery query){
        return taskMemberRefDAO.queryListDynamic(query);
    }

    @Override
    public TaskMemberRefVO queryByKey(Long key) {
        TaskMemberRefDO entity = taskMemberRefRepo.findById(key).orElseGet(TaskMemberRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskMemberRefVO vo = TaskMemberRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskMemberRefVO insert(TaskMemberRefPayload payload) {
        TaskMemberRefDO entityDo = TaskMemberRefConvert.INSTANCE.toDo(payload);
        return TaskMemberRefConvert.INSTANCE.toVo(taskMemberRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskMemberRefVO update(TaskMemberRefPayload payload) {
        TaskMemberRefDO entity = taskMemberRefRepo.findById(payload.getId()).orElseGet(TaskMemberRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskMemberRefDO entityDo = TaskMemberRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskMemberRefConvert.INSTANCE.toVo(taskMemberRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TaskMemberRefPayload payload) {
        TaskMemberRefDO entity = taskMemberRefRepo.findById(payload.getId()).orElseGet(TaskMemberRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = taskMemberRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                taskMemberRefDAO.deleteSoft(keys);
            });
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long deleteSoftByTaskId(Long taskId) {
        if (taskId != null) {
            return taskMemberRefDAO.deleteSoftByTaskId(taskId);
        }
        return 0;
    }

}
