package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskSceneCategoryRefConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskSceneCategoryRefDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskSceneCategoryRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneCategoryRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneCategoryRefVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskSceneCategoryRefRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskSceneCategoryRefDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneCategoryRefService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 任务场景类别关系表
 *
 * @author duwh
 * @date 2024-01-31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskSceneCategoryRefServiceImpl extends BaseServiceImpl implements TaskSceneCategoryRefService {

    private final TaskSceneCategoryRefRepo taskSceneCategoryRefRepo;
    private final TaskSceneCategoryRefDAO taskSceneCategoryRefDAO;

    @Override
    public PagingVO<TaskSceneCategoryRefVO> queryPaging(TaskSceneCategoryRefQuery query){
        return taskSceneCategoryRefDAO.queryPaging(query);
    }

    @Override
    public List<TaskSceneCategoryRefVO> queryListDynamic(TaskSceneCategoryRefQuery query){
        return taskSceneCategoryRefDAO.queryListDynamic(query);
    }

    @Override
    public TaskSceneCategoryRefVO queryByKey(Long key) {
        TaskSceneCategoryRefDO entity = taskSceneCategoryRefRepo.findById(key).orElseGet(TaskSceneCategoryRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskSceneCategoryRefVO vo = TaskSceneCategoryRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskSceneCategoryRefVO insert(TaskSceneCategoryRefPayload payload) {
        TaskSceneCategoryRefDO entityDo = TaskSceneCategoryRefConvert.INSTANCE.toDo(payload);
        return TaskSceneCategoryRefConvert.INSTANCE.toVo(taskSceneCategoryRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskSceneCategoryRefVO update(TaskSceneCategoryRefPayload payload) {
        TaskSceneCategoryRefDO entity = taskSceneCategoryRefRepo.findById(payload.getId()).orElseGet(TaskSceneCategoryRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TaskSceneCategoryRefDO entityDo = TaskSceneCategoryRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskSceneCategoryRefConvert.INSTANCE.toVo(taskSceneCategoryRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TaskSceneCategoryRefPayload payload) {
        TaskSceneCategoryRefDO entity = taskSceneCategoryRefRepo.findById(payload.getId()).orElseGet(TaskSceneCategoryRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = taskSceneCategoryRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            taskSceneCategoryRefDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional
    public long deleteSoftBySceneId(Long sceneId) {
        return taskSceneCategoryRefDAO.deleteSoftBySceneId(sceneId);
    }

    @Override
    @Transactional
    public long deleteSoftBySceneIdList(List<Long> sceneIdList) {
        return taskSceneCategoryRefDAO.deleteSoftBySceneIdList(sceneIdList);
    }

}
