package com.elitesland.tw.tw5.server.prd.ts.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalResService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.prd.ts.convert.TsApprovalResConvert;
import com.elitesland.tw.tw5.server.prd.ts.dao.TsApprovalResDAO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsApprovalResDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsApprovalResRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 工时审批资源管理
 *
 * @author carl
 * @date 2024-05-04
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TsApprovalResServiceImpl extends BaseServiceImpl implements TsApprovalResService {

    private final TsApprovalResRepo tsApprovalResRepo;
    private final TsApprovalResDAO tsApprovalResDAO;

    @Override
    public PagingVO<TsApprovalResVO> queryPaging(TsApprovalResQuery query) {
        return tsApprovalResDAO.queryPaging(query);
    }

    @Override
    public List<TsApprovalResVO> queryListDynamic(TsApprovalResQuery query) {
        return tsApprovalResDAO.queryListDynamic(query);
    }

    @Override
    public TsApprovalResVO queryByKey(Long key) {
        TsApprovalResDO entity = tsApprovalResRepo.findById(key).orElseGet(TsApprovalResDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsApprovalResVO vo = TsApprovalResConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsApprovalResVO insert(TsApprovalResPayload payload) {
        TsApprovalResDO entityDo = TsApprovalResConvert.INSTANCE.toDo(payload);
        return TsApprovalResConvert.INSTANCE.toVo(tsApprovalResRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TsApprovalResVO update(TsApprovalResPayload payload) {
        TsApprovalResDO entity = tsApprovalResRepo.findById(payload.getId()).orElseGet(TsApprovalResDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TsApprovalResDO entityDo = TsApprovalResConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TsApprovalResConvert.INSTANCE.toVo(tsApprovalResRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TsApprovalResPayload payload) {
        TsApprovalResDO entity = tsApprovalResRepo.findById(payload.getId()).orElseGet(TsApprovalResDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tsApprovalResDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tsApprovalResDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByTimesheetId(Long timesheetId){
        if (timesheetId != null) {
            tsApprovalResDAO.deleteSoftByTimesheetId(timesheetId);
        }
    }

}
