package com.elitesland.tw.tw5.server.yeedocref.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.Consts;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.yeedocref.model.payload.PrdYeedocRefPayload;
import com.elitesland.tw.tw5.server.yeedocref.model.query.PrdYeedocRefQuery;
import com.elitesland.tw.tw5.server.yeedocref.model.vo.PrdYeedocRefVO;
import com.elitesland.tw.tw5.server.yeedocref.service.PrdYeedocRefService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 易稻壳/通用文件夹关系表/通用易稻壳文件夹关系表
 * @author duwh
 * @date 2024/3/22
*/
@RestController
@RequestMapping(Consts.URI_PREFIX + "/yeedocRef")
@RequiredArgsConstructor
@Slf4j
@Api(value = "通用易稻壳文件夹关系表", tags = {"通用易稻壳文件夹关系表"})
public class PrdYeedocRefController {

    private final PrdYeedocRefService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PrdYeedocRefVO>> page(PrdYeedocRefQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PrdYeedocRefVO>> list(PrdYeedocRefQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PrdYeedocRefVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PrdYeedocRefVO> insert(@RequestBody PrdYeedocRefPayload payload) {
        // 关键日志打印
        log.debug("【PrdYeedocRefController.insert】入参："+payload.toString());
        return service.insert(payload);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PrdYeedocRefVO> update(@RequestBody PrdYeedocRefPayload payload) {
        // 关键日志打印
        log.debug("【PrdYeedocRefController.update】入参："+payload.toString());
        return service.update(payload);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PrdYeedocRefVO> updateDynamic(@RequestBody PrdYeedocRefPayload payload) {
        // 关键日志打印
        log.debug("【PrdYeedocRefController.updateDynamic】入参："+payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PrdYeedocRefController.deleteSoft】入参："+ids);
        return service.deleteSoft(ids);
    }
}
