package com.elitesland.tw.tw5.server.yeedocref.model.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 通用易稻壳文件夹关系表payload
 * @author duwh
 * @date 2024/3/22
*/
@Data
@ApiModel(description = "通用易稻壳文件夹关系表payload")
public class PrdYeedocRefPayload extends TwCommonPayload {

    @ApiModelProperty("关联业务主键类型 PROJECT 项目 其他..")
    private String refType;
    
    @ApiModelProperty("关联业务主键 如：项目id")
    private Long refId;
    
    @ApiModelProperty("易稻壳文件夹id")
    private String itemId;
    
    @ApiModelProperty("易稻壳库id")
    private String libraryId;
    
    @ApiModelProperty("文件夹名称（冗余）")
    private String itemName;
    
    @ApiModelProperty("拓展字段1")
    private String extString1;
    
    @ApiModelProperty("拓展字段3")
    private String extString3;
    
    @ApiModelProperty("拓展字段2")
    private String extString2;
    
}