package com.elitesland.tw.tw5.server.yeedocref.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.yeedocref.constants.YeedocRefTypeEnum;
import com.elitesland.tw.tw5.server.yeedocref.dao.PrdYeedocRefDao;
import com.elitesland.tw.tw5.server.yeedocref.model.payload.PrdYeedocRefPayload;
import com.elitesland.tw.tw5.server.yeedocref.model.query.PrdYeedocRefQuery;
import com.elitesland.tw.tw5.server.yeedocref.model.vo.PrdYeedocRefVO;
import com.elitesland.tw.tw5.server.yeedocref.service.PrdYeedocRefService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * 通用易稻壳文件夹关系表service impl
 * @author duwh
 * @date 2024/3/22
*/
@Slf4j
@Service
@RequiredArgsConstructor
public class PrdYeedocRefServiceImpl implements PrdYeedocRefService {

    private final PrdYeedocRefDao dao;

    @Override
    public TwOutputUtil<PagingVO<PrdYeedocRefVO>> queryPage(PrdYeedocRefQuery query) {
        PagingVO<PrdYeedocRefVO> pageVO = dao.queryPage(query);
        translate(pageVO.getRecords());
        return TwOutputUtil.ok(pageVO);
    }

    @Override
    public TwOutputUtil<List<PrdYeedocRefVO>> queryList(PrdYeedocRefQuery query) {
        List<PrdYeedocRefVO> listVO = dao.queryList(query);
        translate(listVO);
        return TwOutputUtil.ok(listVO);
    }

    @Override
    public TwOutputUtil<Long> queryCount(PrdYeedocRefQuery query) {
        return TwOutputUtil.ok(dao.queryCount(query));
    }

    @Override
    public TwOutputUtil<PrdYeedocRefVO> queryByKey(Long id) {
        if (null == id) {return null;}
        PrdYeedocRefVO vo = dao.queryByKey(id);
        Assert.notNull(vo,"查询的数据不存在");
        translate(List.of(vo));
        return TwOutputUtil.ok(vo);
    }

    @Override
    @Transactional
    public TwOutputUtil<PrdYeedocRefVO> insert(PrdYeedocRefPayload payload) {
        // 检查数据局
        checkData(payload);
        // 保存数据
        PrdYeedocRefVO save = dao.save(payload);
        // todo 开启工作流
        // startWorkFlow(ado);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PrdYeedocRefVO> update(PrdYeedocRefPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        PrdYeedocRefVO save = dao.save(payload);
        return queryByKey(save.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<PrdYeedocRefVO> updateDynamic(PrdYeedocRefPayload payload) {
        Assert.notNull(payload.getId(), "id不能为空");
        // 检查数据局
        checkData(payload);
        // 保存数据
        dao.updateByKeyDynamic(payload);
        return queryByKey(payload.getId());
    }

    @Override
    @Transactional
    public TwOutputUtil<Long> deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw  TwException.error("","ids参数不能为空");
        }
        return TwOutputUtil.ok(dao.deleteSoft(ids));
    }

    @Override
    public PrdYeedocRefVO queryByRefTypeAndRefId(YeedocRefTypeEnum yeedocRefTypeEnum, Long projectId) {
        Assert.notNull(yeedocRefTypeEnum, "yeedocRefTypeEnum不能为空");
        Assert.notNull(projectId, "projectId不能为空");
        PrdYeedocRefVO result  = dao.queryByRefTypeAndRefId(yeedocRefTypeEnum, projectId);
        return result;
    }


    /**
     * 发起工作流
     * @param payload payload
     * @return result
     */
    // private TwOutputUtil<Long> startWorkFlow(PrdYeedocRefPayload payload) {
//         // 发起工作流程
//         HashMap<String, Object> varMaps = new HashMap<>();
//         Assert.notNull(payload.getUserId(), "userId不能为空");
//         // 变更资源审批
//         varMaps.put("Activity_111kevq", payload.getUserId());
//         //发起流程审批
// //        ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
// //                HrBaseEnum.BASE_BU_CHANGE.getCode(),
// //                HrBaseEnum.BASE_BU_CHANGE.getDesc(),
// //                res.getId().toString(), varMaps));
// //        String procInstId = processInfo.getProcInstId();
// //        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
//         String procInstId = "";
//         // 回写单据的工作流信息
// //        payload.setProcInstId(procInstId);
// //        payload.setProcInstStatus("");
//         Long update = dao.updateByKeyDynamic(payload);
//         return TwOutputUtil.ok(update);
//     }

    /**
     * 数据校验
     *
     * @param payload payload
     */
    private void checkData(PrdYeedocRefPayload payload) {
    }

    /**
     * todo
     * @param vos vos
     */
    private void translate(List<PrdYeedocRefVO> vos){
        vos.forEach(vo -> {
            // todo 翻译vo对象
//            vo.setUserIdDesc("");
        });
    }

}
