/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class ChangeFieldUtil {
    private static final Logger log = LoggerFactory.getLogger(ChangeFieldUtil.class);

    public <T> String getFieldsUpdateLog(T newBean, T oldBean) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(FieldUpdateLog.class)) continue;
            try {
                String changeAction = field.getAnnotation(FieldUpdateLog.class).changeAction();
                Object newValue = field.get(newBean);
                Object oldValue = field.get(oldBean);
                if (null == newValue) continue;
                if (ObjectUtils.isEmpty((Object)newValue)) {
                    newValue = "\u7a7a";
                }
                if (ObjectUtils.isEmpty((Object)oldValue)) {
                    oldValue = "\u7a7a";
                }
                if (Objects.equals(newValue, oldValue) || field.getType().getName().equals("java.math.BigDecimal") && ((BigDecimal)newValue).compareTo((BigDecimal)oldValue) == 0 || StringUtils.hasText((String)field.getAnnotation(FieldUpdateLog.class).fieldObject())) continue;
                if (StringUtils.hasText((String)field.getAnnotation(FieldUpdateLog.class).objectNameField())) {
                    builder.append(this.getAllFieldValueByFieldName(field.getAnnotation(FieldUpdateLog.class).objectNameField(), oldBean));
                } else {
                    builder.append(field.getAnnotation(FieldUpdateLog.class).fieldName());
                }
                builder.append(" \u7531 ");
                builder.append(oldValue);
                builder.append((String)(changeAction == null ? " \u4fee\u6539\u4e3a " : " " + changeAction + " "));
                builder.append(newValue);
                builder.append("\n");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return builder.toString();
    }

    public <T> String getFieldsCreateLog(T newBean, String content) {
        Field[] fields = newBean.getClass().getDeclaredFields();
        StringBuilder builder = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(FieldCreateLog.class)) continue;
            try {
                Object newValue = field.get(newBean);
                if (null == newValue || ObjectUtils.isEmpty((Object)newValue)) continue;
                String selectionKey = field.getAnnotation(FieldCreateLog.class).selectionKey();
                if (StringUtils.hasText((String)field.getAnnotation(FieldCreateLog.class).fieldObject())) continue;
                builder.append(field.getAnnotation(FieldCreateLog.class).fieldName());
                if (!StringUtils.hasText((String)content)) {
                    content = "\u521b\u5efa\u4e3a";
                }
                builder.append(" " + content + " ");
                builder.append(newValue);
                builder.append("\n");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return builder.toString();
    }

    public Object getAllFieldValueByFieldName(String fieldName, Object object) throws IllegalAccessException {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        field.setAccessible(true);
        return field.get(object);
    }
}

