/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.callback;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonResPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonCertService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonEduExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonProjectExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonWorkExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgPersonService;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonResConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PERSONAL_INFO_CHANGE/callBack"})
@Transactional
public class PersonResWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PersonResWorkflowCallBackController.class);
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final PrdSystemBusinessChangeService changeService;
    private final PersonEduExperienceService personEduExperienceService;
    private final PersonWorkExperienceService personWorkExperienceService;
    private final PersonProjectExperienceService personProjectExperienceService;
    private final PersonCertService personCertService;
    private final PrdOrgPersonService prdOrgPersonService;
    private final PersonResService personResService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PersonResVO resVO = new PersonResVO();
        PersonResVO personResVO = this.personResService.queryById(Long.valueOf(businessKey));
        Long employeeId = personResVO.getPrdOrgEmployeeVO().getId();
        PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
        prdOrgEmployeePayload.setId(employeeId);
        if (personResVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: 
                case INVALID: {
                    prdOrgEmployeePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    this.changeService.deleteCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
                    break;
                }
                case REJECTED: {
                    prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdOrgEmployeePayload.setApprovedTime(LocalDateTime.now());
                    Map stringObjectMap = this.changeService.getCurrentVersionLog(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString());
                    PersonResVO resVo = (PersonResVO)JSON.parseObject((String)stringObjectMap.toString(), PersonResVO.class);
                    PrdOrgEmployeePayload employeePayload = PrdOrgEmployeeConvert.INSTANCE.toPayload(resVo.getPrdOrgEmployeeVO());
                    PersonResPayload resPayload = PersonResConvert.INSTANCE.voToPayload(resVo);
                    resPayload.setPrdOrgEmployeePayload(employeePayload);
                    this.prdOrgEmployeeService.updateNew(resPayload);
                    prdOrgEmployeePayload.setNullFields(List.of("procInstId"));
                    this.changeService.updateVersionStatus(ChangeTypeEnum.PERSONAL_INFO.getCode(), employeeId.toString(), Integer.valueOf(0));
                    break;
                }
                case APPROVING: {
                    prdOrgEmployeePayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.prdOrgEmployeeDAO.updateProcessDate(prdOrgEmployeePayload);
        }
        return WorkflowResult.success(null);
    }

    public PersonResWorkflowCallBackController(PrdOrgEmployeeService prdOrgEmployeeService, PrdSystemBusinessChangeService changeService, PersonEduExperienceService personEduExperienceService, PersonWorkExperienceService personWorkExperienceService, PersonProjectExperienceService personProjectExperienceService, PersonCertService personCertService, PrdOrgPersonService prdOrgPersonService, PersonResService personResService, PrdOrgEmployeeDAO prdOrgEmployeeDAO) {
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.changeService = changeService;
        this.personEduExperienceService = personEduExperienceService;
        this.personWorkExperienceService = personWorkExperienceService;
        this.personProjectExperienceService = personProjectExperienceService;
        this.personCertService = personCertService;
        this.prdOrgPersonService = prdOrgPersonService;
        this.personResService = personResService;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
    }
}

