/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonCertService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonCertVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonCertConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonCertDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonCertDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonCertServiceImpl
implements PersonCertService {
    private static final Logger log = LoggerFactory.getLogger(PersonCertServiceImpl.class);
    private final PersonCertDAO personCertDAO;
    private final FileUtil fileUtil;

    public void saveAll(List<PersonCertVO> personCertVOList, Long personId) {
        if (personCertVOList != null) {
            if (personCertVOList.size() == 0) {
                this.personCertDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonCertVO personCertVO : personCertVOList) {
                    if (personCertVO.getPersonId() != null) continue;
                    personCertVO.setPersonId(personId);
                }
                this.personCertDAO.saveAll(PersonCertConvert.INSTANCE.toDos(personCertVOList));
            }
        }
    }

    public List<PersonCertVO> findAllByPersonId(Long personId) {
        List<PersonCertDO> personEduExperienceDOList = this.personCertDAO.findAllByPersonId(personId);
        List<PersonCertVO> certVOList = PersonCertConvert.INSTANCE.toVos(personEduExperienceDOList);
        for (PersonCertVO personCertVO : certVOList) {
            personCertVO.setCertDatas(this.fileUtil.getFileDatas(personCertVO.getCertCodes()));
        }
        return certVOList;
    }

    public void deleteAllByPersonId(Long personId) {
        this.personCertDAO.deleteAllByPersonId(personId);
    }

    public PersonCertServiceImpl(PersonCertDAO personCertDAO, FileUtil fileUtil) {
        this.personCertDAO = personCertDAO;
        this.fileUtil = fileUtil;
    }
}

