/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.inv.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.inv.payload.InvItemPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvItemQuery;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvItemVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.inv.entity.InvItemDO;
import com.elitesland.tw.tw5.server.prd.inv.entity.QInvItemDO;
import com.elitesland.tw.tw5.server.prd.inv.repo.InvItemRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class InvItemDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final InvItemRepo repo;
    private final QInvItemDO qdo = QInvItemDO.invItemDO;

    private JPAQuery<InvItemVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(InvItemVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.province, this.qdo.goodsCode, this.qdo.goodsCodeName, this.qdo.twGoodsCode, this.qdo.twGoodsCodeName, this.qdo.goodsNo, this.qdo.goodsName, this.qdo.goodsTaxRate, this.qdo.priceTaxMark, this.qdo.preferentialMark, this.qdo.preferentialType, this.qdo.goodsDescribe, this.qdo.goodsShorthand, this.qdo.goodsSpecification, this.qdo.goodsUnit, this.qdo.goodsPrice, this.qdo.freeTaxType})).from((EntityPath)this.qdo);
    }

    private JPAQuery<InvItemVO> getJpaQueryWhere(InvItemQuery query) {
        JPAQuery<InvItemVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(InvItemQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(InvItemQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvince())) {
            list.add(this.qdo.province.eq((Object)query.getProvince()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsCode())) {
            list.add(this.qdo.goodsCode.eq((Object)query.getGoodsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsCodeName())) {
            list.add(this.qdo.goodsCodeName.like(SqlUtil.toSqlLikeString(query.getGoodsCodeName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTwGoodsCode())) {
            list.add(this.qdo.twGoodsCode.eq((Object)query.getTwGoodsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getTwGoodsCodeName())) {
            list.add(this.qdo.twGoodsCodeName.like(SqlUtil.toSqlLikeString(query.getTwGoodsCodeName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsNo())) {
            list.add(this.qdo.goodsNo.eq((Object)query.getGoodsNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsName())) {
            list.add(this.qdo.goodsName.like(SqlUtil.toSqlLikeString(query.getGoodsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsTaxRate())) {
            list.add(this.qdo.goodsTaxRate.eq((Object)query.getGoodsTaxRate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPriceTaxMark())) {
            list.add(this.qdo.priceTaxMark.eq((Object)query.getPriceTaxMark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreferentialMark())) {
            list.add(this.qdo.preferentialMark.eq((Object)query.getPreferentialMark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreferentialType())) {
            list.add(this.qdo.preferentialType.eq((Object)query.getPreferentialType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsDescribe())) {
            list.add(this.qdo.goodsDescribe.like(SqlUtil.toSqlLikeString(query.getGoodsDescribe())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsShorthand())) {
            list.add(this.qdo.goodsShorthand.eq((Object)query.getGoodsShorthand()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsSpecification())) {
            list.add(this.qdo.goodsSpecification.eq((Object)query.getGoodsSpecification()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsUnit())) {
            list.add(this.qdo.goodsUnit.eq((Object)query.getGoodsUnit()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoodsPrice())) {
            list.add(this.qdo.goodsPrice.eq((Object)query.getGoodsPrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFreeTaxType())) {
            list.add(this.qdo.freeTaxType.eq((Object)query.getFreeTaxType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public InvItemVO queryByKey(Long id) {
        JPAQuery<InvItemVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (InvItemVO)jpaQuery.fetchFirst();
    }

    public List<InvItemVO> queryListDynamic(InvItemQuery query) {
        JPAQuery<InvItemVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<InvItemVO> queryPaging(InvItemQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<InvItemVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public InvItemDO save(InvItemDO ado) {
        return (InvItemDO)this.repo.save(ado);
    }

    public List<InvItemDO> saveAll(List<InvItemDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(InvItemPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProvince() != null) {
            update.set((Path)this.qdo.province, (Object)payload.getProvince());
        }
        if (payload.getGoodsCode() != null) {
            update.set((Path)this.qdo.goodsCode, (Object)payload.getGoodsCode());
        }
        if (payload.getGoodsCodeName() != null) {
            update.set((Path)this.qdo.goodsCodeName, (Object)payload.getGoodsCodeName());
        }
        if (payload.getTwGoodsCode() != null) {
            update.set((Path)this.qdo.twGoodsCode, (Object)payload.getTwGoodsCode());
        }
        if (payload.getTwGoodsCodeName() != null) {
            update.set((Path)this.qdo.twGoodsCodeName, (Object)payload.getTwGoodsCodeName());
        }
        if (payload.getGoodsNo() != null) {
            update.set((Path)this.qdo.goodsNo, (Object)payload.getGoodsNo());
        }
        if (payload.getGoodsName() != null) {
            update.set((Path)this.qdo.goodsName, (Object)payload.getGoodsName());
        }
        if (payload.getGoodsTaxRate() != null) {
            update.set(this.qdo.goodsTaxRate, (Object)payload.getGoodsTaxRate());
        }
        if (payload.getPriceTaxMark() != null) {
            update.set((Path)this.qdo.priceTaxMark, (Object)payload.getPriceTaxMark());
        }
        if (payload.getPreferentialMark() != null) {
            update.set((Path)this.qdo.preferentialMark, (Object)payload.getPreferentialMark());
        }
        if (payload.getPreferentialType() != null) {
            update.set((Path)this.qdo.preferentialType, (Object)payload.getPreferentialType());
        }
        if (payload.getGoodsDescribe() != null) {
            update.set((Path)this.qdo.goodsDescribe, (Object)payload.getGoodsDescribe());
        }
        if (payload.getGoodsShorthand() != null) {
            update.set((Path)this.qdo.goodsShorthand, (Object)payload.getGoodsShorthand());
        }
        if (payload.getGoodsSpecification() != null) {
            update.set((Path)this.qdo.goodsSpecification, (Object)payload.getGoodsSpecification());
        }
        if (payload.getGoodsUnit() != null) {
            update.set((Path)this.qdo.goodsUnit, (Object)payload.getGoodsUnit());
        }
        if (payload.getGoodsPrice() != null) {
            update.set(this.qdo.goodsPrice, (Object)payload.getGoodsPrice());
        }
        if (payload.getFreeTaxType() != null) {
            update.set((Path)this.qdo.freeTaxType, (Object)payload.getFreeTaxType());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("province")) {
                update.setNull((Path)this.qdo.province);
            }
            if (nullFields.contains("goodsCode")) {
                update.setNull((Path)this.qdo.goodsCode);
            }
            if (nullFields.contains("goodsCodeName")) {
                update.setNull((Path)this.qdo.goodsCodeName);
            }
            if (nullFields.contains("twGoodsCode")) {
                update.setNull((Path)this.qdo.twGoodsCode);
            }
            if (nullFields.contains("twGoodsCodeName")) {
                update.setNull((Path)this.qdo.twGoodsCodeName);
            }
            if (nullFields.contains("goodsNo")) {
                update.setNull((Path)this.qdo.goodsNo);
            }
            if (nullFields.contains("goodsName")) {
                update.setNull((Path)this.qdo.goodsName);
            }
            if (nullFields.contains("goodsTaxRate")) {
                update.setNull(this.qdo.goodsTaxRate);
            }
            if (nullFields.contains("priceTaxMark")) {
                update.setNull((Path)this.qdo.priceTaxMark);
            }
            if (nullFields.contains("preferentialMark")) {
                update.setNull((Path)this.qdo.preferentialMark);
            }
            if (nullFields.contains("preferentialType")) {
                update.setNull((Path)this.qdo.preferentialType);
            }
            if (nullFields.contains("goodsDescribe")) {
                update.setNull((Path)this.qdo.goodsDescribe);
            }
            if (nullFields.contains("goodsShorthand")) {
                update.setNull((Path)this.qdo.goodsShorthand);
            }
            if (nullFields.contains("goodsSpecification")) {
                update.setNull((Path)this.qdo.goodsSpecification);
            }
            if (nullFields.contains("goodsUnit")) {
                update.setNull((Path)this.qdo.goodsUnit);
            }
            if (nullFields.contains("goodsPrice")) {
                update.setNull(this.qdo.goodsPrice);
            }
            if (nullFields.contains("freeTaxType")) {
                update.setNull((Path)this.qdo.freeTaxType);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public InvItemDAO(JPAQueryFactory jpaQueryFactory, InvItemRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

