/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.mpxj.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.MpxjMppTaskVO;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.RelationVO;
import com.elitesland.tw.tw5.api.prd.mpxj.vo.ResourceVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.mpxj.dao.MpxjMppTaskDAO;
import com.elitesland.tw.tw5.server.prd.mpxj.entity.MpxjMppTaskDO;
import com.elitesland.tw.tw5.server.prd.mpxj.repo.MpxjMppTaskRepo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.reader.UniversalProjectReader;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class MpxjMppConstsServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(MpxjMppConstsServiceImpl.class);
    private final MpxjMppTaskDAO dao;
    private final MpxjMppTaskRepo repo;

    @Transactional
    public void importElecPlanTask(MultipartFile file, Long projectId) {
        String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
        if (!"mpp".equals(extension)) {
            log.info("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u540d\u540e\u7f00\u5fc5\u987b\u4e3a\u201cmpp\u201d\uff01");
        }
        MPPReader mppRead = new MPPReader();
        ProjectFile project = null;
        try {
            project = mppRead.read(file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        TaskContainer tasks = project.getTasks();
        ArrayList<MpxjMppTaskDO> taskDOList = new ArrayList<MpxjMppTaskDO>();
        for (int i = 1; i < tasks.size(); ++i) {
            Task task = (Task)tasks.get(i);
            this.analysisFile(task, taskDOList);
        }
        taskDOList.forEach(taskDO -> taskDO.setProjectId(projectId));
        this.repo.saveAll(taskDOList);
        this.updateParentId(taskDOList);
    }

    void analysisFile(Task task, List<MpxjMppTaskDO> taskDOList) {
        Integer task_id = task.getID();
        Integer task_parent_def_id = task.getParentTask().getID();
        Integer task_outline_level = task.getOutlineLevel();
        String task_wbs = task.getWBS();
        String task_name = task.getName();
        Date task_start_date = task.getStart();
        Date task_finish_date = task.getFinish();
        Date baselineEstimatedFinish = task.getBaselineEstimatedFinish(2);
        double duration = task.getDuration().getDuration();
        String task_leader = "";
        List resourceAssignments = task.getResourceAssignments();
        if (!ObjectUtils.isEmpty((Object)resourceAssignments)) {
            ArrayList resources = new ArrayList();
            resourceAssignments.forEach(resourceAssignment -> {
                Resource resource = resourceAssignment.getResource();
                if (resource != null) {
                    ResourceVO resourceVO = new ResourceVO();
                    resourceVO.setName(resource.getName());
                    resourceVO.setId(resource.getID());
                    resourceVO.setUniqueID(resource.getUniqueID());
                    resources.add(resourceVO);
                }
            });
            if (resources.size() > 0) {
                task_leader = JSONObject.toJSONString(resources);
            }
        }
        String task_percentage = String.valueOf(task.getPercentageComplete().byteValue());
        boolean summary = task.getSummary();
        List task_predecessors = task.getPredecessors();
        String task_predecessors_str = null;
        if (task_predecessors != null) {
            ArrayList taskRelations = new ArrayList();
            task_predecessors.forEach(relation -> {
                if (relation.getTargetTask() != null) {
                    RelationVO relationVO = new RelationVO();
                    relationVO.setUniqueID(relation.getUniqueID());
                    relationVO.setType(Integer.valueOf(relation.getType().getValue()));
                    relationVO.setTaskRefId(relation.getTargetTask().getID());
                    relationVO.setDuration(Double.valueOf(relation.getLag().getDuration()));
                    taskRelations.add(relationVO);
                }
            });
            if (taskRelations.size() > 0) {
                task_predecessors_str = JSONObject.toJSONString(taskRelations);
            }
        }
        MpxjMppTaskDO taskDO = new MpxjMppTaskDO();
        taskDO.setBaseline2FinishDate(baselineEstimatedFinish.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        taskDO.setPlanDueDate(duration);
        taskDO.setPlanFinishDate(task_finish_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        taskDO.setPlanStartDate(task_start_date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        taskDO.setPlanDueDate(duration);
        taskDO.setRowId(task_id);
        taskDO.setRowParentId(task_parent_def_id);
        taskDO.setSourceName(task_leader);
        taskDO.setTasKLevel(task_outline_level);
        taskDO.setTaskName(task_name);
        taskDO.setTaskPredecessors(task_predecessors_str);
        taskDO.setTaskProgress(task_percentage);
        taskDO.setWbsCode(task_wbs);
        taskDO.setSummaryFlag(summary);
        taskDOList.add(taskDO);
    }

    void updateParentId(List<MpxjMppTaskDO> taskDOList) {
        taskDOList.forEach(taskDO -> {
            Integer rowParentId = taskDO.getRowParentId();
            Optional<MpxjMppTaskDO> first = taskDOList.stream().filter(rowParentTask -> rowParentTask.getRowId().equals(rowParentId)).findFirst();
            if (first.isPresent()) {
                taskDO.setParentId(first.get().getId());
            }
        });
    }

    public void exportElecPlanTask(HttpServletResponse response, Long projectId) {
        try {
            int bytesRead;
            if (projectId == null) {
                throw TwException.error("", "\u6240\u5c5e\u9879\u76ee\u4e0d\u53ef\u4e3a\u7a7a");
            }
            List<MpxjMppTaskVO> mpxjMppTaskVOS = this.dao.queryListByProjectId(projectId);
            if (ObjectUtils.isEmpty(mpxjMppTaskVOS)) {
                throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728");
            }
            ProjectFile projectFile = new ProjectFile();
            mpxjMppTaskVOS.forEach(mpxjMppTaskVO -> {
                Task task = projectFile.addTask();
                task.setID(mpxjMppTaskVO.getRowId());
                task.setWBS(mpxjMppTaskVO.getWbsCode());
                task.setOutlineLevel(mpxjMppTaskVO.getTasKLevel());
                task.setName(mpxjMppTaskVO.getTaskName());
                if (StringUtils.hasText((String)mpxjMppTaskVO.getTaskProgress())) {
                    task.setPercentageComplete((Number)Double.parseDouble(mpxjMppTaskVO.getTaskProgress()));
                }
                Date baseline2FinishDate = Date.from(mpxjMppTaskVO.getBaseline2FinishDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                task.setBaselineEstimatedFinish(2, baseline2FinishDate);
                task.setDuration(Duration.getInstance((double)mpxjMppTaskVO.getPlanDueDate(), (TimeUnit)TimeUnit.getInstance((int)TimeUnit.DAYS.getValue())));
                Date planStartDate = Date.from(mpxjMppTaskVO.getPlanStartDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                task.setStart(planStartDate);
                Date planFinishDate = Date.from(mpxjMppTaskVO.getPlanFinishDate().atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                task.setFinish(planFinishDate);
                if (mpxjMppTaskVO.getSummaryFlag().booleanValue()) {
                    task.setSummary(true);
                }
                if (StringUtils.hasText((String)mpxjMppTaskVO.getSourceName())) {
                    List os = JSON.parseArray((String)mpxjMppTaskVO.getSourceName(), ResourceVO.class);
                    os.forEach(resourceVO -> {
                        Resource resource = projectFile.addResource();
                        resource.setID(resourceVO.getId());
                        resource.setName(resourceVO.getName());
                        task.addResourceAssignment(resource);
                    });
                }
            });
            TaskContainer tasks = projectFile.getTasks();
            tasks.forEach(arg_0 -> MpxjMppConstsServiceImpl.lambda$exportElecPlanTask$11(mpxjMppTaskVOS, (List)tasks, arg_0));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(projectFile, (OutputStream)bos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            response.setContentType("application/octet-stream");
            response.addHeader("Content-Disposition", "attachment;filename=project.xml");
            byte[] buffer = new byte[1024];
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, bytesRead);
            }
            ((InputStream)byteArrayInputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportElecPlanTask3(HttpServletResponse response, Long projectId) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + LocalDate.now() + ".mpp\"");
        try {
            int bytesRead;
            ClassPathResource classPathResource = new ClassPathResource("template/wwwwwwwwww.mpp");
            InputStream inputStream = classPathResource.getInputStream();
            UniversalProjectReader reader = new UniversalProjectReader();
            ProjectFile project = reader.read(inputStream);
            Task task = project.addTask();
            task.setName("New Task Added");
            task.setID(Integer.valueOf(999));
            task.setWBS("1.5.12.5");
            task.setSummary(true);
            Task parentTask = task.getParentTask();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(project, (OutputStream)bos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bos.toByteArray());
            ServletOutputStream os = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = byteArrayInputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            bos.close();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportElecPlanTask1(HttpServletResponse response, Long projectId) {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=your_file_name.mpp");
        try {
            int bytesRead;
            ClassPathResource classPathResource = new ClassPathResource("template/wwwwwwwwww.mpp");
            InputStream inputStream = classPathResource.getInputStream();
            MPPReader reader = new MPPReader();
            ServletOutputStream os = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportElecPlanTask0(HttpServletResponse response, Long projectId) {
        ClassPathResource classPathResource = new ClassPathResource("template/projectWbs.mpp");
        try {
            File file = new File("template/projectWbs.mpp");
            UniversalProjectReader reader = new UniversalProjectReader();
            ProjectFile project = reader.read(file);
            Task newTask = project.addTask();
            newTask.setName("New Task Added");
            response.setContentType("application/vnd.ms-project");
            response.setHeader("Content-Disposition", "attachment; filename=modified_example.mpp");
            ServletOutputStream outputStream = response.getOutputStream();
            MSPDIWriter writer = new MSPDIWriter();
            writer.write(project, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MpxjMppConstsServiceImpl(MpxjMppTaskDAO dao, MpxjMppTaskRepo repo) {
        this.dao = dao;
        this.repo = repo;
    }

    private static /* synthetic */ void lambda$exportElecPlanTask$11(List mpxjMppTaskVOS, List tasks, Task task) {
        Optional<Task> first;
        MpxjMppTaskVO mpxjMppTaskVO = mpxjMppTaskVOS.stream().filter(taskVO -> taskVO.getRowId().equals(task.getID())).findFirst().get();
        if (StringUtils.hasText((String)mpxjMppTaskVO.getTaskPredecessors())) {
            List os = JSON.parseArray((String)mpxjMppTaskVO.getTaskPredecessors(), RelationVO.class);
            os.forEach(relation -> {
                Optional<Task> first = tasks.stream().filter(taskVO -> taskVO.getID().equals(relation.getTaskRefId())).findFirst();
                if (first.isPresent()) {
                    task.addPredecessor(first.get(), RelationType.getInstance((Number)relation.getType()), Duration.getInstance((double)relation.getDuration(), (TimeUnit)TimeUnit.getInstance((int)TimeUnit.DAYS.getValue())));
                }
            });
        }
        if (mpxjMppTaskVO.getParentId() != null && (first = tasks.stream().filter(taskVO -> taskVO.getID().intValue() == mpxjMppTaskVO.getParentId().intValue()).findFirst()).isPresent()) {
            first.get().addChildTask(task);
        }
    }
}

