/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.api.prd.my.query.MonthlyTimesheetQuery;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface TimesheetRepo
extends JpaRepository<TimesheetDO, Long>,
JpaSpecificationExecutor<TimesheetDO> {
    @Query(value="update TimesheetDO set taskId = ?2,taskNo= ?3,taskName = ?4,actId=?5,actNo=?6,actName=?7 where  id =?1")
    @Modifying
    public void updateByTaskId(Long var1, Long var2, String var3, String var4, Long var5, String var6, String var7);

    @Query(value="SELECT GROUP_CONCAT(id) AS groupIds,SUM(work_hour) as workHour, proj_id as projId, proj_no as projNo,proj_name as projName,  ts_status as tsStatus, appr_user_id as apprUserId,week_start_date as weekStartDate,  task_id as taskId,task_no as taskNo, task_name as taskName,  ts_user_id as tsUserId,ts_user_bu_id as tsUserBuId, ts_user_bu_name as tsUserBuName  FROM t_timesheet where delete_flag = 0  and  if(?1 != NULL or ?1!='',ts_user_id=?1,1=1)  and  if(?2 != NULL or ?2!='',appr_user_id=?2,1=1)  and  if(?3 != NULL or ?3!='',ts_status=?3,1=1)  and  if(?4 != NULL or ?4!='',ts_user_bu_id=?4,1=1)  and  if(?5 != NULL or ?5!='',timesheet_id_v4 is null,1=1)  and  if(?6 != NULL or ?6!='',proj_name like CONCAT('%', ?6, '%') or task_name like CONCAT('%', ?6, '%'),1=1)  and  if(COALESCE (?7) IS NOT NULL ,ts_user_id in (?7),1=1)   GROUP BY proj_id,year_week,ts_user_id,ts_status   order by year_week desc,ts_user_id asc ", countQuery="select count(*)  FROM t_timesheet  where delete_flag = 0  and  if(?1 != NULL or ?1!='',ts_user_id=?1,1=1)  and  if(?2 != NULL or ?2!='',appr_user_id=?2,1=1)  and  if(?3 != NULL or ?3!='',ts_status=?3,1=1)  and  if(?4 != NULL or ?4!='',ts_user_bu_id=?4,1=1)  and  if(?5 != NULL,timesheet_id_v4 is null,1=1)  and  if(?6 != NULL or ?6!='',proj_name like CONCAT('%', ?6, '%') or task_name like CONCAT('%', ?6, '%'),1=1)  and  if(COALESCE (?7) IS NOT NULL,ts_user_id in (?7),1=1)  GROUP BY proj_id,year_week,ts_user_id,ts_status  ORDER BY work_date desc ", nativeQuery=true)
    public Page<Object[]> pagingGroup(Long var1, Long var2, String var3, Long var4, Boolean var5, Pageable var6, String var7, Set<Long> var8);

    @Query(value="select * from t_timesheet e where e.modify_time>=?1 and (e.ts_task_iden is null or e.ts_task_iden <> 'VACATION' or (e.ts_task_iden = 'VACATION' and e.timesheet_id_v4 is null) or e.delete_flag=1)", nativeQuery=true)
    public List<TimesheetDO> findByModifyTimeAfter(LocalDateTime var1);

    @Query(value="select * from t_timesheet e where e.modify_time>=?1 and e.modify_time<=?2 and (e.ts_task_iden is null or e.ts_task_iden <> 'VACATION' or (e.ts_task_iden = 'VACATION' and e.timesheet_id_v4 is null) or e.delete_flag=1)", nativeQuery=true)
    public List<TimesheetDO> findByModifyTimeBetween(LocalDateTime var1, LocalDateTime var2);

    @Query(value="select * from t_timesheet e where e.modify_time>=?1 and e.proj_id=?2 and e.delete_flag = 0 and e.ts_status<>'CREATE'", nativeQuery=true)
    public List<TimesheetDO> findByProjectIdAndModifyTimeAfter(LocalDateTime var1, Long var2);

    public List<TimesheetDO> queryByTimesheetIdV4In(List<Long> var1);

    @Query(value="select id as timesheetId,workPlanId as workPlanId from TimesheetDO where deleteFlag=0")
    public List<Map<String, Object>> getTimesheetAndPlanIds();

    @Query(value="update TimesheetDO set workPlanId = ?2 where  id =?1")
    @Modifying
    public void updatePlan(Long var1, Long var2);

    @Query(value="select id as timesheetId,timesheetIdV4 as timesheetIdV4 from TimesheetDO where deleteFlag=0")
    public List<Map<String, Object>> getV4AndV5TimesheetIds();

    public int countByBangwo8NoAndDeleteFlag(Long var1, Integer var2);

    @Query(value="update TimesheetDO set apprUserId = ?2,modifyTime=current_time where id in ?1")
    @Modifying
    public void updateApprovingUser(List<Long> var1, Long var2);

    @Query(value="SELECT workDate FROM TimesheetDO WHERE deleteFlag=0 AND tsUserId = ?3 AND workDate between ?1 and ?2 GROUP BY workDate")
    public List<LocalDate> queryTsDateList(LocalDate var1, LocalDate var2, Long var3);

    @Query(value="SELECT id,proj_id as projId,TS_USER_ID as tsUserId FROM T_TIMESHEET WHERE TIMESHEET_ID_V4 IS NULL AND TS_STATUS<>'APPROVED' AND proj_id IS NOT NULL AND PROJ_ID<>0 AND task_id IS NULL AND DELETE_FLAG=0 AND WORK_DATE BETWEEN '2023-01-01' AND '2023-06-31'", nativeQuery=true)
    public List<Map<String, Object>> queryTimeSheetToRepair();

    @Query(value="SELECT TASK_ID as taskId,TASK_NO as taskNo,task_name as taskName,act_id as actId,act_no as actNo,act_name as actName FROM t_timesheet WHERE proj_id=?1 AND ts_user_id=?2 AND delete_flag=0 AND TASK_ID IS NOT NULL ORDER BY MODIFY_TIME desc limit 1", nativeQuery=true)
    public Map<String, Object> queryTimeSheetToCopy(BigInteger var1, BigInteger var2);

    @Query(value="UPDATE T_TIMESHEET SET TASK_ID=?1,TASK_NO=?2,task_name=?3,act_id=?4,act_no=?5,act_name=?6,MODIFY_TIME=NOW(),TS_STATUS='APPROVED' WHERE id=?7 ", nativeQuery=true)
    @Modifying
    public void updateTimesheetByCopy(BigInteger var1, String var2, String var3, BigInteger var4, String var5, String var6, BigInteger var7);

    @Query(value="select sum(workHour) from TimesheetDO where deleteFlag=0 and tsUserId=?1 and workDate=?2")
    public BigDecimal queryWorkHour(Long var1, LocalDate var2);

    @Transactional(rollbackFor={Exception.class})
    @Query(value="update T_TIMESHEET set modify_time=now()  where id=?1", nativeQuery=true)
    @Modifying
    public void updateModifyTime(Long var1);

    @Query(value="SELECT\n        concat('00', O2.JDE_OU_NO) as prjAscriptionOuNO,\n        concat('00', O2.JDE_OU_NO) as resAscriptionOuNO,\n        TS_D.year,\n        TS_D.monthly,\n        TS_D.resNo,\n        B3.org_name as resBu,\n        TS_D.employeeName,\n        case\n            when length(trim(productNo)) > 0 then productNo\n            when TS_D.REASON_TYPE = 'PROJ_CONTRACT' then ifnull(replace(TS_D.USERDEFINED_NO, 'PJ', ''), TS_D.CONTRACT_NO)\n            else concat(O2.JDE_OU_NO, B1.jde_org_code)\n        end as refContractNo,\n        TS_D.prjName,\n        B2.org_name as deliverBu,\n        TS_D.contractNo,\n        ROUND(SUM(TS_D.WORK_HOUR) / 8, 2) as days,\n        TS_D.EQVA_RATIO as eqvaRatio,\n        ROUND(TS_D.EQVA_RATIO * SUM(TS_D.WORK_HOUR) / 8, 2) as settleEqva,\n        TS_D.productNo,\n        TS_D.PJTYPE as pjType,\n        TS_D.PJTYPE1 as pjType1\n    FROM\n        (\n        SELECT\n            right(year(TS.WORK_DATE),2) as year,\n            month(TS.WORK_DATE) as monthly,\n            if(RES.ext_string6 = 'EXTERNAL_RES',CONCAT('\u5916\u90e8: ', RES.employee_name),RES.employee_name) as employeeName,\n            res.book_id,\n            RES.eqva_ratio,\n            SO.code as contractNo,\n            replace(CONCAT(left(RES.RES_NO, 3), right(RES.RES_NO, 4)), 'R', '80') as resNo,\n            case\n                when TS.REASON_TYPE = 'PROJ_CONTRACT' then PJ.PROJ_NAME\n                when TS.task_package_id is not null then TS.task_package_name\n                else '\u65e0\u9879\u76ee'\n            end as prjName,\n            if(TS.REASON_TYPE = 'PROJ_CONTRACT' and SO.WORK_TYPE in ('DEVELOP', 'MANAGE', 'SPECIAL'), PJ.product_no,'') as productNo,\n            TS.REASON_TYPE,\n            SO.refer_code as USERDEFINED_NO,\n            SO.code as CONTRACT_NO,\n            case\n                when TS.REASON_TYPE = 'PROJ_CONTRACT' then 4\n                when TS.REASON_TYPE = 'PROJ_OPPO' then 1\n                when TS.REASON_TYPE = 'PROJ_BU' then 2\n                else 3\n            end as PJTYPE1,\n            case\n                when TS.REASON_TYPE = 'PROJ_CONTRACT' then '\u9879\u76ee'\n                WHEN TS.REASON_TYPE = 'PROJ_OPPO' THEN '\u552e\u524d'\n                when TS.REASON_TYPE = 'PROJ_BU' then 'BU\u4efb\u52a1'\n                ELSE '\u65e0\u9879\u76ee'\n            end as PJTYPE,\n            case\n                when TS.REASON_TYPE = 'PROJ_CONTRACT' then SO.DELI_BU_ID\n                when TS.REASON_TYPE in ('PROJ_OPPO') then op.pre_sale_org_id\n                when TS.REASON_TYPE in ('PROJ_BU') then PJ1.deli_bu_id\n                else t3.org_id\n            end as COST_BUID,\n            RES.company_id as RE_OUID,\n            TS.ts_user_id as TS_RES_ID,\n            t3.org_id as BASE_BU_ID,\n            case\n                when TS.REASON_TYPE = 'PROJ_CONTRACT' then SO.DELI_BU_ID\n                else null\n            end as DELI_BU_ID,\n            sum(TS.WORK_HOUR) as WORK_HOUR,\n            DC1.selection_name as TS_STATUS\n        from\n            T_TIMESHEET TS\n        inner join T_VACATION VC on TS.WORK_DATE = VC.NATURAL_DATE\n        left join prd_org_employee RES on TS.ts_user_id = RES.user_id and RES.delete_flag = 0\n        left join (\n            select\n                distinct ref1.user_id,\n                ref1.org_id\n            from\n                prd_org_employee_ref ref1\n            inner join (\n                select\n                    user_id,\n                    max(modify_time) as modify_time\n                from\n                    prd_org_employee_ref ref21\n                where\n                    ref21.is_default = 0 and ref21.is_copy = 0\n                group by user_id\n            ) ref2 on ref1.user_id = ref2.user_id and ref1.modify_time = ref2.modify_time and ref1.is_default = 0 and ref1.is_copy = 0\n        ) t3 on RES.user_id = t3.user_id\n        left join prd_org_organization t2 on t3.org_id = t2.ID\n        left join pms_task_package TSK1 on TSK1.id = ts.task_package_id\n        left join pms_project PJ on TSK1.reason_id = PJ.ID and PJ.delete_flag = 0 and TSK1.REASON_TYPE = 'PROJ_CONTRACT'\n        left join bu_project PJ1 on PJ1.id = TSK1.reason_id and pj1.delete_flag = 0 and TSK1.REASON_TYPE = 'PROJ_BU'\n        left join prj_project PJ2 on PJ2.id = TSK1.reason_id and pj2.delete_flag = 0 and TSK1.REASON_TYPE = 'PROJ_OPPO'\n        left join crm_opportunity op on op.project_id = PJ2.id\n        left join sale_con_contract SO on PJ.CONTRACT_ID = SO.ID and SO.delete_flag = 0\n        left join prd_system_selection DC1 on DC1.parent_id = 636587649485772223 and DC1.selection_value = TS.TS_STATUS\n        where\n            TS.WORK_DATE between :#{#query.workDateStart} and :#{#query.workDateEnd}\n            and TS.TS_STATUS in :#{#query.status}\n            and (:#{#query.resType} is null OR RES.ext_string6 = :#{#query.resType})\n            and (:#{#query.tsUserId} is null OR TS.TS_USER_ID = :#{#query.tsUserId})\n            and not(TS.TS_TASK_IDEN = 'VACATION' and ifnull(TS.TS_ACT_IDEN, ' ') in ('PERSONAL', 'MATERNITYLEAVE'))\n            and VC.delete_flag = 0\n            and VC.WORK_HOURS = 8\n            and TS.delete_flag = 0\n            and t2.organization_type <> 'BS'\n        group by\n            year,\n            monthly,\n            employeeName,\n            book_id,\n            RES.eqva_ratio,\n            contractNo,\n            resNo,\n            prjName,\n            productNo,\n            PJTYPE,\n            COST_BUID,\n            RE_OUID,\n            TS.ts_user_id,\n            t3.org_id,\n            SO.DELI_BU_ID,\n            DC1.selection_name\n        ) TS_D\n    left join prd_org_organization B1 on TS_D.COST_BUID = B1.id and B1.delete_flag = 0\n    left join prd_org_organization B2 on TS_D.DELI_BU_ID = B2.ID and B2.delete_flag = 0\n    left join prd_org_organization B3 on TS_D.BASE_BU_ID = B3.ID and B3.delete_flag = 0\n    left join fin_db.TW_JDE_OU O2 on o2.TW_OU_ID = TS_D.book_id\n    group by\n        prjAscriptionOuNO,\n    \tresAscriptionOuNO,\n    \tyear,\n    \tmonthly,\n    \temployeeName,\n    \tresNo,\n    \tB3.org_name,\n    \tB2.org_name,\n    \tproductNo,\n    \tpjType,\n    \trefContractNo,\n    \tpjType1\n    having (:#{#query.refContractNo} is null OR refContractNo = :#{#query.refContractNo})\n    order by\n        year,\n        monthly,\n        resNo,\n        refContractNo,\n        days\n", nativeQuery=true)
    public List<Object[]> queryMonthlyTimesheetVO(@Param(value="query") MonthlyTimesheetQuery var1);

    @Query(value="SELECT work_date from ( SELECT work_date,SUM(work_hour) sumWorkHour FROM T_TIMESHEET WHERE delete_flag=0 AND ts_user_id = ?3 AND work_date between ?1 and ?2 AND ts_status in (\"APPROVED\",\"APPROVING\") GROUP BY work_date) temp where sumWorkHour>=8", nativeQuery=true)
    public List<Date> queryWritedTsDateList(LocalDate var1, LocalDate var2, Long var3);
}

