/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TBusiCardApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TBusiCardApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiCardApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiCardApplyVO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TBusiCardApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TBusiCardApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TBusiCardApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TBusiCardApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TBusiCardApplyServiceImpl
extends BaseServiceImpl
implements TBusiCardApplyService {
    private static final Logger log = LoggerFactory.getLogger(TBusiCardApplyServiceImpl.class);
    private final TBusiCardApplyRepo tBusiCardApplyRepo;
    private final TBusiCardApplyDAO tBusiCardApplyDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<TBusiCardApplyVO> queryPaging(TBusiCardApplyQuery query) {
        return this.tBusiCardApplyDAO.queryPaging(query);
    }

    public List<TBusiCardApplyVO> queryListDynamic(TBusiCardApplyQuery query) {
        return this.tBusiCardApplyDAO.queryListDynamic(query);
    }

    public TBusiCardApplyVO queryByKey(Long key) {
        TBusiCardApplyVO vo = this.tBusiCardApplyDAO.queryByKey(key);
        vo.setOuName(this.cacheUtil.getCompanyNameByBookId(vo.getOuId()));
        String mailFlagDesc = "\u90ae\u5bc4\u5230\u516c\u53f8";
        if (StringUtils.hasText((String)vo.getMailFlag()) && vo.getMailFlag().equals("SPECIFIED_ADDR")) {
            mailFlagDesc = "\u90ae\u5bc4\u5230\u6307\u5b9a\u5730\u70b9";
        }
        vo.setMailFlagDesc(mailFlagDesc);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TBusiCardApplyVO insert(TBusiCardApplyPayload payload) {
        payload.setETitle(payload.getEnglishTitle());
        payload.setCTitle(payload.getChineseTitle());
        payload.setEName(payload.getEnglishName());
        TBusiCardApplyDO entityDo = TBusiCardApplyConvert.INSTANCE.toDo(payload);
        TBusiCardApplyDO save = (TBusiCardApplyDO)this.tBusiCardApplyRepo.save(entityDo);
        this.busiCardApplyProc(save);
        return TBusiCardApplyConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public TBusiCardApplyVO update(TBusiCardApplyPayload payload) {
        TBusiCardApplyDO entity = this.tBusiCardApplyRepo.findById(payload.getId()).orElseGet(TBusiCardApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TBusiCardApplyDO entityDo = TBusiCardApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TBusiCardApplyConvert.INSTANCE.toVo((TBusiCardApplyDO)this.tBusiCardApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TBusiCardApplyPayload payload) {
        TBusiCardApplyDO entity = this.tBusiCardApplyRepo.findById(payload.getId()).orElseGet(TBusiCardApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tBusiCardApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tBusiCardApplyDAO.deleteSoft(keys);
        }
    }

    private void busiCardApplyProc(TBusiCardApplyDO cardApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Long> variables = new HashMap<String, Long>();
            Long applyResId = cardApplyDO.getApplyResId();
            String applyResName = this.cacheUtil.getUserName(applyResId);
            Long basebuId = cardApplyDO.getBasebuId();
            Long baseBuManageId = this.daoOrg.queryManageIdById(basebuId);
            variables.put("Activity_0x1w1sy", baseBuManageId);
            variables.put("Activity_0un5zq5", applyResId);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.BUSI_CARD_APPLY.name(), (String)(applyResName + "-\u540d\u7247\u7533\u8bf7\u6d41\u7a0b"), (String)("" + cardApplyDO.getId()), variables), new Long[0]);
        }
        TBusiCardApplyPayload payload = new TBusiCardApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(cardApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.tBusiCardApplyDAO.updateByKeyDynamic(payload));
    }

    public TBusiCardApplyServiceImpl(TBusiCardApplyRepo tBusiCardApplyRepo, TBusiCardApplyDAO tBusiCardApplyDAO, CacheUtil cacheUtil, PrdOrgOrganizationDAO daoOrg, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService) {
        this.tBusiCardApplyRepo = tBusiCardApplyRepo;
        this.tBusiCardApplyDAO = tBusiCardApplyDAO;
        this.cacheUtil = cacheUtil;
        this.daoOrg = daoOrg;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

