/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetApproveQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSyncDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationApplyVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeLeaderQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeQuery;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgEmployeeSuperiorQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalResService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyReadFlagRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.VacationRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.tw.tw5.server.prd.work.repo.OvertimeApplicationRepo;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetServiceImpl
implements TimesheetService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetServiceImpl.class);
    private final TimesheetRepo timesheetRepo;
    private final TaskService taskService;
    private final TaskRepo taskRepo;
    private final ResActivityService resActivityService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final ProjectService projectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserService prdUserService;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO daoUser;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetDAO timesheetDAO;
    private final TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo;
    private final PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final PrdOrgEmployeeRepo prdOrgEmployeeRepo;
    private final OvertimeApplicationRepo overtimeApplicationRepo;
    private final OvertimeApplicationDAO overtimeApplicationDAO;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final VacationRepo vacationRepo;
    private final UserVacationApplyService vacationApplyService;
    @Value(value="${tw4.url}")
    private String tw4_url;
    @Value(value="${tw4.sync.getProjectEqvaInfo:api/openReport/v1/sync/getProjectEqvaInfo}")
    private String getProjectEqvaInfo;
    private final TsApprovalResService tsApprovalResService;

    @Deprecated
    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        this.getPermissionParams(query);
        return PagingVO.empty();
    }

    private void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission().booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin) {
                List<Long> userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                }
                List<PrdOrgEmployeeRefVO> empRef = this.daoUser.queryLowListByKey(null, loginUserId);
                Set empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    HashSet<Long> queryUserIds = new HashSet<Long>();
                    queryUserIds.add(loginUserId);
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && !empRefUserIdList.isEmpty()) {
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setTsUserIdList(queryUserIds);
                }
            }
        }
    }

    public PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query) {
        if (!ObjectUtils.isEmpty((Object)query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO paging = this.prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
                Set userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        }
        Page page = this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }

    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        if (!ObjectUtils.isEmpty((Object)query.getTsUserIdName())) {
            PrdOrgEmployeeQuery employeeQuery = new PrdOrgEmployeeQuery();
            employeeQuery.setPersonName(query.getTsUserIdName());
            PagingVO paging = this.prdOrgEmployeeService.paging(employeeQuery);
            if (!ObjectUtils.isEmpty((Object)paging.getRecords())) {
                Set userIdList = paging.getRecords().stream().map(PrdOrgEmployeeVO::getUserId).collect(Collectors.toSet());
                query.setTsUserIdList(userIdList);
            }
        } else {
            query.setTsUserIdList(new HashSet());
        }
        Page<Object[]> page = this.timesheetRepo.pagingGroup(query.getTsUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), query.getTimesheetIdV4IsNull(), (Pageable)query.getPageRequest(), query.getBlurryQuery(), query.getTsUserIdList());
        List content = page.getContent();
        List<TimesheetVO> all = this.getAll(content);
        return PagingVO.builder().records(all).total(page.getTotalElements()).build();
    }

    @Deprecated
    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; ++i) {
                    TaskVO task;
                    TimesheetVO data = this.queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskId() == null || data.getTaskId() <= 0L || (task = this.taskService.queryByTaskIdV4(data.getTaskId())) == null || !"04".equals(task.getAcceptMethod())) continue;
                    bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(task.getEqvaRatio()));
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        ArrayList<TimesheetVO> list = new ArrayList<TimesheetVO>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(obj[13] != null ? String.valueOf(obj[13]) : "");
            list.add(timesheetVO);
        }
        return list;
    }

    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qTimesheetDO).from((EntityPath)qTimesheetDO)).where((Predicate)qTimesheetDO.deleteFlag.eq((Object)0));
        if (null != query.getTsUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.tsUserId.eq((Object)query.getTsUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.apprUserId.eq((Object)query.getApprUserId()));
        }
        if (StringUtils.hasText((String)query.getTsStatus())) {
            jpaQuery.where((Predicate)qTimesheetDO.tsStatus.eq((Object)query.getTsStatus()));
        }
        QueryResults queryResults = ((JPAQuery)((JPAQuery)jpaQuery.groupBy(new Expression[]{qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.tsUserId})).orderBy(new OrderSpecifier[]{qTimesheetDO.yearWeek.desc(), qTimesheetDO.tsUserId.desc()})).fetchResults();
        List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.toVoList(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public Map<LocalDate, Object> getTimesheetOverview(TimesheetQuery query) {
        HashMap<LocalDate, Object> result = new HashMap<LocalDate, Object>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (loginUserId == null) {
            throw TwException.error("", "\u7528\u6237\u67e5\u8be2\u5931\u8d25\uff01");
        }
        query.setTsUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = this.queryList(query);
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        List workDate = query.getWorkDate();
        LocalDate startDate = (LocalDate)workDate.get(0);
        LocalDate endDate = (LocalDate)workDate.get(1);
        LocalDate localDate = startDate;
        while (localDate.isBefore(endDate.plusDays(1L))) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            if (timesheetVOS1 == null || timesheetVOS1.isEmpty()) {
                result.put(localDate, "");
            } else {
                String status = "";
                int rejectedNum = 0;
                int createNum = 0;
                int approvingNum = 0;
                int approvedNum = 0;
                int settledNum = 0;
                for (TimesheetVO timesheetVO : timesheetVOS1) {
                    String tsStatus = timesheetVO.getTsStatus();
                    switch (TimesheetStatus.valueOf(tsStatus)) {
                        case CREATE: {
                            ++createNum;
                            break;
                        }
                        case REJECTED: {
                            ++rejectedNum;
                            break;
                        }
                        case APPROVING: {
                            ++approvingNum;
                            break;
                        }
                        case APPROVED: {
                            ++approvedNum;
                            break;
                        }
                        case SETTLED: {
                            ++settledNum;
                        }
                    }
                }
                if (rejectedNum > 0) {
                    status = TimesheetStatus.REJECTED.getCode();
                } else if (createNum > 0) {
                    status = TimesheetStatus.CREATE.getCode();
                } else if (approvingNum > 0) {
                    status = TimesheetStatus.APPROVING.getCode();
                } else if (approvedNum > 0) {
                    status = TimesheetStatus.APPROVED.getCode();
                } else if (settledNum > 0) {
                    status = TimesheetStatus.SETTLED.getCode();
                }
                BigDecimal reduce = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                    reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
                }
                HashMap<String, Object> result1 = new HashMap<String, Object>();
                result1.put("status", status);
                result1.put("hour", reduce);
                result.put(localDate, result1);
            }
            localDate = localDate.plusDays(1L);
        }
        return result;
    }

    public Boolean checkMonthlyTimesheet(String checkDate) {
        LocalDate date = LocalDate.parse(checkDate);
        LocalDate firstDay = LocalDate.of(date.getYear(), date.getMonth(), 1);
        LocalDate lastDay = date.with(TemporalAdjusters.lastDayOfMonth());
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.employeeDAO.queryByUserId(loginUserId);
        if (prdOrgEmployeeDO == null || prdOrgEmployeeDO.getEnrollDate() == null) {
            return true;
        }
        LocalDate enrollDate = prdOrgEmployeeDO.getEnrollDate();
        if (enrollDate.isAfter(firstDay)) {
            firstDay = enrollDate;
        }
        List<LocalDate> workDates = this.vacationRepo.selectWorkDaysByDays(firstDay, lastDay);
        TimesheetQuery query = new TimesheetQuery();
        query.setWorkDateIn(workDates);
        query.setTsUserId(loginUserId);
        List<TimesheetVO> timesheetVOS = this.queryList(query);
        Map<LocalDate, List<TimesheetVO>> groupTimesheetMap = timesheetVOS.stream().collect(Collectors.groupingBy(TimesheetVO::getWorkDate));
        boolean checkFlag = true;
        for (LocalDate localDate : workDates) {
            List<TimesheetVO> timesheetVOS1 = groupTimesheetMap.get(localDate);
            BigDecimal reduce = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty(timesheetVOS1)) {
                reduce = timesheetVOS1.stream().map(e -> e.getWorkHour()).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (reduce.compareTo(BigDecimal.valueOf(8L)) != -1) continue;
            checkFlag = false;
            break;
        }
        return checkFlag;
    }

    public void updateApprovingUser(List<Long> keys, Long apprUserId) {
        if (null == apprUserId || CollectionUtils.isEmpty(keys)) {
            log.warn("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff0c\u5de5\u65f6\u5217\u8868\u53d8\u66f4\u5ba1\u6279\u4eba\u9519\u8bef");
            return;
        }
        TsApprovalResQuery tsApprovalResQuery = new TsApprovalResQuery();
        tsApprovalResQuery.setTimesheetIds(keys);
        tsApprovalResQuery.setApprovalStatus(TimesheetStatus.APPROVING.getCode());
        List tsApprovalResVOS = this.tsApprovalResService.queryListDynamic(tsApprovalResQuery);
        for (TsApprovalResVO tsApprovalResVO : tsApprovalResVOS) {
            TsApprovalResPayload approvalResPayload = new TsApprovalResPayload();
            approvalResPayload.setId(tsApprovalResVO.getId());
            approvalResPayload.setApprovalResId(apprUserId);
            this.tsApprovalResService.updateByKeyDynamic(approvalResPayload);
        }
        this.timesheetRepo.updateApprovingUser(keys, apprUserId);
    }

    public void generateVacationPublicTimesheet(String param) {
    }

    public void generateVacationPrivateTimesheet(Long applyId) {
        UserVacationApplyVO applyVO = this.vacationApplyService.queryApplyByKey(String.valueOf(applyId));
        List applyDetailVOList = this.vacationApplyService.getDetailByApplyKey(applyId);
        if (applyVO != null && applyDetailVOList != null && !applyDetailVOList.isEmpty() && !"OTHER".equals(applyVO.getVacationType())) {
            TimesheetQuery query = new TimesheetQuery();
            List<LocalDate> workDateBetween = Arrays.asList(applyVO.getStartDate(), applyVO.getEndDate());
            query.setTsUserId(applyVO.getUserId());
            query.setWorkDateBetween(workDateBetween);
            List<TimesheetVO> timesheetVOList = this.queryList(query);
            ArrayList<LocalDate> timeDate = new ArrayList<LocalDate>();
            for (TimesheetVO time : timesheetVOList) {
                timeDate.add(time.getWorkDate());
            }
            for (UserVacationApplyDetailVO detail : applyDetailVOList) {
                BigDecimal workHour;
                if (timesheetVOList != null && timesheetVOList.size() > 0) {
                    workHour = new BigDecimal(8).multiply(detail.getVDays()).setScale(2, RoundingMode.HALF_UP);
                    if (timeDate.contains(detail.getVDate())) {
                        List<TimesheetVO> list = timesheetVOList.stream().filter(twTimesheetListView -> twTimesheetListView.getWorkDate().equals(detail.getVDate())).collect(Collectors.toList());
                        this.hadleTimesheetInsert(applyVO, detail.getVDate(), workHour, list, detail.getVInterval());
                        continue;
                    }
                    this.hadleTimesheetInsert(applyVO, detail.getVDate(), workHour, null, detail.getVInterval());
                    continue;
                }
                workHour = new BigDecimal(8).multiply(detail.getVDays()).setScale(2, RoundingMode.HALF_UP);
                this.hadleTimesheetInsert(applyVO, detail.getVDate(), workHour, null, detail.getVInterval());
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    void hadleTimesheetInsert(UserVacationApplyVO view, LocalDate workDate, BigDecimal workHour, List<TimesheetVO> list, String vInterval) {
        List refList;
        TimesheetPayload timesheetEntity = new TimesheetPayload();
        timesheetEntity.setTsUserId(view.getUserId());
        timesheetEntity.setTsStatus(TimesheetStatus.APPROVED.getCode());
        timesheetEntity.setWorkDate(workDate);
        timesheetEntity.setApprUserId(Long.valueOf(1381L));
        timesheetEntity.setApprovalTime(LocalDateTime.now());
        List<PrdOrgDataRefVO> prdOrgDataRefVOS = this.daoUser.queryOrgListByKey(view.getUserId());
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS) && !CollectionUtils.isEmpty(refList = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)refList.get(0)).getOrgId();
            String orgName = ((PrdOrgDataRefVO)refList.get(0)).getOrgName();
            timesheetEntity.setTsUserBuId(orgId);
            timesheetEntity.setTsUserBuName(orgName);
        }
        timesheetEntity.setWorkHour(workHour);
        timesheetEntity.setWorkDesc("\u8bf7\u5047\u6d41\u7a0b\u81ea\u52a8\u586b\u5199");
        int weekBaseYear = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekBasedYear());
        int weeks = timesheetEntity.getWorkDate().get(WeekFields.ISO.weekOfWeekBasedYear());
        String week = weeks < 10 ? "0" + weeks : "" + weeks;
        String yearWeek = weekBaseYear + week;
        timesheetEntity.setWeekStartDate(timesheetEntity.getWorkDate().with(DayOfWeek.MONDAY));
        timesheetEntity.setYearWeek(Integer.valueOf(Integer.parseInt(yearWeek)));
        timesheetEntity.setAutoSaveFlag(Integer.valueOf(1));
        timesheetEntity.setProjId(Long.valueOf(0L));
        timesheetEntity.setProjName("\u65e0\u9879\u76ee");
        timesheetEntity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
        if (view.getVacationType().equals("PERSONAL")) {
            timesheetEntity.setTsActIden(view.getVacationType());
        }
        if (view.getVacationType().equals("OFFICIAL") || view.getVacationType().equals("MARRIAGE") || view.getVacationType().equals("FUNERAL") || view.getVacationType().equals("ANNUAL")) {
            timesheetEntity.setTsActIden(view.getVacationType());
        }
        if (view.getVacationType().equals("PRENATAL_EXA") || view.getVacationType().equals("BREASTFEED") || view.getVacationType().equals("MATERNITY") || view.getVacationType().equals("PATERNITY")) {
            timesheetEntity.setTsActIden("MATERNITYLEAVE");
        }
        if (view.getVacationType().equals("SICK")) {
            timesheetEntity.setTsActIden("SICKLEAVE");
        }
        if (view.getVacationType().equals("IN_LIEU")) {
            timesheetEntity.setTsActIden("SHIFTING");
        }
        timesheetEntity.setTsTaskIden("VACATION");
        timesheetEntity.setSettleStatus("NONE");
        timesheetEntity.setProcId(view.getProcInstId());
        this.timesheetRepo.save((Object)TimesheetConvert.INSTANCE.toDo(timesheetEntity));
        if (!CollectionUtils.isEmpty(list)) {
            AtomicReference<BigDecimal> tempWorkHour = new AtomicReference<BigDecimal>(workHour);
            ArrayList updateList = new ArrayList();
            list.forEach(twTimesheetListView -> {
                TimesheetPayload entityTemp = new TimesheetPayload();
                TimesheetPayload updateEntity = new TimesheetPayload();
                BeanUtils.copyProperties((Object)twTimesheetListView, (Object)entityTemp);
                BeanUtils.copyProperties((Object)twTimesheetListView, (Object)updateEntity);
                if (((BigDecimal)tempWorkHour.get()).compareTo(BigDecimal.ZERO) > 0) {
                    if (updateEntity.getWorkHour().compareTo((BigDecimal)tempWorkHour.get()) > -1) {
                        BigDecimal subtract = updateEntity.getWorkHour().subtract((BigDecimal)tempWorkHour.get());
                        updateEntity.setWorkHour(subtract);
                    } else {
                        updateEntity.setWorkHour(BigDecimal.ZERO);
                    }
                }
                updateEntity.setAutoSaveFlag(Integer.valueOf(1));
                updateEntity.setProcId(view.getProcInstId());
                updateEntity.setAutoUpdateFlag(Integer.valueOf(1));
                updateList.add(updateEntity);
            });
            if (!CollectionUtils.isEmpty(updateList)) {
                updateList.forEach(twTimesheetEntity -> this.update((TimesheetPayload)twTimesheetEntity));
            }
        }
    }

    public List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.doListToSyncVo(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(TimesheetQuery query) {
        return this.timesheetRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = this.timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetVO insert(TimesheetPayload payload) {
        if (payload.getProjId() != null && payload.getProjId() != 0L) {
            payload.setTsTaskIden(null);
            payload.setTsActIden(null);
        }
        this.check(payload);
        this.initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        LocalDate workDate = payload.getWorkDate();
        int yearWeek = Integer.parseInt(DateUtil.getYearWeek(workDate));
        this.biweeklyReadFlagRepo.updateReadFlag(payload.getTsUserId(), 0);
        return TimesheetConvert.INSTANCE.toVo((TimesheetDO)((Object)this.timesheetRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            if (payload.getId() != null && payload.getId() > 0L) {
                TimesheetVO timesheetVO = this.queryByKey(payload.getId());
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error("", "\u53ea\u80fd\u63d0\u4ea4\u65b0\u5efa\u6216\u5df2\u9000\u56de\u7684\u5355\u636e");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            if (null == payload.getProjId()) {
                throw TwException.error("", "\u8bf7\u9009\u62e9\u9879\u76ee");
            }
            if (null == payload.getWorkDate()) {
                throw TwException.error("", "\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5\u671f");
            }
            if (!StringUtils.hasText((String)payload.getWorkDesc())) {
                throw TwException.error("", "\u8bf7\u8f93\u5165\u5de5\u4f5c\u65e5\u5fd7");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error("", "\u8bf7\u586b\u5199\u5de5\u65f6");
            }
            if (null != payload.getTaskId()) {
                TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
                if (null == taskVO) {
                    throw TwException.error("", "\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
                }
                if (!taskVO.getTaskStatus().equals("IN PROCESS") && !taskVO.getTaskIdV4().equals(0L)) {
                    throw TwException.error("", "\u8bf7\u9009\u62e9\u3010\u6fc0\u6d3b\u3011\u72b6\u6001\u7684\u4efb\u52a1\u5305");
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        return null;
    }

    private Map<Long, BigDecimal> calTsUsedEqvasByIds(List<Long> taskIdList) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTaskIdList(taskIdList);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        List<Object> tsViews = this.queryList(timesheetQuery);
        if (tsViews == null || tsViews.size() == 0) {
            return null;
        }
        Map<Long, BigDecimal> tsEqvaMap = this.calTsUsedEqvasByTsIds(tsViews.stream().map(ts -> ts.getId()).collect(Collectors.toList()));
        tsViews = tsViews.stream().map(ts -> {
            ts.setEqvaTimeSheet((BigDecimal)tsEqvaMap.get(ts.getId()));
            return ts;
        }).collect(Collectors.toList());
        HashMap<Long, BigDecimal> returnMap = new HashMap<Long, BigDecimal>();
        Map<Long, List<TimesheetVO>> taskTsMap = tsViews.stream().collect(Collectors.groupingBy(TimesheetVO::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            returnMap.put(taskId, taskTsMap.get(taskId).stream().map(ts -> ts.getEqvaTimeSheet() == null ? BigDecimal.ZERO : ts.getEqvaTimeSheet()).reduce(BigDecimal::add).get());
        }
        return returnMap;
    }

    private Map<Long, BigDecimal> calTsUsedEqvasByTsIds(List<Long> timeSheetIds) {
        log.warn("debug:::\u76ee\u6807\u64cd\u4f5c\u7684\u5de5\u65f6\u5217\u8868" + timeSheetIds);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        List<TimesheetVO> tsViews = this.queryList(timesheetQuery);
        List tsUserIdList = tsViews.stream().map(v -> v.getTsUserId()).collect(Collectors.toList());
        List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = this.employeeDAO.queryListByUserIdList(tsUserIdList);
        for (TimesheetVO v2 : tsViews) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(v2.getTaskId());
            if ("04".equals(taskVO.getAcceptMethod()) && taskVO.getEqvaRatio() != null) continue;
            v2.setEqvaRatio(null);
            BigDecimal eqvaRatio = this.employeeEqvaRatioService.getEqvaRatio(v2.getTsUserId(), v2.getWorkDate());
            v2.setEqvaRatio(eqvaRatio);
        }
        return tsViews.stream().collect(HashMap::new, (map, item) -> map.put(item.getId(), item.getEqvaTimeSheet()), HashMap::putAll);
    }

    private boolean workHourValidate(TimesheetListPayload payload) {
        Map<LocalDate, Double> resultMap = payload.getTimesheetList().stream().filter(timesheetPayload -> timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()))).collect(Collectors.groupingBy(TimesheetPayload::getWorkDate, Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)));
        ArrayList isValid = new ArrayList();
        resultMap.forEach((date, workHour) -> {
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
            query.setTsUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            List<TimesheetVO> timesheetVOList = this.queryList(query);
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8.0) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    private void initData(TimesheetPayload payload) {
        List list;
        List<PrdOrgDataRefVO> prdOrgDataRefVOS;
        payload.setWorkDayOffStatus("UNGEN");
        payload.setWorkFlag("NO");
        payload.setSettleStatus("NONE");
        payload.setAutoSaveFlag(Integer.valueOf(0));
        if (payload.getTsUserId() == null) {
            payload.setTsUserId(GlobalUtil.getLoginUserId());
        }
        if (!CollectionUtils.isEmpty(prdOrgDataRefVOS = this.daoUser.queryOrgListByKey(payload.getTsUserId())) && !CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            String orgName = ((PrdOrgDataRefVO)list.get(0)).getOrgName();
            payload.setTsUserBuId(orgId);
            payload.setTsUserBuName(orgName);
        }
        if (null != payload.getProjId()) {
            ProjectVO projectVO = this.projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        if (null != payload.getOperPlanId()) {
            CrmOperationPlanDetailVO planDetailVO = this.crmOperationPlanDetailService.queryByKey(payload.getOperPlanId());
            if (!StringUtils.hasText((String)payload.getOperPlanName())) {
                payload.setOperPlanName(null != planDetailVO ? planDetailVO.getPlanName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            payload.setTsStatus(TimesheetStatus.APPROVING.getCode());
            payload.setApprUserId(this.findApprUserId(payload));
            if (payload.getId() != null && payload.getId() > 0L) {
                entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
                payload.setSubmitTime(entity.getSubmitTime());
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
        } else if (payload.getId() != null && payload.getId() > 0L) {
            entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
            payload.setSubmitTime(entity.getSubmitTime());
            payload.setTsStatus(entity.getTsStatus());
        } else {
            payload.setTsStatus(TimesheetStatus.CREATE.getCode());
        }
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
    }

    private Long findApprUserId(TimesheetPayload payload) {
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
        if (payload.getTaskId() != null) {
            Long apprResIdByAuthInfo = this.taskService.getApprResIdByAuthInfo(payload.getTaskId());
            if (null != apprResIdByAuthInfo) {
                return apprResIdByAuthInfo;
            }
            Long taskDister = this.taskService.queryByTaskIdV4(payload.getTaskId()).getDisterUserId();
            if (taskDister != null && taskDister >= 0L) {
                return taskDister;
            }
        }
        if (payload.getProjId() != null) {
            Long pmId;
            ProjectQuery twProjectQuery = new ProjectQuery();
            twProjectQuery.setProjIdV4(payload.getProjId());
            List projects = this.projectService.queryList(twProjectQuery);
            if (projects != null && projects.size() > 0 && (pmId = ((ProjectVO)projects.get(0)).getPmUserId()) != null && pmId > 0L) {
                return pmId;
            }
        }
        if (null == (prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(payload.getTsUserId()))) {
            log.error("\u3010\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\u3011\uff1a\u5de5\u65f6\u586b\u62a5\u7528\u6237\u4e3b\u952e\uff1a{} ; \u5de5\u65f6\u6570\u636e\uff1a{}", (Object)payload.getTsUserId(), (Object)payload);
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long tsUserBuId = payload.getTsUserBuId();
        PrdOrgOrganizationDO prdOrgOrganizationDO = this.prdOrgOrganizationDAO.queryById(tsUserBuId);
        String organizationType = prdOrgOrganizationDO.getOrganizationType();
        if (organizationType != null) {
            Long apprUserId = null;
            switch (organizationType) {
                case "BD": 
                case "BY": {
                    List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(payload.getTsUserId());
                    Set orgIdList = null;
                    if (!CollectionUtils.isEmpty(organizationDOList)) {
                        orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                        if (orgIdList.contains(tsUserBuId)) {
                            Long parentId = prdOrgEmployeeRefVO.getParentId();
                            return parentId;
                        }
                        Long manageId = prdOrgEmployeeRefVO.getManageId();
                        return manageId;
                    }
                    apprUserId = prdOrgEmployeeRefVO.getManageId();
                    break;
                }
                case "BM": 
                case "BS": {
                    apprUserId = prdOrgEmployeeRefVO.getParentId();
                }
            }
            return apprUserId;
        }
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        return parentId;
    }

    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public TimesheetVO update(TimesheetPayload payload) {
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u521b\u5efa\u6216\u8005\u9000\u56de\u7684\u5de5\u65f6");
                    }
                    String overtimeApplicationId = entity.getExt2();
                    if (StringUtils.hasText((String)overtimeApplicationId) && "SHIFTING".equals(entity.getTsActIden())) {
                        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
                        overtimeApplicationDO.setRestStatus(RestStatusEnum.CREATE.getCode());
                        overtimeApplicationDO.setRestDate(entity.getWorkDate());
                        overtimeApplicationDO.setId(Long.valueOf(overtimeApplicationId));
                        this.overtimeApplicationDAO.updateRestStatusById(overtimeApplicationDO);
                    }
                }
            });
            this.timesheetDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void toApproved(List<Long> keys) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u6216\u65b0\u5efa\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    @Deprecated
    public void rejected(List<Long> keys, String apprResult) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void revoked(List<Long> keys) {
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskTimesheetEqva(List<Long> taskIdList) {
    }

    public Map<Long, Long> getTimesheetAndPlanIds() {
        HashMap<Long, Long> orgMap = new HashMap<Long, Long>();
        List<Map<String, Object>> timeSheetAndPlanIds = this.timesheetRepo.getTimesheetAndPlanIds();
        for (Map<String, Object> timesheetAndPlanId : timeSheetAndPlanIds) {
            Long timesheetId = (Long)timesheetAndPlanId.get("timesheetId");
            Long workPlanId = (Long)timesheetAndPlanId.get("workPlanId");
            if (timesheetId == null || workPlanId == null) continue;
            orgMap.put(timesheetId, workPlanId);
        }
        return orgMap;
    }

    public Map<Long, Long> getV4AndV5TimesheetIds() {
        HashMap<Long, Long> timesheetMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5TimesheetIds = this.timesheetRepo.getV4AndV5TimesheetIds();
        for (Map<String, Object> v4AndV5TimesheetId : v4AndV5TimesheetIds) {
            Long timesheetId = (Long)v4AndV5TimesheetId.get("timesheetId");
            Long timesheetIdV4 = (Long)v4AndV5TimesheetId.get("timesheetIdV4");
            if (timesheetId == null || timesheetIdV4 == null) continue;
            timesheetMap.put(timesheetIdV4, timesheetId);
        }
        return timesheetMap;
    }

    public String timesheetAlertAll(Long employeeId) {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        if (employeeId != null) {
            onJobUsers = Arrays.asList((PrdOrgEmployeeDO)this.prdOrgEmployeeRepo.findById(employeeId).get());
        }
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        LocalDate workDay = firstDayMonth;
        List<LocalDate> workDays = this.vacationRepo.selectWorkDaysByDays(firstDayMonth, today);
        if (workDays.contains(today)) {
            long difference = LocalDate.now().toEpochDay() - firstDayMonth.toEpochDay();
            ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
            ArrayList<String> sendLogList = new ArrayList<String>();
            ArrayList<String> unSendLogList = new ArrayList<String>();
            if (difference >= 0L) {
                while (workDay.isBefore(LocalDate.now().plusDays(1L))) {
                    dateList.add(workDay);
                    workDay = workDay.plusDays(1L);
                }
                for (PrdOrgEmployeeDO user : onJobUsers) {
                    HashSet unWritedSet;
                    List<LocalDate> writeDateList;
                    LocalDate enrollDate = user.getEnrollDate();
                    if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                        if (enrollDate.isBefore(firstDayMonth)) {
                            writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, today);
                            unWritedSet = new HashSet(dateList);
                        } else if (enrollDate.isAfter(today)) {
                            writeDateList = new ArrayList<LocalDate>(0);
                            unWritedSet = new HashSet(0);
                        } else {
                            ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                            while (enrollDate.isBefore(today.plusDays(1L))) {
                                enDateList.add(enrollDate);
                                enrollDate = enrollDate.plusDays(1L);
                            }
                            writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, today);
                            unWritedSet = new HashSet(enDateList);
                        }
                    } else {
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, today);
                        unWritedSet = new HashSet(dateList);
                    }
                    HashSet<LocalDate> writedSet = new HashSet<LocalDate>(writeDateList);
                    unWritedSet.removeAll(writedSet);
                    if (unWritedSet.size() <= 0) continue;
                    List unWriteDateList = unWritedSet.stream().toList();
                    String content = "\u60a8" + unWriteDateList + "\u5de5\u65f6\u672a\u63d0\u4ea4\u6216\u63d0\u4ea4\u4e0d\u8db38\u5c0f\u65f6,\u8bf7\u53ca\u65f6\u63d0\u4ea4";
                    String employeeName = user.getEmployeeName();
                    boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(user.getWecomId(), content);
                    if (sendFlag) {
                        sendLogList.add(employeeName);
                        continue;
                    }
                    unSendLogList.add(employeeName);
                }
            }
            return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
        }
        return null;
    }

    public String timesheetAlertAllBack(Long employeeId) {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        if (employeeId != null) {
            onJobUsers = Arrays.asList((PrdOrgEmployeeDO)this.prdOrgEmployeeRepo.findById(employeeId).get());
        }
        LocalDate firstDayMonth = LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        LocalDate workDay = firstDayMonth;
        List<LocalDate> workDays = this.vacationRepo.selectWorkDaysByDays(firstDayMonth, today);
        if (workDays.contains(today)) {
            long difference = LocalDate.now().toEpochDay() - firstDayMonth.toEpochDay();
            ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
            ArrayList<String> sendLogList = new ArrayList<String>();
            ArrayList<String> unSendLogList = new ArrayList<String>();
            if (difference >= 0L) {
                while (workDay.isBefore(LocalDate.now().plusDays(1L))) {
                    dateList.add(workDay);
                    workDay = workDay.plusDays(1L);
                }
                for (PrdOrgEmployeeDO user : onJobUsers) {
                    HashSet<LocalDate> backSet;
                    List<LocalDate> backDateList;
                    LocalDate enrollDate = user.getEnrollDate();
                    if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                        if (enrollDate.isBefore(firstDayMonth)) {
                            backDateList = this.timesheetDAO.backDate(user.getUserId(), firstDayMonth, today);
                            backSet = new HashSet<LocalDate>(backDateList);
                        } else if (enrollDate.isAfter(today)) {
                            backDateList = new ArrayList<LocalDate>(0);
                            backSet = new HashSet(0);
                        } else {
                            ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                            while (enrollDate.isBefore(today.plusDays(1L))) {
                                enDateList.add(enrollDate);
                                enrollDate = enrollDate.plusDays(1L);
                            }
                            backDateList = this.timesheetDAO.backDate(user.getUserId(), firstDayMonth, today);
                            backSet = new HashSet<LocalDate>(backDateList);
                        }
                    } else {
                        backDateList = this.timesheetDAO.backDate(user.getUserId(), firstDayMonth, today);
                        backSet = new HashSet<LocalDate>(backDateList);
                    }
                    if (backSet.size() <= 0) continue;
                    backDateList = backSet.stream().toList();
                    String content = "\u60a8" + backDateList + "\u5de5\u65f6\u88ab\u9000\u56de\uff0c\u8bf7\u53ca\u65f6\u8fdb\u5165TW\u5904\u7406";
                    String employeeName = user.getEmployeeName();
                    boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(user.getWecomId(), content);
                    if (sendFlag) {
                        sendLogList.add(employeeName);
                        continue;
                    }
                    unSendLogList.add(employeeName);
                }
            }
            return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
        }
        return null;
    }

    public String timesheetAlertSuperior() {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastThreeDay = LocalDate.now().minusDays(3L);
        LocalDate workDay = firstDayMonth;
        List<PrdOrgEmployeeSuperiorQuery> userSuperiorList = this.prdOrgEmployeeDAO.getUserSuperior();
        Map<Long, Long> userSuperiorMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getEmployeeId, PrdOrgEmployeeSuperiorQuery::getSuperiorId));
        Map<Long, String> superiorNameMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorName, (val1, val2) -> val2));
        Map<Long, String> superiorWxMap = userSuperiorList.stream().collect(Collectors.toMap(PrdOrgEmployeeSuperiorQuery::getSuperiorId, PrdOrgEmployeeSuperiorQuery::getSuperiorWxId, (val1, val2) -> val2));
        HashMap<Long, Object> superiorMap = new HashMap<Long, Object>();
        ArrayList<CallSite> sendLogList = new ArrayList<CallSite>();
        ArrayList<CallSite> unSendLogList = new ArrayList<CallSite>();
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        long difference = lastThreeDay.toEpochDay() - firstDayMonth.toEpochDay();
        if (difference >= 0L) {
            while (workDay.isBefore(lastThreeDay.plusDays(1L))) {
                dateList.add(workDay);
                workDay = workDay.plusDays(1L);
            }
            for (PrdOrgEmployeeDO user : onJobUsers) {
                HashSet unWritedSet;
                List<LocalDate> writeDateList;
                if (!userSuperiorMap.containsKey(user.getUserId())) continue;
                LocalDate enrollDate = user.getEnrollDate();
                if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                    if (enrollDate.isBefore(firstDayMonth)) {
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                        unWritedSet = new HashSet(dateList);
                    } else if (enrollDate.isAfter(lastThreeDay)) {
                        writeDateList = new ArrayList<LocalDate>(0);
                        unWritedSet = new HashSet(0);
                    } else {
                        ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                        while (enrollDate.isBefore(lastThreeDay.plusDays(1L))) {
                            enDateList.add(enrollDate);
                            enrollDate = enrollDate.plusDays(1L);
                        }
                        writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                        unWritedSet = new HashSet(enDateList);
                    }
                } else {
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), firstDayMonth, lastThreeDay);
                    unWritedSet = new HashSet(dateList);
                }
                HashSet<LocalDate> writedSet = new HashSet<LocalDate>(writeDateList);
                unWritedSet.removeAll(writedSet);
                if (unWritedSet.size() <= 0) continue;
                String userContent = user.getEmployeeName();
                Long superiorId = userSuperiorMap.get(user.getUserId());
                if (superiorMap.containsKey(superiorId)) {
                    Object content = (String)superiorMap.get(superiorId);
                    content = (String)content + "," + userContent;
                    superiorMap.put(superiorId, content);
                    continue;
                }
                superiorMap.put(superiorId, userContent);
            }
            for (Long superiorId : superiorMap.keySet()) {
                String content = "\u60a8\u7684\u4e0b\u7ea7\u3010" + (String)superiorMap.get(superiorId) + "\u3011 \u5de5\u65f6\u5df2\u957f\u65f6\u95f4\u5ef6\u8bef\u672a\u586b\u5199\uff0c\u8bf7\u5e2e\u5fd9\u8ddf\u50ac\u4ee5\u514d\u5f71\u54cd\u5de5\u65f6\u7ed3\u7b97\u3002";
                boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(superiorWxMap.get(superiorId), content);
                String log = superiorNameMap.get(superiorId) + ":\u3010" + (String)superiorMap.get(superiorId) + "\u3011\n";
                if (sendFlag) {
                    sendLogList.add((CallSite)((Object)log));
                    continue;
                }
                unSendLogList.add((CallSite)((Object)log));
            }
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    public String timesheetAlertBuLeader() {
        List<PrdOrgEmployeeDO> onJobUsers = this.prdOrgEmployeeDAO.getOnJobUser();
        LocalDate lastMonday = LocalDate.now().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).minusDays(7L);
        LocalDate lastFriday = lastMonday.plusDays(4L);
        LocalDate workDay = lastMonday;
        List<PrdOrgEmployeeLeaderQuery> userBuLeaderList = this.prdOrgEmployeeDAO.getUserBuLeader();
        Map<Long, Long> userBuLeaderMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getEmployeeId, PrdOrgEmployeeLeaderQuery::getOrgLeaderId));
        Map<Long, String> userBuLeaderNameMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderName, (val1, val2) -> val2));
        Map<Long, String> buLeaderWxMap = userBuLeaderList.stream().collect(Collectors.toMap(PrdOrgEmployeeLeaderQuery::getOrgLeaderId, PrdOrgEmployeeLeaderQuery::getOrgLeaderWxId, (val1, val2) -> val2));
        HashMap<Long, Object> buLeaderMap = new HashMap<Long, Object>();
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        ArrayList<CallSite> sendLogList = new ArrayList<CallSite>();
        ArrayList<CallSite> unSendLogList = new ArrayList<CallSite>();
        while (workDay.isBefore(lastFriday.plusDays(1L))) {
            dateList.add(workDay);
            workDay = workDay.plusDays(1L);
        }
        for (PrdOrgEmployeeDO user : onJobUsers) {
            HashSet unWritedSet;
            List<LocalDate> writeDateList;
            if (!userBuLeaderMap.containsKey(user.getUserId())) continue;
            LocalDate enrollDate = user.getEnrollDate();
            if (!ObjectUtils.isEmpty((Object)enrollDate)) {
                if (enrollDate.isBefore(lastMonday)) {
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                    unWritedSet = new HashSet(dateList);
                } else if (enrollDate.isAfter(lastFriday)) {
                    writeDateList = new ArrayList<LocalDate>(0);
                    unWritedSet = new HashSet(0);
                } else {
                    ArrayList<LocalDate> enDateList = new ArrayList<LocalDate>();
                    while (enrollDate.isBefore(lastFriday.plusDays(1L))) {
                        enDateList.add(enrollDate);
                        enrollDate = enrollDate.plusDays(1L);
                    }
                    writeDateList = this.timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                    unWritedSet = new HashSet(enDateList);
                }
            } else {
                writeDateList = this.timesheetDAO.writedDate(user.getUserId(), lastMonday, lastFriday);
                unWritedSet = new HashSet(dateList);
            }
            HashSet<LocalDate> writedSet = new HashSet<LocalDate>(writeDateList);
            unWritedSet.removeAll(writedSet);
            if (unWritedSet.size() <= 0) continue;
            String userContent = user.getEmployeeName();
            Long buLeaderId = userBuLeaderMap.get(user.getUserId());
            if (buLeaderMap.containsKey(buLeaderId)) {
                Object content = (String)buLeaderMap.get(buLeaderId);
                content = (String)content + "," + userContent;
                buLeaderMap.put(buLeaderId, content);
                continue;
            }
            buLeaderMap.put(buLeaderId, userContent);
        }
        for (Long buLeaderId : buLeaderMap.keySet()) {
            String content = "\u60a8\u7684\u90e8\u95e8\u6210\u5458\u3010" + (String)buLeaderMap.get(buLeaderId) + "\u3011\u4e0a\u5468\u6709\u5de5\u65f6\u672a\u586b\u5199\uff0c\u8bf7\u5e2e\u5fd9\u8ddf\u50ac\u4ee5\u514d\u5f71\u54cd\u5de5\u65f6\u7ed3\u7b97\u3002";
            boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(buLeaderWxMap.get(buLeaderId), content);
            String log = userBuLeaderNameMap.get(buLeaderId) + ":\u3010" + (String)buLeaderMap.get(buLeaderId) + "\u3011\n";
            if (sendFlag) {
                sendLogList.add((CallSite)((Object)log));
                continue;
            }
            unSendLogList.add((CallSite)((Object)log));
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    public void repairTimesheet() {
        List<Map<String, Object>> timesheetList = this.timesheetRepo.queryTimeSheetToRepair();
        for (Map<String, Object> timesheet : timesheetList) {
            BigInteger tsUserId;
            BigInteger id = (BigInteger)timesheet.get("id");
            BigInteger projId = (BigInteger)timesheet.get("projId");
            Map<String, Object> timesheetToCopy = this.timesheetRepo.queryTimeSheetToCopy(projId, tsUserId = (BigInteger)timesheet.get("tsUserId"));
            if (ObjectUtils.isEmpty(timesheetToCopy)) continue;
            this.timesheetRepo.updateTimesheetByCopy((BigInteger)timesheetToCopy.get("taskId"), (String)timesheetToCopy.get("taskNo"), (String)timesheetToCopy.get("taskName"), (BigInteger)timesheetToCopy.get("actId"), (String)timesheetToCopy.get("actNo"), (String)timesheetToCopy.get("actName"), id);
        }
    }

    public String timesheetApprovingAlert() {
        LocalDate firstDayMonth = LocalDate.now().with(TemporalAdjusters.firstDayOfMonth());
        LocalDate today = LocalDate.now();
        ArrayList<CallSite> sendLogList = new ArrayList<CallSite>();
        ArrayList<CallSite> unSendLogList = new ArrayList<CallSite>();
        HashMap<Long, Object> apprMap = new HashMap<Long, Object>();
        List<TimesheetApproveQuery> timesheetApproverList = this.timesheetDAO.approvingDate(firstDayMonth, today);
        Map<Long, String> apprWxMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprWxId, (val1, val2) -> val2));
        Map<Long, String> apprNameMap = timesheetApproverList.stream().collect(Collectors.toMap(TimesheetApproveQuery::getApprUserId, TimesheetApproveQuery::getApprName, (val1, val2) -> val2));
        for (TimesheetApproveQuery timesheetApproveQuery : timesheetApproverList) {
            String userContent = timesheetApproveQuery.getEmployeeName();
            Long apprUserId = timesheetApproveQuery.getApprUserId();
            if (apprMap.containsKey(apprUserId)) {
                Object content = (String)apprMap.get(apprUserId);
                content = (String)content + "," + userContent;
                apprMap.put(apprUserId, content);
                continue;
            }
            apprMap.put(apprUserId, userContent);
        }
        for (Long apprUserId : apprMap.keySet()) {
            String content = "\u60a8\u6709\u3010" + (String)apprMap.get(apprUserId) + "\u3011 \u63d0\u4ea4\u7684\u5de5\u65f6\u672a\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5ba1\u6279";
            boolean sendFlag = this.qyWxCommunicationService.sendMessageToUserByWecomId(apprWxMap.get(apprUserId), content);
            String log = apprNameMap.get(apprUserId) + ":\u3010" + (String)apprMap.get(apprUserId) + "\u3011\n";
            if (sendFlag) {
                sendLogList.add((CallSite)((Object)log));
                continue;
            }
            unSendLogList.add((CallSite)((Object)log));
        }
        return "\u6210\u529f:" + sendLogList + "\u5931\u8d25:" + unSendLogList;
    }

    public boolean checkTimeSheetStatueInCreateAndRejected(LocalDate startDate, LocalDate endDate, Long userId) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        if (null == endDate) {
            throw TwException.error("", "\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == startDate) {
            timesheetQuery.setWorkDateLessThanQuery(endDate);
        } else {
            ArrayList<LocalDate> workDateList = new ArrayList<LocalDate>();
            workDateList.add(startDate);
            workDateList.add(endDate);
            timesheetQuery.setWorkDateBetween(workDateList);
        }
        timesheetQuery.setTsUserId(userId);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add(TimesheetStatus.CREATE.getCode());
        tsStatusList.add(TimesheetStatus.REJECTED.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        long count = this.count(timesheetQuery);
        return count > 0L;
    }

    @Transactional
    public void taskApprovalTimesheet(String param) {
        LocalDate lastDayOfMonth;
        LocalDate nowLocalDate = LocalDate.now().minusMonths(1L);
        LocalDate firstDayOfMonth = nowLocalDate.with(TemporalAdjusters.firstDayOfMonth());
        List<Long> naturalDateList = this.timesheetDAO.getWeekNotWorkDate(firstDayOfMonth, lastDayOfMonth = nowLocalDate.with(TemporalAdjusters.lastDayOfMonth()));
        if (!CollectionUtils.isEmpty(naturalDateList)) {
            Long res = this.timesheetDAO.updateStateByTask(naturalDateList);
            log.info("Task\u4fee\u6539\u5047\u671f\u5ba1\u6279\u72b6\u6001res:{}", (Object)res);
        }
    }

    public TimesheetServiceImpl(TimesheetRepo timesheetRepo, TaskService taskService, TaskRepo taskRepo, ResActivityService resActivityService, CrmOperationPlanDetailService crmOperationPlanDetailService, ProjectService projectService, PrdOrgEmployeeDAO employeeDAO, JPAQueryFactory jpaQueryFactory, PrdUserService prdUserService, HttpUtil httpUtil, PrdOrgSyncLogDAO daoLog, PrdSystemRoleDAO systemRoleDAO, PrdUserDAO daoUser, PrdOrgOrganizationDAO prdOrgOrganizationDAO, TimesheetDAO timesheetDAO, TimesheetBiweeklyReadFlagRepo biweeklyReadFlagRepo, PrdOrgEmployeeEqvaRatioService employeeEqvaRatioService, QyWxCommunicationService qyWxCommunicationService, PrdOrgEmployeeDAO prdOrgEmployeeDAO, PrdOrgEmployeeRepo prdOrgEmployeeRepo, OvertimeApplicationRepo overtimeApplicationRepo, OvertimeApplicationDAO overtimeApplicationDAO, PrdOrgEmployeeService prdOrgEmployeeService, VacationRepo vacationRepo, UserVacationApplyService vacationApplyService, TsApprovalResService tsApprovalResService) {
        this.timesheetRepo = timesheetRepo;
        this.taskService = taskService;
        this.taskRepo = taskRepo;
        this.resActivityService = resActivityService;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.projectService = projectService;
        this.employeeDAO = employeeDAO;
        this.jpaQueryFactory = jpaQueryFactory;
        this.prdUserService = prdUserService;
        this.httpUtil = httpUtil;
        this.daoLog = daoLog;
        this.systemRoleDAO = systemRoleDAO;
        this.daoUser = daoUser;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.timesheetDAO = timesheetDAO;
        this.biweeklyReadFlagRepo = biweeklyReadFlagRepo;
        this.employeeEqvaRatioService = employeeEqvaRatioService;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.prdOrgEmployeeRepo = prdOrgEmployeeRepo;
        this.overtimeApplicationRepo = overtimeApplicationRepo;
        this.overtimeApplicationDAO = overtimeApplicationDAO;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.vacationRepo = vacationRepo;
        this.vacationApplyService = vacationApplyService;
        this.tsApprovalResService = tsApprovalResService;
    }
}

