/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.identity.service;

import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessCutomerManagePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookContactsQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerListSimpleQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessCutomerManageVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessCustomerInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.query.BusinessSupplierInfoQuery;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessSupplierInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessSupplierInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.team.payload.BusinessTeamMemberPayload;
import com.elitesland.tw.tw5.api.prd.partner.team.query.BusinessTeamMemberQuery;
import com.elitesland.tw.tw5.api.prd.partner.team.service.BusinessTeamMemberService;
import com.elitesland.tw.tw5.api.prd.partner.team.vo.BusinessTeamMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamRoleEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessTeamTypeEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.convert.BusinessCustomerInfoConvert;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessCustomerInfoDAO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.BusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.repo.BusinessCustomerInfoRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessCustomerInfoServiceImpl
extends BaseServiceImpl
implements BusinessCustomerInfoService {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerInfoServiceImpl.class);
    private final BusinessCustomerInfoRepo businessCustomerInfoRepo;
    private final BusinessCustomerInfoDAO businessCustomerInfoDAO;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final CrmLeadsDAO leadsDAO;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CacheUtil cacheUtil;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final PrdOrgOrganizationDAO daoOrg;
    @Value(value="${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    @Value(value="${tw4.prd_ab.updateCustomerOperation:api/openReport/v1/sync/asyncUpdateCustomerTask}")
    private String prd_ab_operation;
    @Value(value="${tw5.jde.syncJdeUrl}")
    private String syncJdeUrl;
    @Value(value="${tw5.jde.username}")
    private String username;
    @Value(value="${tw5.jde.password}")
    private String password;
    @Value(value="${tw5.jde.count:3}")
    private Integer count;
    private final HttpUtil httpUtil;
    private final ApiRequestLogService apiRequestLogService;
    private final BookInvoiceService bookInvoiceService;
    private final BusinessSupplierInfoService businessSupplierInfoService;
    private final BookContactsService bookContactsService;

    public PagingVO<BusinessCustomerInfoVO> queryPaging(BusinessCustomerInfoQuery query) {
        PagingVO<BusinessCustomerInfoVO> businessCustomerInfoVOPagingVO = this.businessCustomerInfoDAO.queryPaging(query);
        return businessCustomerInfoVOPagingVO;
    }

    public List<BusinessCustomerInfoVO> queryListDynamic(BusinessCustomerInfoQuery query) {
        List<BusinessCustomerInfoVO> businessCustomerInfoVOS = this.businessCustomerInfoDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(businessCustomerInfoVOS)) {
            businessCustomerInfoVOS.stream().forEach(p -> this.translate((BusinessCustomerInfoVO)p));
        }
        return businessCustomerInfoVOS;
    }

    public BusinessCustomerInfoVO queryByKey(Long key) {
        BusinessCustomerInfoDO entity = this.businessCustomerInfoRepo.findById(key).orElseGet(BusinessCustomerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerInfoVO vo = BusinessCustomerInfoConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    public BusinessCustomerInfoVO queryByPartnerId(Long partnerId) {
        BusinessCustomerInfoDO entity = this.businessCustomerInfoRepo.findByPartnerId(partnerId);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerInfoVO vo = BusinessCustomerInfoConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerInfoVO insert(BusinessCustomerInfoPayload payload) {
        payload.setSyncJdeFlag(Boolean.valueOf(false));
        BusinessCustomerInfoDO entityDo = BusinessCustomerInfoConvert.INSTANCE.toDo(payload);
        BusinessCustomerInfoDO save = (BusinessCustomerInfoDO)this.businessCustomerInfoRepo.save(entityDo);
        return BusinessCustomerInfoConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public BusinessCustomerInfoVO update(BusinessCustomerInfoPayload payload) {
        BusinessCustomerInfoDO entity = this.businessCustomerInfoRepo.findById(payload.getId()).orElseGet(BusinessCustomerInfoDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BusinessCustomerInfoDO entityLog = new BusinessCustomerInfoDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        BusinessCustomerInfoDO entityDo = BusinessCustomerInfoConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (null != payload.getPartnerId()) {
            StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
            fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
            if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
            }
        }
        BusinessCustomerInfoDO save = (BusinessCustomerInfoDO)this.businessCustomerInfoRepo.save(entity);
        if (payload.getServiceUserId() != null || payload.getBusinessUserId() != null || payload.getCareUserId() != null || payload.getOperationUserId() != null) {
            BusinessCutomerManagePayload businessCutomerManagePayload = new BusinessCutomerManagePayload();
            businessCutomerManagePayload.setBusinessUserId(payload.getBusinessUserId());
            businessCutomerManagePayload.setServiceUserId(payload.getServiceUserId());
            businessCutomerManagePayload.setCareUserId(payload.getCareUserId());
            businessCutomerManagePayload.setOperationUserId(payload.getOperationUserId());
            businessCutomerManagePayload.setId(save.getPartnerId());
            this.updateCustomerManageTeamMember(businessCutomerManagePayload);
        }
        Long partnerId = save.getPartnerId();
        return BusinessCustomerInfoConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.businessCustomerInfoDAO.deleteSoft(keys);
        }
    }

    public List<BusinessCustomerSimpleVO> listSimple(String identity, String customerStatus) {
        if (BusinessPartnerIdentityEnum.INNER.getCode().equals(identity)) {
            return this.businessCustomerInfoDAO.queryInnerCompany();
        }
        List<BusinessCustomerSimpleVO> businessCustomerSimpleVOS = this.businessCustomerInfoDAO.listSimple(identity, customerStatus);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)identity) && BusinessPartnerIdentityEnum.SUPPLIER.getCode().equals(identity)) {
            List ids = businessCustomerSimpleVOS.stream().map(x -> x.getId()).collect(Collectors.toList());
            BusinessSupplierInfoQuery businessSupplierInfoQuery = new BusinessSupplierInfoQuery();
            businessSupplierInfoQuery.setPartnerIds(ids);
            List businessSupplierInfoVOS = this.businessSupplierInfoService.queryListDynamic(businessSupplierInfoQuery);
            Map<Long, String> maps = businessSupplierInfoVOS.stream().collect(Collectors.toMap(BusinessSupplierInfoVO::getPartnerId, BusinessSupplierInfoVO::getSupplierStatus));
            for (BusinessCustomerSimpleVO businessCustomerSimpleVO : businessCustomerSimpleVOS) {
                String status = maps.get(businessCustomerSimpleVO.getId());
                businessCustomerSimpleVO.setSupplierStatus(status);
            }
        }
        List bookIdList = businessCustomerSimpleVOS.stream().map(x -> x.getBookId()).collect(Collectors.toList());
        BookContactsQuery bookContactsQuery = new BookContactsQuery();
        bookContactsQuery.setBookIdList(bookIdList);
        bookContactsQuery.setIsDefault(Boolean.valueOf(true));
        List bookContactsVOS = this.bookContactsService.queryListDynamic(bookContactsQuery);
        if (!CollectionUtils.isEmpty((Collection)bookContactsVOS)) {
            Map<Long, List<BookContactsVO>> bookContactMap = bookContactsVOS.stream().collect(Collectors.groupingBy(BookContactsVO::getBookId));
            for (BusinessCustomerSimpleVO businessCustomerSimpleVO : businessCustomerSimpleVOS) {
                if (!bookContactMap.containsKey(businessCustomerSimpleVO.getBookId())) continue;
                businessCustomerSimpleVO.setBookContactsVO(bookContactMap.get(businessCustomerSimpleVO.getBookId()).get(0));
            }
        }
        return businessCustomerSimpleVOS;
    }

    public PagingVO<BusinessCustomerSimpleVO> listSimplePaging(BusinessPartnerListSimpleQuery query) {
        PagingVO<BusinessCustomerSimpleVO> businessCustomerSimpleVOPagingVO = this.businessCustomerInfoDAO.listSimplePaging(query);
        return businessCustomerSimpleVOPagingVO;
    }

    public CrmCustomerSimpleVO listSimpleByPartnerId(Long partnerId) {
        return this.businessCustomerInfoDAO.listSimpleByPartnerId(partnerId);
    }

    public List<BusinessStrategyCustomerVO> queryCustomerList(BusinessPartnerQuery query) {
        return this.businessCustomerInfoDAO.queryCustomerList(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCustomerGrade() {
        this.businessCustomerInfoDAO.updateCustomerGrade();
    }

    @Transactional(rollbackFor={Exception.class})
    public void changeCustomerGrade(Long partnerId, String customerGrade) {
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setFormalCustomerId(partnerId);
        Specification<CrmLeadsDO> spec = this.leadsDAO.getSpec(leadsQuery);
        List<CrmLeadsDO> leadsDOS = this.leadsDAO.findAll(spec);
        List<Long> leadsIds = leadsDOS.stream().map(e -> e.getId()).collect(Collectors.toList());
        this.leadsDAO.updateCustomerGrade(leadsIds, customerGrade);
        List collect = leadsDOS.stream().filter(e -> e.getPotentialCustomerId() != null).collect(Collectors.toList());
        List<Long> potentialCustomerIds = collect.stream().map(e -> e.getPotentialCustomerId()).collect(Collectors.toList());
        this.potentialCustomerDAO.updateCustomerGrade(potentialCustomerIds, customerGrade);
    }

    public PagingVO<BusinessCutomerManageVO> queryCustomerManage(BusinessCustomerInfoQuery query) {
        List idList;
        this.dataPermission(query);
        PagingVO<BusinessCutomerManageVO> businessCutomerManageVOPagingVO = this.businessCustomerInfoDAO.queryCustomerManage(query);
        if (!CollectionUtils.isEmpty((Collection)businessCutomerManageVOPagingVO.getRecords()) && !CollectionUtils.isEmpty(idList = businessCutomerManageVOPagingVO.stream().map(p -> p.getId()).collect(Collectors.toList()))) {
            HashMap<Long, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap();
            BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
            teamMemberQuery.setObjectIdList(idList);
            BusinessTeamMemberService businessTeamMemberService = (BusinessTeamMemberService)SpringUtil.getBean(BusinessTeamMemberService.class);
            List businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
            if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
                teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getObjectId));
            }
            for (BusinessCutomerManageVO businessCutomerManageVO : businessCutomerManageVOPagingVO.getRecords()) {
                this.customerManageTranslate(businessCutomerManageVO, teamMemberMap);
            }
        }
        return businessCutomerManageVOPagingVO;
    }

    public List<BusinessCutomerManageVO> queryCustomerManageList(BusinessCustomerInfoQuery query) {
        List idList;
        this.dataPermission(query);
        List<BusinessCutomerManageVO> businessCutomerManageVOVOS = this.businessCustomerInfoDAO.queryCustomerManageList(query);
        if (!CollectionUtils.isEmpty(businessCutomerManageVOVOS) && !CollectionUtils.isEmpty(idList = businessCutomerManageVOVOS.stream().map(p -> p.getId()).collect(Collectors.toList()))) {
            HashMap<Long, List<BusinessTeamMemberVO>> teamMemberMap = new HashMap();
            BusinessTeamMemberQuery teamMemberQuery = new BusinessTeamMemberQuery();
            teamMemberQuery.setObjectIdList(idList);
            BusinessTeamMemberService businessTeamMemberService = (BusinessTeamMemberService)SpringUtil.getBean(BusinessTeamMemberService.class);
            List businessTeamMemberVOS = businessTeamMemberService.queryListDynamic(teamMemberQuery);
            if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
                teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getObjectId));
            }
            for (BusinessCutomerManageVO businessCutomerManageVO : businessCutomerManageVOVOS) {
                this.customerManageTranslate(businessCutomerManageVO, teamMemberMap);
            }
        }
        return businessCutomerManageVOVOS;
    }

    public BusinessCutomerManageVO queryCustomerManageByPartnerId(Long id) {
        return this.businessCustomerInfoDAO.queryCustomerManageByPartnerId(id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCustomerManageTeamMember(BusinessCutomerManagePayload payload) {
        BusinessTeamMemberVO businessTeamMemberVO;
        List businessTeamMemberVOS1;
        BusinessTeamMemberPayload businessTeamMemberPayload;
        Long orgId;
        BusinessTeamMemberService businessTeamMemberService = (BusinessTeamMemberService)SpringUtil.getBean(BusinessTeamMemberService.class);
        List businessTeamMemberVOS = businessTeamMemberService.queryByObjectId(payload.getId());
        Map<Object, Object> teamMemberMap = new HashMap();
        ArrayList<BusinessTeamMemberPayload> payloadList = new ArrayList<BusinessTeamMemberPayload>();
        if (!CollectionUtils.isEmpty((Collection)businessTeamMemberVOS)) {
            teamMemberMap = businessTeamMemberVOS.stream().collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole));
        }
        if (payload.getServiceUserId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getServiceUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberVOS1 = (List)teamMemberMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                businessTeamMemberVO = (BusinessTeamMemberVO)businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getServiceUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getServiceUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getServiceUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getServiceUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SERVICE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SERVICE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (payload.getBusinessUserId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getBusinessUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberVOS1 = (List)teamMemberMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
                businessTeamMemberVO = (BusinessTeamMemberVO)businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getBusinessUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getBusinessUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getBusinessUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getBusinessUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.SALE_MANAGER.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.SALE_MANAGER.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.SALE_MANAGER.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (payload.getCareUserId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getCareUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberVOS1 = (List)teamMemberMap.get(BusinessTeamRoleEnum.CARE.getCode());
                businessTeamMemberVO = (BusinessTeamMemberVO)businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getCareUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getCareUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getCareUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getCareUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.CARE.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.CARE.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.CARE.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (payload.getOperationUserId() != null) {
            orgId = this.cacheUtil.getDefaultOrgIdByUserId(payload.getOperationUserId());
            if (teamMemberMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberVOS1 = (List)teamMemberMap.get(BusinessTeamRoleEnum.OPERATION.getCode());
                businessTeamMemberVO = (BusinessTeamMemberVO)businessTeamMemberVOS1.get(0);
                businessTeamMemberPayload.setId(businessTeamMemberVO.getId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getOperationUserId()));
                businessTeamMemberPayload.setOrgId(orgId);
                businessTeamMemberPayload.setUserId(payload.getOperationUserId());
                businessTeamMemberService.update(businessTeamMemberPayload);
            } else {
                businessTeamMemberPayload = new BusinessTeamMemberPayload();
                businessTeamMemberPayload.setUserId(payload.getOperationUserId());
                businessTeamMemberPayload.setMemberName(this.cacheUtil.getUserName(payload.getOperationUserId()));
                businessTeamMemberPayload.setMemberRole(BusinessTeamRoleEnum.OPERATION.getCode());
                businessTeamMemberPayload.setMemberRoleName(BusinessTeamRoleEnum.OPERATION.getDesc());
                businessTeamMemberPayload.setObjectId(payload.getId());
                businessTeamMemberPayload.setType(BusinessTeamTypeEnum.PARTNER.getCode());
                businessTeamMemberPayload.setSortNo(BusinessTeamRoleEnum.OPERATION.getSortNo());
                businessTeamMemberPayload.setOrgId(orgId);
                payloadList.add(businessTeamMemberPayload);
            }
        }
        if (!CollectionUtils.isEmpty(payloadList)) {
            businessTeamMemberService.saveAll(payloadList);
        }
    }

    @Transactional
    public void activeCustomerWithWorkFlow(Long partnerId, String partnerName, Long bookId) {
        BusinessCustomerInfoVO businessCustomerInfoVO = this.queryByPartnerId(partnerId);
        ProcessInfo processInfo = new ProcessInfo();
        if (null != bookId) {
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(bookId);
            Long count1 = this.bookInvoiceService.count(bookInvoiceQuery);
            if (count1 == 0L) {
                throw new BusinessException("\u6fc0\u6d3b\u524d\u8bf7\u5148\u7ef4\u62a4\u5f00\u7968\u4fe1\u606f");
            }
        }
        String customerStatus = BusinessPartnerStatusEnum.ACTIVE.getCode();
        if (this.workflow_enabled.booleanValue()) {
            HashMap variables = this.dealActiveWorkFlowVariables(businessCustomerInfoVO);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.CUSTOMER_ACTIVE.name(), (String)(partnerName + "-\u5ba2\u6237\u6fc0\u6d3b\u6d41\u7a0b"), (String)("" + businessCustomerInfoVO.getId()), (HashMap)variables), new Long[0]);
            customerStatus = BusinessPartnerStatusEnum.APPROVING.getCode();
        }
        BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(businessCustomerInfoVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setCustomerStatus(customerStatus);
        this.transactionUtilService.executeWithRunnable(() -> this.businessCustomerInfoDAO.updateByKeyDynamic(payload));
    }

    @Transactional
    public void activeCustomer(Long partnerId, String partnerName, Long bookId) {
        BusinessCustomerInfoVO businessCustomerInfoVO = this.queryByPartnerId(partnerId);
        if (null != bookId) {
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(bookId);
            Long count1 = this.bookInvoiceService.count(bookInvoiceQuery);
            if (count1 == 0L) {
                throw new BusinessException("\u6fc0\u6d3b\u524d\u8bf7\u5148\u7ef4\u62a4\u5f00\u7968\u4fe1\u606f");
            }
        }
        String customerStatus = BusinessPartnerStatusEnum.ACTIVE.getCode();
        BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
        payload.setId(businessCustomerInfoVO.getId());
        payload.setCustomerStatus(customerStatus);
        this.businessCustomerInfoDAO.updateByKeyDynamic(payload);
    }

    @Transactional
    public void pendingCustomer(Long partnerId, String partnerName) {
        BusinessCustomerInfoVO businessCustomerInfoVO = this.queryByPartnerId(partnerId);
        ProcessInfo processInfo = new ProcessInfo();
        if (this.workflow_enabled.booleanValue()) {
            HashMap variables = this.dealActiveWorkFlowVariables(businessCustomerInfoVO);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.CUSTOMER_PENDING.name(), (String)(partnerName + "-\u5ba2\u6237\u6682\u6302\u6d41\u7a0b"), (String)("" + businessCustomerInfoVO.getId()), (HashMap)variables), new Long[0]);
        }
        BusinessCustomerInfoPayload payload = new BusinessCustomerInfoPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(businessCustomerInfoVO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.businessCustomerInfoDAO.updateByKeyDynamic(payload));
    }

    public void updateBusinessParnerCustomerModifyTime(Long partnerId) {
        this.businessCustomerInfoDAO.updateBusinessParnerCustomerModifyTime(partnerId);
    }

    public Boolean activeCustomerCheck(Long bookId) {
        Assert.notNull((Object)bookId, (String)"bookid\u4e0d\u80fd\u4e3a\u7a7a");
        if (null != bookId) {
            BookInvoiceQuery bookInvoiceQuery = new BookInvoiceQuery();
            bookInvoiceQuery.setBookId(bookId);
            Long count1 = this.bookInvoiceService.count(bookInvoiceQuery);
            if (count1 > 0L) {
                return true;
            }
        }
        return false;
    }

    public Integer checkoutJdeResult(String result, String partnerName) {
        JSONObject jsonObject = JSONUtil.parseObj((String)result);
        String jdeStatus = jsonObject.getStr((Object)"jde__status");
        if (!"SUCCESS".equals(jdeStatus)) {
            throw TwException.error("", partnerName + "\u540c\u6b65jde\u5931\u8d25");
        }
        Integer customerNo = -1;
        if (jsonObject.containsKey((Object)"Address Number")) {
            customerNo = jsonObject.getInt((Object)"Address Number");
        } else if (jsonObject.containsKey((Object)"Previously Assigned Number")) {
            customerNo = jsonObject.getInt((Object)"Previously Assigned Number");
        }
        if (customerNo == -1) {
            throw TwException.error("", partnerName + "\u540c\u6b65jde\u5931\u8d25");
        }
        return customerNo;
    }

    public void translate(BusinessCustomerInfoVO vo) {
        String custOperStatus;
        CrmCustomerOperationService crmCustomerOperationService = (CrmCustomerOperationService)SpringUtil.getBean(CrmCustomerOperationService.class);
        CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
        crmCustomerOperationQuery.setCustomerId(vo.getPartnerId());
        List crmCustomerOperationVOS = crmCustomerOperationService.queryList(crmCustomerOperationQuery);
        if (!CollectionUtils.isEmpty((Collection)crmCustomerOperationVOS) && StringUtils.hasText((String)(custOperStatus = ((CrmCustomerOperationVO)crmCustomerOperationVOS.get(0)).getCustOperStatus()))) {
            String custOperStatusDesc = this.cacheUtil.transferSystemSelection("CRM:BUSINESS_PARTNER:OPER_STATUS", custOperStatus);
            vo.setCustOperStatusName(custOperStatusDesc);
        }
    }

    public void customerManageTranslate(BusinessCutomerManageVO vo, Map<Long, List<BusinessTeamMemberVO>> teamMemberMap) {
        Map<String, List<BusinessTeamMemberVO>> memberRoleMap;
        List<BusinessTeamMemberVO> businessTeamMemberVOS;
        if (teamMemberMap.containsKey(vo.getId()) && !CollectionUtils.isEmpty(businessTeamMemberVOS = teamMemberMap.get(vo.getId())) && !CollectionUtils.isEmpty(memberRoleMap = businessTeamMemberVOS.stream().filter(p -> p.getMemberRole() != null).collect(Collectors.groupingBy(BusinessTeamMemberVO::getMemberRole)))) {
            if (memberRoleMap.containsKey(BusinessTeamRoleEnum.SALE_MANAGER.getCode())) {
                vo.setBusinessUserId(memberRoleMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getUserId());
                vo.setBusinessUserName(memberRoleMap.get(BusinessTeamRoleEnum.SALE_MANAGER.getCode()).get(0).getMemberName());
            }
            if (memberRoleMap.containsKey(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode())) {
                vo.setServiceUserId(memberRoleMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getUserId());
                vo.setServiceUserName(memberRoleMap.get(BusinessTeamRoleEnum.SERVICE_MANAGER.getCode()).get(0).getMemberName());
            }
            if (memberRoleMap.containsKey(BusinessTeamRoleEnum.CARE.getCode())) {
                vo.setCareUserId(memberRoleMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getUserId());
                vo.setCareUserName(memberRoleMap.get(BusinessTeamRoleEnum.CARE.getCode()).get(0).getMemberName());
            }
            if (memberRoleMap.containsKey(BusinessTeamRoleEnum.OPERATION.getCode())) {
                vo.setOperationUserId(memberRoleMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getUserId());
                vo.setOperationUserName(memberRoleMap.get(BusinessTeamRoleEnum.OPERATION.getCode()).get(0).getMemberName());
            }
        }
        StringBuilder str = new StringBuilder();
        if (vo.getProvinceName() != null) {
            str.append(vo.getProvinceName() + "/");
        }
        if (vo.getCityName() != null) {
            str.append(vo.getCityName() + "/");
        }
        if (vo.getDistrictName() != null) {
            str.append(vo.getDistrictName());
        }
        vo.setAddress(str.toString());
        if (vo.getCreateUserId() != null) {
            vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        }
    }

    public HashMap dealActiveWorkFlowVariables(BusinessCustomerInfoVO businessCustomerInfoVO) {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        PrdOrgRoleVO marketManage = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_CUSTOMER.getCode());
        if (ObjectUtils.isEmpty((Object)marketManage)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_CUSTOMER.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitMarketManage = marketManage.getRoleEmployees().split(",");
        variables.put("Activity_1pdc1dy", Arrays.asList(splitMarketManage));
        PrdOrgRoleVO arAccount = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getCode());
        if (ObjectUtils.isEmpty((Object)arAccount)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitByArAccount = arAccount.getRoleEmployees().split(",");
        variables.put("Activity_00bffll", Arrays.asList(splitByArAccount));
        return variables;
    }

    public HashMap dealPendingWorkFlowVariables(BusinessCustomerInfoVO businessCustomerInfoVO) {
        HashMap<String, List<String>> variables = new HashMap<String, List<String>>();
        PrdOrgRoleVO marketManage = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_PERSON.getCode());
        if (ObjectUtils.isEmpty((Object)marketManage)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.MARKET_RESPONSIBLE_PERSON.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitMarketManage = marketManage.getRoleEmployees().split(",");
        variables.put("Activity_0agynoy", Arrays.asList(splitMarketManage));
        PrdOrgRoleVO arAccount = this.daoOrg.queryRoleByOrgIdAndRoleCode(this.workflow_orgId, WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getCode());
        if (ObjectUtils.isEmpty((Object)arAccount)) {
            throw TwException.error("", WorkFlowRoleCodeEnum.AR_ACCOUNTANT.getDesc() + "\u4e0d\u5b58\u5728\uff01");
        }
        String[] splitByArAccount = arAccount.getRoleEmployees().split(",");
        variables.put("Activity_1onqlrv", Arrays.asList(splitByArAccount));
        return variables;
    }

    public void dataPermission(BusinessCustomerInfoQuery query) {
        Long userId = query.getQueryUserId() == null ? GlobalUtil.getLoginUserId() : query.getQueryUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.SALE_ADMIN.getCode(), RoleEnum.MARKET_ADMIN.getCode(), RoleEnum.FINANCE_MEMBER.getCode(), RoleEnum.CUST_MANAGER.getCode(), RoleEnum.POTENTIAL_CUST_CONFIRM.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_ALL_PIC.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            query.setLoginUserId(userId);
        }
    }

    public BusinessCustomerInfoServiceImpl(BusinessCustomerInfoRepo businessCustomerInfoRepo, BusinessCustomerInfoDAO businessCustomerInfoDAO, ChangeFieldLogUtil changeFieldLogUtil, PrdSystemLogService logService, CrmLeadsDAO leadsDAO, CrmPotentialCustomerDAO potentialCustomerDAO, CacheUtil cacheUtil, WorkflowUtil workflowUtil, PrdOrgOrganizationDAO daoOrg, TransactionUtilService transactionUtilService, HttpUtil httpUtil, ApiRequestLogService apiRequestLogService, BookInvoiceService bookInvoiceService, BusinessSupplierInfoService businessSupplierInfoService, BookContactsService bookContactsService) {
        this.businessCustomerInfoRepo = businessCustomerInfoRepo;
        this.businessCustomerInfoDAO = businessCustomerInfoDAO;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.logService = logService;
        this.leadsDAO = leadsDAO;
        this.potentialCustomerDAO = potentialCustomerDAO;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.daoOrg = daoOrg;
        this.transactionUtilService = transactionUtilService;
        this.httpUtil = httpUtil;
        this.apiRequestLogService = apiRequestLogService;
        this.bookInvoiceService = bookInvoiceService;
        this.businessSupplierInfoService = businessSupplierInfoService;
        this.bookContactsService = bookContactsService;
    }
}

