/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pay.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pay.payload.TDocHistPayload;
import com.elitesland.tw.tw5.api.prd.pay.query.TDocHistQuery;
import com.elitesland.tw.tw5.api.prd.pay.service.TDocHistService;
import com.elitesland.tw.tw5.api.prd.pay.vo.TDocHistVO;
import com.elitesland.tw.tw5.server.prd.pay.convert.TDocHistConvert;
import com.elitesland.tw.tw5.server.prd.pay.dao.TDocHistDAO;
import com.elitesland.tw.tw5.server.prd.pay.entity.TDocHistDO;
import com.elitesland.tw.tw5.server.prd.pay.repo.TDocHistRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TDocHistServiceImpl
extends BaseServiceImpl
implements TDocHistService {
    private static final Logger log = LoggerFactory.getLogger(TDocHistServiceImpl.class);
    private final TDocHistRepo tDocHistRepo;
    private final TDocHistDAO tDocHistDAO;

    public PagingVO<TDocHistVO> queryPaging(TDocHistQuery query) {
        return this.tDocHistDAO.queryPaging(query);
    }

    public List<TDocHistVO> queryListDynamic(TDocHistQuery query) {
        return this.tDocHistDAO.queryListDynamic(query);
    }

    public TDocHistVO queryByKey(Long key) {
        TDocHistDO entity = this.tDocHistRepo.findById(key).orElseGet(TDocHistDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TDocHistVO vo = TDocHistConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TDocHistVO insert(TDocHistPayload payload) {
        TDocHistDO entityDo = TDocHistConvert.INSTANCE.toDo(payload);
        return TDocHistConvert.INSTANCE.toVo((TDocHistDO)this.tDocHistRepo.save(entityDo));
    }

    public void batchInsert(List<TDocHistPayload> payloads) {
        List<TDocHistDO> dos = TDocHistConvert.INSTANCE.payloads2Dos(payloads);
        this.tDocHistDAO.saveAll(dos);
    }

    @Transactional(rollbackFor={Exception.class})
    public TDocHistVO update(TDocHistPayload payload) {
        TDocHistDO entity = this.tDocHistRepo.findById(payload.getId()).orElseGet(TDocHistDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TDocHistDO entityDo = TDocHistConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TDocHistConvert.INSTANCE.toVo((TDocHistDO)this.tDocHistRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TDocHistPayload payload) {
        TDocHistDO entity = this.tDocHistRepo.findById(payload.getId()).orElseGet(TDocHistDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tDocHistDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tDocHistDAO.deleteSoft(keys);
        }
    }

    public TDocHistServiceImpl(TDocHistRepo tDocHistRepo, TDocHistDAO tDocHistDAO) {
        this.tDocHistRepo = tDocHistRepo;
        this.tDocHistDAO = tDocHistDAO;
    }
}

