/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsProjectRoleAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleAssignmentService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleAssignmentVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PmsProjectRoleAssignmentDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PmsProjectRoleAssignmentDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PmsProjectRoleAssignmentRepo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsProjectRoleAssignmentServiceImpl
extends BaseServiceImpl
implements PmsProjectRoleAssignmentService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectRoleAssignmentServiceImpl.class);
    private final PmsProjectRoleAssignmentRepo pmsProjectRoleAssignmentRepo;
    private final PmsProjectRoleAssignmentDAO pmsProjectRoleAssignmentDAO;

    public PagingVO<PmsProjectRoleAssignmentVO> queryPaging(PmsProjectRoleAssignmentQuery query) {
        return this.pmsProjectRoleAssignmentDAO.queryPaging(query);
    }

    public List<PmsProjectRoleAssignmentVO> queryListDynamic(PmsProjectRoleAssignmentQuery query) {
        return this.pmsProjectRoleAssignmentDAO.queryListDynamic(query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(PmsProjectRoleAssignmentPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getProjectId())) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getUserId())) {
            throw TwException.error("", "\u7528\u6237\u8d44\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List projectRoleIds = payload.getProjectRoleIds();
        if (ObjectUtils.isEmpty((Object)projectRoleIds)) {
            this.pmsProjectRoleAssignmentDAO.deleteByProjectAndUser(payload.getProjectId(), payload.getUserId());
        } else {
            HashSet difference = new HashSet(projectRoleIds);
            List<PmsProjectRoleAssignmentVO> fromDB = this.pmsProjectRoleAssignmentDAO.queryByProjectAndUser(payload.getProjectId(), payload.getUserId());
            List<Long> delIds = fromDB.stream().filter(vo -> !projectRoleIds.contains(vo.getProjectRoleId())).map(vo -> vo.getId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(delIds)) {
                this.pmsProjectRoleAssignmentDAO.deleteSoft(delIds);
            }
            List projectRoleIdsFromDB = fromDB.stream().map(vo -> vo.getProjectRoleId()).collect(Collectors.toList());
            difference.removeAll(projectRoleIdsFromDB);
            ArrayList<PmsProjectRoleAssignmentDO> list = new ArrayList<PmsProjectRoleAssignmentDO>();
            for (Long projectRoleId : difference) {
                PmsProjectRoleAssignmentDO entityDo = new PmsProjectRoleAssignmentDO();
                entityDo.setProjectRoleId(projectRoleId);
                entityDo.setProjectId(payload.getProjectId());
                entityDo.setUserId(payload.getUserId());
                list.add(entityDo);
            }
            if (!ObjectUtils.isEmpty(list)) {
                this.pmsProjectRoleAssignmentRepo.saveAll(list);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void insert(Long projectId, Long userId, List<Long> projectRoleIds) {
        if (ObjectUtils.isEmpty((Object)projectId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw TwException.error("", "\u7528\u6237\u8d44\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        HashSet<Long> difference = new HashSet<Long>(projectRoleIds);
        List<PmsProjectRoleAssignmentVO> fromDB = this.pmsProjectRoleAssignmentDAO.queryByProjectAndUser(projectId, userId);
        List projectRoleIdsFromDB = fromDB.stream().map(vo -> vo.getProjectRoleId()).collect(Collectors.toList());
        difference.removeAll(projectRoleIdsFromDB);
        ArrayList<PmsProjectRoleAssignmentDO> list = new ArrayList<PmsProjectRoleAssignmentDO>();
        for (Long projectRoleId : difference) {
            PmsProjectRoleAssignmentDO entityDo = new PmsProjectRoleAssignmentDO();
            entityDo.setProjectRoleId(projectRoleId);
            entityDo.setProjectId(projectId);
            entityDo.setUserId(userId);
            list.add(entityDo);
        }
        if (!ObjectUtils.isEmpty(list)) {
            this.pmsProjectRoleAssignmentRepo.saveAll(list);
        }
    }

    public PmsProjectRoleAssignmentServiceImpl(PmsProjectRoleAssignmentRepo pmsProjectRoleAssignmentRepo, PmsProjectRoleAssignmentDAO pmsProjectRoleAssignmentDAO) {
        this.pmsProjectRoleAssignmentRepo = pmsProjectRoleAssignmentRepo;
        this.pmsProjectRoleAssignmentDAO = pmsProjectRoleAssignmentDAO;
    }
}

