/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PmsRelatedHistoryPayload;
import com.elitesland.tw.tw5.api.prd.personplan.payload.ProRelatedPartiesPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanDtlQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.PmsProjectRoleQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.query.ResourceCostStrategyQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanDtlService;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.CheckoutProRelatedRemoveVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlAndProjectVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ResourceCostStrategyVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.personplan.convert.ProRelatedPartiesConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.ProRelatedPartiesDao;
import com.elitesland.tw.tw5.server.prd.personplan.entity.ProRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.ProRelatedPartiesRepo;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.PmsRelatedHistoryService;
import com.elitesland.tw.tw5.server.prd.personplan.service.inter.ResourceCostStrategyService;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ProRelatedPartiesServiceImpl
implements ProRelatedPartiesService {
    private static final Logger log = LoggerFactory.getLogger(ProRelatedPartiesServiceImpl.class);
    private final ProRelatedPartiesDao proRelatedPartiesDao;
    private final ProRelatedPartiesRepo proRelatedPartiesRepo;
    private final PmsProjectRoleService pmsProjectRoleService;
    private final PmsRelatedHistoryService pmsRelatedHistoryService;
    private final CacheUtil cacheUtil;
    private final PmsProjectDAO pmsProjectDAO;
    private final ResourceCostStrategyService resourceCostStrategyService;
    private final PersonPlanDtlService personPlanDtlService;

    @Transactional(rollbackFor={Exception.class})
    public ProRelatedPartiesVO save(ProRelatedPartiesPayload proRelatedPartiesPayload) {
        this.checkData(proRelatedPartiesPayload);
        if (proRelatedPartiesPayload.getType().equals(0)) {
            proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setProId(proRelatedPartiesPayload.getProId());
            proRelatedPartiesQuery.setUserId(proRelatedPartiesPayload.getUserId());
            count = this.proRelatedPartiesDao.count(proRelatedPartiesQuery);
            if (count > 0L) {
                throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u76f8\u5173\u65b9");
            }
        } else if (proRelatedPartiesPayload.getType().equals(1)) {
            proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setProId(proRelatedPartiesPayload.getProId());
            proRelatedPartiesQuery.setExternalId(proRelatedPartiesPayload.getExternalId());
            count = this.proRelatedPartiesDao.count(proRelatedPartiesQuery);
            if (count > 0L) {
                throw new BusinessException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u76f8\u5173\u65b9");
            }
        }
        ProRelatedPartiesDO proRelatedPartiesDO = new ProRelatedPartiesDO();
        proRelatedPartiesDO = ProRelatedPartiesConvert.INSTANCE.p2d(proRelatedPartiesPayload);
        ProRelatedPartiesDO res = (ProRelatedPartiesDO)((Object)this.proRelatedPartiesRepo.save((Object)proRelatedPartiesDO));
        PmsRelatedHistoryPayload payload = new PmsRelatedHistoryPayload();
        payload.setRelateId(res.getId());
        payload.setExt1(res.getExt1());
        payload.setExt2(res.getExt2());
        payload.setExt3(res.getExt3());
        payload.setExt4(res.getExt4());
        payload.setSourceType(Integer.valueOf(2));
        this.pmsRelatedHistoryService.insert(payload);
        return ProRelatedPartiesConvert.INSTANCE.d2v(res);
    }

    @Transactional(rollbackFor={Exception.class})
    public ProRelatedPartiesVO updateAll(ProRelatedPartiesPayload proRelatedPartiesPayload) {
        Assert.notNull((Object)proRelatedPartiesPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        ProRelatedPartiesVO res = this.save(proRelatedPartiesPayload);
        return res;
    }

    public ProRelatedPartiesVO get(Long id) {
        if (null == id) {
            return null;
        }
        ProRelatedPartiesVO res = this.proRelatedPartiesDao.get(id);
        if (null != res) {
            this.translate(Collections.singletonList(res));
        }
        return res;
    }

    public ProRelatedPartiesVO getSimple(Long id) {
        if (null == id) {
            return null;
        }
        ProRelatedPartiesVO res = this.proRelatedPartiesDao.get(id);
        return res;
    }

    public PagingVO<ProRelatedPartiesVO> page(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        PagingVO<ProRelatedPartiesVO> res = this.proRelatedPartiesDao.page(proRelatedPartiesQuery);
        if (!CollectionUtils.isEmpty((Collection)res.getRecords())) {
            this.translate(res.getRecords());
        }
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Boolean exist = false;
        if (exist.booleanValue()) {
            throw new BusinessException("\u5b58\u5728\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1,\u8bf7\u79fb\u4ea4\u5904\u7406\u540e\u518d\u8fdb\u884c\u5220\u9664");
        }
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.proRelatedPartiesDao.del(ids);
        return res;
    }

    public CheckoutProRelatedRemoveVO checkoutRemoveRelated(List<Long> ids) {
        CheckoutProRelatedRemoveVO checkoutProRelatedRemoveVO = new CheckoutProRelatedRemoveVO();
        checkoutProRelatedRemoveVO.setRemoveflag(Boolean.valueOf(false));
        List proRelatedPartiesDOS = this.proRelatedPartiesDao.get(ids);
        if (!CollectionUtils.isEmpty((Collection)proRelatedPartiesDOS)) {
            List userIdList = proRelatedPartiesDOS.stream().map(p -> p.getUserId()).collect(Collectors.toList());
            Long proId = ((ProRelatedPartiesDO)((Object)proRelatedPartiesDOS.get(0))).getProId();
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setProId(proId);
            List<ProRelatedPartiesVO> list = this.getList(proRelatedPartiesQuery);
        }
        return checkoutProRelatedRemoveVO;
    }

    public List<ProRelatedPartiesVO> getList(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        List<ProRelatedPartiesVO> res = this.proRelatedPartiesDao.getList(proRelatedPartiesQuery);
        if (!CollectionUtils.isEmpty(res)) {
            this.translate(res);
        }
        return res;
    }

    public List<ProRelatedPartiesVO> getListSimple(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        List<ProRelatedPartiesVO> res = this.proRelatedPartiesDao.getList(proRelatedPartiesQuery);
        return res;
    }

    public ProRelatedPartiesVO getListSimpleByProjectIdAndUserId(Long reasonId, Long loginUserId) {
        ProRelatedPartiesQuery relatedPartiesQuery = new ProRelatedPartiesQuery();
        relatedPartiesQuery.setProId(reasonId);
        relatedPartiesQuery.setUserId(loginUserId);
        List<ProRelatedPartiesVO> listSimple = this.getListSimple(relatedPartiesQuery);
        if (!CollectionUtils.isEmpty(listSimple)) {
            return listSimple.get(0);
        }
        return null;
    }

    private void checkData(ProRelatedPartiesPayload proRelatedPartiesPayload) {
        Assert.notNull((Object)proRelatedPartiesPayload.getType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)proRelatedPartiesPayload.getRelatedType(), (String)"\u76f8\u5173\u65b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)proRelatedPartiesPayload.getProId(), (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (proRelatedPartiesPayload.getType().equals(0)) {
            Assert.notNull((Object)proRelatedPartiesPayload.getUserId(), (String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        } else if (proRelatedPartiesPayload.getType().equals(1)) {
            Assert.notNull((Object)proRelatedPartiesPayload.getExternalId(), (String)"\u5916\u90e8\u76f8\u5173\u65b9id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long update(ProRelatedPartiesPayload proRelatedPartiesPayload, Integer sourceType) {
        Assert.notNull((Object)proRelatedPartiesPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.proRelatedPartiesDao.update(proRelatedPartiesPayload);
        ProRelatedPartiesVO proRelatedPartiesVO = this.get(proRelatedPartiesPayload.getId());
        if (null == proRelatedPartiesVO) {
            return 0L;
        }
        PmsRelatedHistoryPayload payload = new PmsRelatedHistoryPayload();
        payload.setRelateId(proRelatedPartiesVO.getId());
        payload.setExt1(proRelatedPartiesVO.getExt1());
        payload.setExt2(proRelatedPartiesVO.getExt2());
        payload.setExt3(proRelatedPartiesVO.getExt3());
        payload.setExt4(proRelatedPartiesVO.getExt4());
        if (null == sourceType) {
            sourceType = 3;
        }
        payload.setSourceType(sourceType);
        this.pmsRelatedHistoryService.insert(payload);
        return res;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ProRelatedPartiesVO> iportForm(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        List<ProRelatedPartiesVO> res = this.proRelatedPartiesDao.getList(proRelatedPartiesQuery);
        if (!CollectionUtils.isEmpty(res)) {
            ArrayList proRoleList = new ArrayList();
            List userIdList = res.stream().map(p -> p.getUserId()).collect(Collectors.toList());
            ArrayList list = new ArrayList();
            if (!CollectionUtil.isEmpty(userIdList)) {
                ProRelatedPartiesQuery tempQuery = new ProRelatedPartiesQuery();
                tempQuery.setUserIdList(userIdList);
                List<ProRelatedPartiesVO> tempPartiesList = this.proRelatedPartiesDao.getList(tempQuery);
                Map<Long, Long> map = tempPartiesList.stream().collect(Collectors.toMap(BaseViewModel::getId, ProRelatedPartiesVO::getUserId));
                List idList = tempPartiesList.stream().map(p -> p.getId()).collect(Collectors.toList());
                PersonPlanDtlQuery personPlanDtlQuery = new PersonPlanDtlQuery();
                personPlanDtlQuery.setRelatePartiesIdList(idList);
                List personPlanDtlAndProjectVOS = this.personPlanDtlService.queryByRelatePartiesId(personPlanDtlQuery);
                LocalDate startDate = proRelatedPartiesQuery.getStartDate();
                LocalDate endDate = proRelatedPartiesQuery.getEndDate();
                if (!CollectionUtil.isEmpty((Collection)personPlanDtlAndProjectVOS)) {
                    personPlanDtlAndProjectVOS.stream().forEach(p -> {
                        if (p.getProId().equals(proRelatedPartiesQuery.getProId())) {
                            return;
                        }
                        boolean overlapping = this.isOverlapping(p.getStartDate(), p.getEndDate(), startDate, endDate);
                        if (overlapping) {
                            p.setUserId((Long)map.get(p.getRelatePartiesId()));
                            list.add(p);
                        }
                    });
                }
            }
            Map<Long, List<PersonPlanDtlAndProjectVO>> listMap = list.stream().collect(Collectors.groupingBy(o -> o.getUserId()));
            PmsProjectRoleQuery pmsProjectRoleQuery = new PmsProjectRoleQuery();
            pmsProjectRoleQuery.setIds(proRoleList);
            List pmsProjectRoleVOS = this.pmsProjectRoleService.queryListDynamic(pmsProjectRoleQuery);
            HashMap pmsProjectRoleVOMap = new HashMap();
            pmsProjectRoleVOS.stream().forEach(p -> pmsProjectRoleVOMap.put(p.getId(), p));
            TwOutputUtil<List<ResourceCostStrategyVO>> listTwOutputUtil = this.resourceCostStrategyService.queryList(new ResourceCostStrategyQuery());
            List<ResourceCostStrategyVO> resourceCostStrategyVOList = listTwOutputUtil.getData();
            ResourceCostStrategyVO resourceCostStrategyVO = new ResourceCostStrategyVO();
            resourceCostStrategyVO.setType(Integer.valueOf(1));
            if (CollUtil.isNotEmpty(resourceCostStrategyVOList)) {
                resourceCostStrategyVO = resourceCostStrategyVOList.get(0);
            }
            for (ProRelatedPartiesVO re : res) {
                if (StringUtils.hasText((String)re.getProRole())) {
                    List collect = Arrays.stream(re.getProRole().split(",")).collect(Collectors.toList());
                    ArrayList<PmsProjectRoleVO> pmsProjectRoleVOS1 = new ArrayList<PmsProjectRoleVO>();
                    for (String string : collect) {
                        PmsProjectRoleVO pmsProjectRoleVO = (PmsProjectRoleVO)pmsProjectRoleVOMap.get(Long.valueOf(string));
                        pmsProjectRoleVOS1.add(pmsProjectRoleVO);
                    }
                    re.setProjectRoleVOList(pmsProjectRoleVOS1);
                }
                if (resourceCostStrategyVO.getType() == 1) {
                    re.setReferenceEqvaRatio(BigDecimal.ONE);
                }
                if (CollectionUtil.isEmpty(listMap) || !listMap.containsKey(re.getUserId())) continue;
                List<PersonPlanDtlAndProjectVO> personPlanDtlAndProjectVOS1 = listMap.get(re.getUserId());
                re.setPersonPlanDtlAndProjectVOList(personPlanDtlAndProjectVOS1);
            }
        }
        return res;
    }

    private boolean isOverlapping(LocalDate date1, LocalDate date2, LocalDate startDate, LocalDate endDate) {
        if (date1.isAfter(date2) || startDate.isAfter(endDate)) {
            return false;
        }
        return !date1.isAfter(endDate) && !date2.isBefore(startDate);
    }

    public Long count(ProRelatedPartiesQuery proRelatedPartiesQuery) {
        Long count = this.proRelatedPartiesDao.count(proRelatedPartiesQuery);
        return count;
    }

    public void translate(List<ProRelatedPartiesVO> proRelatedPartiesVOList) {
        ArrayList proRoleList = new ArrayList();
        HashMap pmsProjectRoleVOMap = new HashMap();
        proRelatedPartiesVOList.stream().forEach(p -> {
            if (null != p.getUserId()) {
                String userName = this.cacheUtil.getUserName(p.getUserId());
                p.setUserName(userName);
            }
            if (StringUtils.hasText((String)p.getProRole())) {
                Arrays.stream(p.getProRole().split(",")).map(s -> proRoleList.add(Long.valueOf(s)));
            }
        });
        PmsProjectRoleQuery pmsProjectRoleQuery = new PmsProjectRoleQuery();
        pmsProjectRoleQuery.setIds(proRoleList);
        List pmsProjectRoleVOS = this.pmsProjectRoleService.queryListDynamic(pmsProjectRoleQuery);
        pmsProjectRoleVOS.stream().forEach(p -> pmsProjectRoleVOMap.put(p.getId(), p.getRoleName()));
        proRelatedPartiesVOList.stream().forEach(p -> {
            if (StringUtils.hasText((String)p.getProRole())) {
                String proRoleName = Arrays.stream(p.getProRole().split(",")).map(s -> (String)pmsProjectRoleVOMap.get(Long.valueOf(s))).collect(Collectors.joining(","));
                p.setProRoleName(proRoleName);
            }
        });
    }

    public PagingVO<ProRelatedPartiesVO> relatePaging(ProRelatedPartiesQuery query) {
        Assert.notNull((Object)query.getRelateId(), (String)"\u76f8\u5173\u65b9id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProRelatedPartiesVO proRelatedPartiesVO = this.proRelatedPartiesDao.get(query.getRelateId());
        if (0 == proRelatedPartiesVO.getType()) {
            query.setUserId(proRelatedPartiesVO.getUserId());
        } else if (1 == proRelatedPartiesVO.getType()) {
            query.setExternalId(proRelatedPartiesVO.getExternalId());
        }
        PagingVO<ProRelatedPartiesVO> page = this.proRelatedPartiesDao.page(query);
        List proIds = page.getRecords().stream().map(x -> x.getProId()).collect(Collectors.toList());
        PmsProjectQuery pmsProjectQuery = new PmsProjectQuery();
        pmsProjectQuery.setIdList(proIds);
        List<PmsProjectVO> pmsProjectVOS = this.pmsProjectDAO.queryListDynamic(pmsProjectQuery);
        Map pmsProjectVOMap = pmsProjectVOS.stream().collect(Collectors.toMap(PmsProjectVO::getId, Function.identity(), (t1, t2) -> t1));
        page.getRecords().forEach(x -> {
            PmsProjectVO pmsProjectVO = (PmsProjectVO)pmsProjectVOMap.get(x.getProId());
            if (null != pmsProjectVO) {
                x.setProName(pmsProjectVO.getProjName());
                x.setProExt1(pmsProjectVO.getExt1());
                x.setPlanStartDate(x.getCreateTime());
                x.setPlanEndDate(pmsProjectVO.getPlanEndDate());
                x.setProExt1Desc(this.cacheUtil.transferSystemSelection("PMS:PROJECT:OTHER", x.getProExt1()));
            }
        });
        this.translate(page.getRecords());
        return page;
    }

    void transferData(PmsProjectVO vo) {
    }

    public ProRelatedPartiesServiceImpl(ProRelatedPartiesDao proRelatedPartiesDao, ProRelatedPartiesRepo proRelatedPartiesRepo, PmsProjectRoleService pmsProjectRoleService, PmsRelatedHistoryService pmsRelatedHistoryService, CacheUtil cacheUtil, PmsProjectDAO pmsProjectDAO, ResourceCostStrategyService resourceCostStrategyService, PersonPlanDtlService personPlanDtlService) {
        this.proRelatedPartiesDao = proRelatedPartiesDao;
        this.proRelatedPartiesRepo = proRelatedPartiesRepo;
        this.pmsProjectRoleService = pmsProjectRoleService;
        this.pmsRelatedHistoryService = pmsRelatedHistoryService;
        this.cacheUtil = cacheUtil;
        this.pmsProjectDAO = pmsProjectDAO;
        this.resourceCostStrategyService = resourceCostStrategyService;
        this.personPlanDtlService = personPlanDtlService;
    }
}

