/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetDetailsPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetReleasePayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetDetailsQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetReleaseQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetDetailsService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetReleaseService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetReleaseVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsResourceQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActListService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsResourceService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsWbsVersionService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsListVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsWbsVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.budget.constants.BudgetVersionStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.budget.convert.PmsWbsBudgetDetailsConvert;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetDetailsDao;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectWbsTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PmsWbsBudgetDetailsServiceImpl
implements PmsWbsBudgetDetailsService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsBudgetDetailsServiceImpl.class);
    private final PmsWbsBudgetDetailsDao dao;
    private final PmsWbsBudgetVersionService pmsWbsBudgetVersionService;
    @Resource
    @Lazy
    private PmsWbsBudgetService pmsWbsBudgetService;
    private final PmsWbsVersionService pmsWbsVersionService;
    private final PmsProjectActListService pmsProjectActListService;
    private final PmsProjectWbsResourceService pmsProjectWbsResourceService;
    private final PmsProjectRoleService pmsProjectRoleService;
    private final PmsWbsBudgetReleaseService pmsWbsBudgetReleaseService;

    public PagingVO<PmsWbsBudgetDetailsVO> queryPage(PmsWbsBudgetDetailsQuery query) {
        PagingVO<PmsWbsBudgetDetailsVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return pageVO;
    }

    public List<PmsWbsBudgetDetailsVO> queryList(PmsWbsBudgetDetailsQuery query) {
        List<PmsWbsBudgetDetailsVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return listVO;
    }

    public long queryCount(PmsWbsBudgetDetailsQuery query) {
        return this.dao.queryCount(query);
    }

    public PmsWbsBudgetDetailsVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetDetailsVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return vo;
    }

    @Transactional
    public PmsWbsBudgetDetailsVO insert(PmsWbsBudgetDetailsPayload payload) {
        this.checkData(payload);
        PmsWbsBudgetDetailsVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetDetailsVO update(PmsWbsBudgetDetailsPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsWbsBudgetDetailsVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetDetailsVO updateDynamic(PmsWbsBudgetDetailsPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dao.deleteSoft(ids);
    }

    @Transactional
    public PmsWbsBudgetVO init(PmsWbsBudgetDetailsPayload payload) {
        Long proId = payload.getProId();
        Assert.notNull((Object)proId, (String)"proId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long budgetV0Count = this.countByProjectIdAndVersion(proId, 0);
        if (budgetV0Count < 1L) {
            PmsWbsBudgetVO oneBudget = this.createOneBudget(proId);
            return oneBudget;
        }
        PmsWbsBudgetVersionVO version = this.pmsWbsBudgetVersionService.getVersion(proId, BudgetVersionStatusEnum.CREATE.getCode());
        if (version == null) {
            PmsWbsBudgetVersionVO versionActive = this.pmsWbsBudgetVersionService.getVersion(proId, BudgetVersionStatusEnum.ACTIVE.getCode());
            PmsWbsBudgetVersionPayload versionPayload = new PmsWbsBudgetVersionPayload();
            versionPayload.setProId(proId);
            versionPayload.setVersionNo(Integer.valueOf(versionActive.getVersionNo() + 1));
            versionPayload.setStepNum(Integer.valueOf(3));
            versionPayload.setObjectStatus(BudgetVersionStatusEnum.CREATE.getCode());
            version = this.pmsWbsBudgetVersionService.insert(versionPayload);
        }
        PmsWbsBudgetVO budgetVO = this.copyOneAndCreateNext(proId, version);
        return budgetVO;
    }

    private PmsWbsBudgetVO copyOneAndCreateNext(Long proId, PmsWbsBudgetVersionVO wbsBudgetVersion) {
        Assert.notNull((Object)wbsBudgetVersion, (String)"budgetVersionVO\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long budgetVersionVOId = wbsBudgetVersion.getId();
        PmsWbsBudgetQuery pmsWbsBudgetQueryOld = new PmsWbsBudgetQuery();
        pmsWbsBudgetQueryOld.setProId(proId);
        pmsWbsBudgetQueryOld.setVersionId(budgetVersionVOId);
        List budgetVoListOld = this.pmsWbsBudgetService.queryList(pmsWbsBudgetQueryOld);
        if (!CollectionUtils.isEmpty((Collection)budgetVoListOld)) {
            PmsWbsBudgetVO budgetVO = (PmsWbsBudgetVO)budgetVoListOld.get(0);
            PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
            Long budgetVOId = budgetVO.getId();
            detailsQuery.setBudgetId(budgetVOId);
            List<PmsWbsBudgetDetailsVO> pmsWbsBudgetDetailsVOS = this.queryList(detailsQuery);
            List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList = PmsWbsBudgetDetailsConvert.INSTANCE.vtpList(pmsWbsBudgetDetailsVOS);
            PmsWbsVersionVO wbsVersion = this.pmsWbsVersionService.getVersion(proId);
            PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
            Long versionId = wbsVersion.getId();
            pmsProjectWbsQuery.setVersionId(versionId);
            pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
            List wbsList = this.pmsProjectActListService.queryList(pmsProjectWbsQuery);
            if (!CollectionUtils.isEmpty((Collection)wbsList)) {
                List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadListTemp = budgetDetailsPayloadList;
                ArrayList<PmsWbsBudgetDetailsPayload> newDetailPayloadList = new ArrayList<PmsWbsBudgetDetailsPayload>();
                for (PmsProjectWbsListVO wbs2 : wbsList) {
                    Long wbsId = wbs2.getId();
                    this.newWbsDataProcess(proId, wbsBudgetVersion, wbs2, budgetDetailsPayloadListTemp, budgetDetailsPayloadList, wbsId, versionId, budgetVOId, newDetailPayloadList);
                    PmsWbsBudgetDetailsPayload budgetDetailsPayload = budgetDetailsPayloadListTemp.stream().filter(details -> wbs2.getEffRelateId() != null && details.getWbsId().equals(wbs2.getId())).findFirst().orElse(null);
                    if (null == budgetDetailsPayload) continue;
                    budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(budgetDetailsPayload.getWbsId())).forEach(details -> {
                        details.setWbsName(wbs2.getWbsName());
                        details.setWbsCode(wbs2.getWbsCode());
                        details.setWbsStatus(wbs2.getWbsStatus());
                        details.setWbsId(wbsId);
                        PmsWbsBudgetDetailsPayload budgetDetail = this.getPmsWbsBudgetDetailsPayload(proId, wbs2, wbsId, versionId, budgetVOId, wbsBudgetVersion);
                        details.setResCost(budgetDetail.getResCost());
                    });
                }
                if (!CollectionUtils.isEmpty(newDetailPayloadList)) {
                    budgetDetailsPayloadList.addAll(newDetailPayloadList);
                }
            }
            List<PmsWbsBudgetDetailsVO> detailsVOS = this.insertAll(budgetDetailsPayloadList);
            budgetVO.setDetails(detailsVOS);
            PmsWbsBudgetReleaseQuery budgetReleaseQuery = new PmsWbsBudgetReleaseQuery();
            budgetReleaseQuery.setProId(budgetVO.getProId());
            budgetReleaseQuery.setVersionId(budgetVersionVOId);
            List budgetReleaseVOS = this.pmsWbsBudgetReleaseService.queryList(budgetReleaseQuery);
            List wbsCancelList = wbsList.stream().filter(wbs -> wbs.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode()) && (wbs.getReleaseFlag() == null || !wbs.getReleaseFlag().equals(true))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(wbsCancelList) && !CollectionUtils.isEmpty(detailsVOS)) {
                ArrayList releaseList = new ArrayList();
                for (PmsProjectWbsListVO wbs3 : wbsCancelList) {
                    List detailRelaseList;
                    List releasePayloadList;
                    if (!CollectionUtils.isEmpty((Collection)budgetReleaseVOS) && budgetReleaseVOS.stream().anyMatch(budgetReleaseVO -> budgetReleaseVO.getWbsId().equals(wbs3.getId())) || CollectionUtils.isEmpty(releasePayloadList = (detailRelaseList = detailsVOS.stream().filter(details -> details.getWbsId().equals(wbs3.getId())).collect(Collectors.toList())).stream().map(details -> {
                        PmsWbsBudgetReleasePayload releasePayload = new PmsWbsBudgetReleasePayload();
                        releasePayload.setWbsId(wbs3.getId());
                        releasePayload.setProId(proId);
                        releasePayload.setAllocatedResAmtBefore(details.getAllocatedResAmt());
                        releasePayload.setAllocatedResAmtBefore(details.getAllocatedResAmt());
                        releasePayload.setSettledResAmtBefore(details.getSettledResAmt());
                        releasePayload.setOccupiedResAmtBefore(details.getOccupiedResAmt());
                        releasePayload.setRemainingResAmtBefore(details.getRemainingResAmt());
                        releasePayload.setVersionId(budgetVersionVOId);
                        return releasePayload;
                    }).collect(Collectors.toList()))) continue;
                    releaseList.addAll(releasePayloadList);
                }
                List releaseVOS = this.pmsWbsBudgetReleaseService.insertAll(releaseList);
                log.debug("\u9884\u7b97\u91ca\u653e\u8868\uff1abudgetDetailsVO:{}", (Object)releaseVOS);
                budgetVO.setReleases(releaseVOS);
            }
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setProId(proId);
            releaseQuery.setVersionId(budgetVersionVOId);
            long releaseCount = this.pmsWbsBudgetReleaseService.queryCount(releaseQuery);
            budgetVO.setReleasesCount(Long.valueOf(releaseCount));
            return budgetVO;
        }
        PmsWbsBudgetQuery pmsWbsBudgetQuery = new PmsWbsBudgetQuery();
        pmsWbsBudgetQuery.setProId(proId);
        pmsWbsBudgetQuery.setVersionNo(Integer.valueOf(0));
        List budgetVoList = this.pmsWbsBudgetService.queryList(pmsWbsBudgetQuery);
        if (CollectionUtils.isEmpty((Collection)budgetVoList)) {
            throw TwException.error("", "V0\u7248\u672c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (budgetVoList.size() > 1) {
            throw TwException.error("", "V0\u7248\u672c\u6570\u636e\u5f02\u5e38");
        }
        Long budgetVersionId = wbsBudgetVersion.getId();
        Integer budgetVersionNo = wbsBudgetVersion.getVersionNo();
        List newBudgetList = budgetVoList.stream().map(budget -> {
            PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
            BeanUtils.copyProperties((Object)budget, (Object)budgetPayload);
            budgetPayload.setId(null);
            budgetPayload.setEffRelateId(budget.getId());
            budgetPayload.setVersionId(budgetVersionId);
            budgetPayload.setVersionNo(budgetVersionNo);
            return budgetPayload;
        }).collect(Collectors.toList());
        List wbsBudgetVOS = this.pmsWbsBudgetService.insertAll(newBudgetList);
        PmsWbsBudgetVO budgetVO = (PmsWbsBudgetVO)wbsBudgetVOS.get(0);
        Long newBudgetId = budgetVO.getId();
        Long effRelateId = budgetVO.getEffRelateId();
        PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
        detailsQuery.setBudgetId(effRelateId);
        List<PmsWbsBudgetDetailsVO> pmsWbsBudgetDetailsVOS = this.queryList(detailsQuery);
        List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList = pmsWbsBudgetDetailsVOS.stream().map(detailsVO -> {
            PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
            BeanUtils.copyProperties((Object)detailsVO, (Object)detailsPayload);
            detailsPayload.setId(null);
            detailsPayload.setBudgetId(newBudgetId);
            detailsPayload.setEffRelateId(detailsVO.getId());
            detailsPayload.setVersionId(budgetVersionId);
            detailsPayload.setVersionNo(budgetVersionNo);
            return detailsPayload;
        }).collect(Collectors.toList());
        PmsWbsVersionVO wbsVersion = this.pmsWbsVersionService.getVersion(proId);
        PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
        Long versionId = wbsVersion.getId();
        pmsProjectWbsQuery.setVersionId(versionId);
        pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
        List wbsList = this.pmsProjectActListService.queryList(pmsProjectWbsQuery);
        if (!CollectionUtils.isEmpty((Collection)wbsList)) {
            List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadListTemp = budgetDetailsPayloadList;
            ArrayList<PmsWbsBudgetDetailsPayload> newDetailPayloadList = new ArrayList<PmsWbsBudgetDetailsPayload>();
            for (PmsProjectWbsListVO wbs4 : wbsList) {
                Long wbsId = wbs4.getId();
                this.newWbsDataProcess(proId, wbsBudgetVersion, wbs4, budgetDetailsPayloadListTemp, budgetDetailsPayloadList, wbsId, versionId, newBudgetId, newDetailPayloadList);
                PmsWbsBudgetDetailsPayload budgetDetailsPayload = budgetDetailsPayloadListTemp.stream().filter(details -> wbs4.getEffRelateId() != null && details.getWbsId().equals(wbs4.getEffRelateId())).findFirst().orElse(null);
                if (null == budgetDetailsPayload) continue;
                budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(budgetDetailsPayload.getWbsId())).forEach(details -> {
                    details.setWbsName(wbs4.getWbsName());
                    details.setWbsCode(wbs4.getWbsCode());
                    details.setWbsStatus(wbs4.getWbsStatus());
                    details.setWbsId(wbsId);
                    PmsWbsBudgetDetailsPayload budgetDetail = this.getPmsWbsBudgetDetailsPayload(proId, wbs4, wbsId, versionId, newBudgetId, wbsBudgetVersion);
                    details.setResCost(budgetDetail.getResCost());
                });
            }
            if (!CollectionUtils.isEmpty(newDetailPayloadList)) {
                budgetDetailsPayloadList.addAll(newDetailPayloadList);
            }
        }
        List<PmsWbsBudgetDetailsVO> detailsVOS = this.insertAll(budgetDetailsPayloadList);
        budgetVO.setDetails(detailsVOS);
        PmsWbsBudgetReleaseQuery budgetReleaseQuery = new PmsWbsBudgetReleaseQuery();
        budgetReleaseQuery.setProId(budgetVO.getProId());
        budgetReleaseQuery.setVersionId(budgetVersionVOId);
        List budgetReleaseVOS = this.pmsWbsBudgetReleaseService.queryList(budgetReleaseQuery);
        List wbsCancelList = wbsList.stream().filter(wbs -> wbs.getWbsStatus().equals(ProjectWbsStatusEnum.CANCEL.getCode()) && (wbs.getReleaseFlag() == null || !wbs.getReleaseFlag().equals(true))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(wbsCancelList) && !CollectionUtils.isEmpty(detailsVOS)) {
            ArrayList releaseList = new ArrayList();
            for (PmsProjectWbsListVO wbs5 : wbsCancelList) {
                List detailRelaseList;
                List releasePayloadList;
                if (!CollectionUtils.isEmpty((Collection)budgetReleaseVOS) && budgetReleaseVOS.stream().anyMatch(budgetReleaseVO -> budgetReleaseVO.getWbsId().equals(wbs5.getId())) || CollectionUtils.isEmpty(releasePayloadList = (detailRelaseList = detailsVOS.stream().filter(details -> details.getWbsId().equals(wbs5.getId())).collect(Collectors.toList())).stream().map(details -> {
                    PmsWbsBudgetReleasePayload releasePayload = new PmsWbsBudgetReleasePayload();
                    releasePayload.setWbsId(wbs5.getId());
                    releasePayload.setProId(proId);
                    releasePayload.setAllocatedResAmtBefore(details.getAllocatedResAmt());
                    releasePayload.setSettledResAmtBefore(details.getSettledResAmt());
                    releasePayload.setOccupiedResAmtBefore(details.getOccupiedResAmt());
                    releasePayload.setRemainingResAmtBefore(details.getRemainingResAmt());
                    releasePayload.setVersionId(budgetVersionId);
                    return releasePayload;
                }).collect(Collectors.toList()))) continue;
                releaseList.addAll(releasePayloadList);
            }
            List releaseVOS = this.pmsWbsBudgetReleaseService.insertAll(releaseList);
            log.debug("\u9884\u7b97\u91ca\u653e\u8868\uff1abudgetDetailsVO:{}", (Object)releaseVOS);
            budgetVO.setReleases(releaseVOS);
        }
        PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
        releaseQuery.setProId(proId);
        releaseQuery.setVersionId(budgetVersionVOId);
        long releaseCount = this.pmsWbsBudgetReleaseService.queryCount(releaseQuery);
        budgetVO.setReleasesCount(Long.valueOf(releaseCount));
        return budgetVO;
    }

    private void newWbsDataProcess(Long proId, PmsWbsBudgetVersionVO budgetVersionVO, PmsProjectWbsListVO wbs, List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadListTemp, List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList, Long wbsId, Long versionId, Long budgetVOId, List<PmsWbsBudgetDetailsPayload> newDetailPayloadList) {
        if (wbs.getEffRelateId() == null) {
            List list = budgetDetailsPayloadListTemp.stream().filter(details -> details.getWbsId().equals(wbs.getId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                if (list.size() > 1) {
                    throw TwException.error("", "\u6570\u636e\u5f02\u5e38");
                }
                PmsWbsBudgetDetailsPayload pmsWbsBudgetDetailsPayload = (PmsWbsBudgetDetailsPayload)list.get(0);
                budgetDetailsPayloadList.stream().filter(details -> details.getWbsId().equals(pmsWbsBudgetDetailsPayload.getWbsId())).forEach(details -> {
                    details.setWbsName(wbs.getWbsName());
                    details.setWbsCode(wbs.getWbsCode());
                    details.setWbsStatus(wbs.getWbsStatus());
                    details.setWbsId(wbsId);
                    PmsWbsBudgetDetailsPayload budgetDetail = this.getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, budgetVersionVO);
                    details.setResCost(budgetDetail.getResCost());
                });
            } else {
                PmsWbsBudgetDetailsPayload budgetDetail = this.getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, budgetVersionVO);
                newDetailPayloadList.add(budgetDetail);
            }
        }
    }

    @Transactional
    public List<PmsWbsBudgetDetailsVO> insertAll(List<PmsWbsBudgetDetailsPayload> budgetDetailsPayloadList) {
        ArrayList<PmsWbsBudgetDetailsVO> list = new ArrayList<PmsWbsBudgetDetailsVO>();
        if (!CollectionUtils.isEmpty(budgetDetailsPayloadList)) {
            budgetDetailsPayloadList.forEach(budgetDetailsPayload -> {
                PmsWbsBudgetDetailsVO budgetDetailsVO = this.dao.save((PmsWbsBudgetDetailsPayload)budgetDetailsPayload);
                list.add(budgetDetailsVO);
            });
        }
        return list;
    }

    @Transactional
    public List<PmsWbsBudgetDetailsVO> submit(List<PmsWbsBudgetDetailsPayload> list) {
        if (!CollectionUtils.isEmpty(list)) {
            PmsWbsBudgetDetailsPayload budgetDetailsPayload = list.get(0);
            Long versionId = budgetDetailsPayload.getVersionId();
            Long proId = budgetDetailsPayload.getProId();
            PmsWbsBudgetVersionVO pmsWbsBudgetVersionVO = this.pmsWbsBudgetVersionService.queryByKey(versionId);
            if (pmsWbsBudgetVersionVO.getObjectStatus().equals(BudgetVersionStatusEnum.ACTIVE.getCode())) {
                throw TwException.error("", "\u5f53\u524d\u7248\u672c\u5df2\u6fc0\u6d3b\uff0c\u4e0d\u80fd\u63d0\u4ea4");
            }
            Long budgetId = budgetDetailsPayload.getBudgetId();
            PmsWbsBudgetVO budgetVO = this.pmsWbsBudgetService.queryByKey(budgetId);
            BigDecimal totalResAmt = budgetVO.getTotalResAmt() == null ? BigDecimal.ZERO : budgetVO.getTotalResAmt();
            BigDecimal totalFeeAmt = budgetVO.getTotalFeeAmt();
            BigDecimal bigDecimal = totalFeeAmt = totalFeeAmt == null ? BigDecimal.ZERO : totalFeeAmt;
            if (totalResAmt.compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "\u8d44\u6e90\u603b\u9884\u7b97\u9700>=0");
            }
            if (totalFeeAmt.compareTo(BigDecimal.ZERO) < 0) {
                throw TwException.error("", "\u8d39\u7528\u603b\u9884\u7b97\u9700>=0");
            }
            BigDecimal allocatedBudgetSum = list.stream().map(pmsWbsBudgetDetailsPayload -> {
                BigDecimal allocateResAmt = pmsWbsBudgetDetailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetDetailsPayload.getAllocatedResAmt();
                BigDecimal changeResAmt = pmsWbsBudgetDetailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetDetailsPayload.getChangeResAmt();
                return allocateResAmt.add(changeResAmt);
            }).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (allocatedBudgetSum.compareTo(totalResAmt) > 0) {
                throw TwException.error("", "\u5206\u914d\u9884\u7b97\u5408\u8ba1\u503c =< \u8d44\u6e90\u603b\u9884\u7b97");
            }
            PmsWbsBudgetReleaseQuery budgetReleaseQuery = new PmsWbsBudgetReleaseQuery();
            budgetReleaseQuery.setProId(budgetVO.getProId());
            budgetReleaseQuery.setVersionId(versionId);
            List budgetReleaseVOS = this.pmsWbsBudgetReleaseService.queryList(budgetReleaseQuery);
            if (!CollectionUtils.isEmpty((Collection)budgetReleaseVOS)) {
                budgetReleaseVOS.forEach(budgetReleaseVO -> {
                    BigDecimal occupiedResAmtBefore;
                    BigDecimal confirmSettledRes = budgetReleaseVO.getConfirmSettledRes() == null ? BigDecimal.ZERO : budgetReleaseVO.getConfirmSettledRes();
                    BigDecimal bigDecimal = occupiedResAmtBefore = budgetReleaseVO.getOccupiedResAmtBefore() == null ? BigDecimal.ZERO : budgetReleaseVO.getOccupiedResAmtBefore();
                    if (confirmSettledRes.compareTo(occupiedResAmtBefore) != 0) {
                        log.error("\u9700\u8981\u91ca\u653e\u6240\u6709\u88ab\u53d6\u6d88\u6d3b\u52a8\u7684\u9884\u7b97;getWbsId:{};getWbsName:{};getWbsCode:{}", new Object[]{budgetReleaseVO.getWbsId(), budgetReleaseVO.getWbsName(), budgetReleaseVO.getWbsCode()});
                        log.error("\u9700\u8981\u91ca\u653e\u6240\u6709\u88ab\u53d6\u6d88\u6d3b\u52a8\u7684\u9884\u7b97;confirmSettledRes:{};occupiedResAmtBefore:{};", (Object)confirmSettledRes, (Object)occupiedResAmtBefore);
                        throw TwException.error("", "\u9700\u8981\u91ca\u653e\u6240\u6709\u88ab\u53d6\u6d88\u6d3b\u52a8\u7684\u9884\u7b97");
                    }
                });
            }
            PmsWbsBudgetVersionPayload versionPayload = new PmsWbsBudgetVersionPayload();
            versionPayload.setId(versionId);
            versionPayload.setObjectStatus(BudgetVersionStatusEnum.ACTIVE.getCode());
            this.pmsWbsBudgetVersionService.updateDynamic(versionPayload);
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setProId(proId);
            releaseQuery.setVersionId(versionId);
            List pmsWbsBudgetReleaseVOS = this.pmsWbsBudgetReleaseService.queryList(releaseQuery);
            if (!CollectionUtils.isEmpty((Collection)pmsWbsBudgetReleaseVOS)) {
                List updateWbsIdList = pmsWbsBudgetReleaseVOS.stream().map(PmsWbsBudgetReleaseVO::getWbsId).collect(Collectors.toList());
                this.pmsProjectActListService.updateReleaseFlag(updateWbsIdList);
                PmsProjectWbsQuery wbsQuery = new PmsProjectWbsQuery();
                wbsQuery.setIdList(updateWbsIdList);
                List pmsProjectWbsListVOS = this.pmsProjectActListService.queryList(wbsQuery);
                List updateWbsIdListVersionZero = pmsProjectWbsListVOS.stream().map(PmsProjectWbsListVO::getEffRelateId).collect(Collectors.toList());
                this.pmsProjectActListService.updateReleaseFlag(updateWbsIdListVersionZero);
                this.pmsProjectActListService.updateReleaseFlagByEffRelateId(updateWbsIdListVersionZero);
            }
            this.calculateMainTableInformation(budgetId);
            Long effRelateIdV0Id = budgetVO.getEffRelateId();
            if (effRelateIdV0Id != null) {
                PmsWbsBudgetVO budgetZeroVersion = this.pmsWbsBudgetService.queryByKey(effRelateIdV0Id);
                log.debug("V0\u7248\u672c\u9884\u7b97\u4e3b\u8868\uff1abudgetZeroVersion:{}", (Object)budgetZeroVersion);
                PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
                BeanUtils.copyProperties((Object)budgetVO, (Object)budgetPayload);
                budgetPayload.setId(effRelateIdV0Id);
                budgetPayload.setVersionId(budgetZeroVersion.getVersionId());
                budgetPayload.setVersionNo(budgetZeroVersion.getVersionNo());
                this.pmsWbsBudgetService.updateDynamic(budgetPayload);
                PmsProjectWbsQuery wbsQuery = new PmsProjectWbsQuery();
                List idList = list.stream().map(PmsWbsBudgetDetailsPayload::getWbsId).collect(Collectors.toList());
                wbsQuery.setIdList(idList);
                List pmsProjectWbsListVOS = this.pmsProjectActListService.queryList(wbsQuery);
                list.forEach(payload -> {
                    PmsProjectWbsListVO pmsProjectWbsListVO = pmsProjectWbsListVOS.stream().filter(wbsListVO -> wbsListVO.getId().equals(payload.getWbsId())).findFirst().orElse(null);
                    if (pmsProjectWbsListVO != null) {
                        payload.setWbsId(pmsProjectWbsListVO.getEffRelateId());
                    }
                });
                List<PmsWbsBudgetDetailsVO> detailsVOS = this.insertAll(list);
                PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
                detailsQuery.setBudgetId(budgetZeroVersion.getEffRelateId());
                List<PmsWbsBudgetDetailsVO> detailsZeroList = this.queryList(detailsQuery);
                detailsVOS.forEach(detail -> {
                    PmsWbsBudgetDetailsVO detailZero = detailsZeroList.stream().filter(detailZeroTemp -> detailZeroTemp.getId().equals(detail.getEffRelateId())).findFirst().orElse(null);
                    if (detailZero != null) {
                        PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                        BeanUtils.copyProperties((Object)detail, (Object)detailsPayload);
                        detailsPayload.setId(detailZero.getId());
                        detailsPayload.setVersionId(budgetZeroVersion.getVersionId());
                        detailsPayload.setVersionNo(budgetZeroVersion.getVersionNo());
                        detailsPayload.setBudgetId(budgetZeroVersion.getId());
                        BigDecimal allocatedResAmt = detailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getAllocatedResAmt();
                        BigDecimal changeResAmt = detailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : detailsPayload.getChangeResAmt();
                        BigDecimal occupiedResAmt = detailsPayload.getOccupiedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getOccupiedResAmt();
                        BigDecimal settledResAmt = detailsPayload.getSettledResAmt() == null ? BigDecimal.ZERO : detailsPayload.getSettledResAmt();
                        BigDecimal allocatedResAmtNew = allocatedResAmt.add(changeResAmt);
                        detailsPayload.setChangedAllocatedResAmt(allocatedResAmtNew);
                        detailsPayload.setChangeResAmt(BigDecimal.ZERO);
                        detailsPayload.setAllocatedResAmt(allocatedResAmtNew);
                        BigDecimal remainingResAmt = allocatedResAmtNew.subtract(occupiedResAmt).subtract(settledResAmt);
                        detailsPayload.setRemainingResAmt(remainingResAmt);
                        this.updateDynamic(detailsPayload);
                    } else {
                        PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                        BeanUtils.copyProperties((Object)detail, (Object)detailsPayload);
                        detailsPayload.setId(null);
                        detailsPayload.setVersionId(budgetZeroVersion.getVersionId());
                        detailsPayload.setVersionNo(budgetZeroVersion.getVersionNo());
                        detailsPayload.setBudgetId(budgetZeroVersion.getId());
                        BigDecimal allocatedResAmt = detailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getAllocatedResAmt();
                        BigDecimal occupiedResAmt = detailsPayload.getOccupiedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getOccupiedResAmt();
                        BigDecimal settledResAmt = detailsPayload.getSettledResAmt() == null ? BigDecimal.ZERO : detailsPayload.getSettledResAmt();
                        BigDecimal changeResAmt = detailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : detailsPayload.getChangeResAmt();
                        BigDecimal allocatedResAmtNew = allocatedResAmt.add(changeResAmt);
                        detailsPayload.setChangedAllocatedResAmt(allocatedResAmtNew);
                        detailsPayload.setAllocatedResAmt(allocatedResAmtNew);
                        detailsPayload.setChangeResAmt(BigDecimal.ZERO);
                        BigDecimal remainingResAmt = allocatedResAmtNew.subtract(occupiedResAmt).subtract(settledResAmt);
                        detailsPayload.setRemainingResAmt(remainingResAmt);
                        PmsWbsBudgetDetailsVO pmsWbsBudgetDetailsVO = this.insert(detailsPayload);
                    }
                });
                this.calculateMainTableInformation(effRelateIdV0Id);
                return detailsVOS;
            }
            Long budgetId1 = list.get(0).getBudgetId();
            list.forEach(detailsPayload -> {
                BigDecimal allocatedResAmt = detailsPayload.getAllocatedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getAllocatedResAmt();
                BigDecimal changeResAmt = detailsPayload.getChangeResAmt() == null ? BigDecimal.ZERO : detailsPayload.getChangeResAmt();
                BigDecimal allocatedResAmtNew = allocatedResAmt.add(changeResAmt);
                detailsPayload.setChangedAllocatedResAmt(allocatedResAmtNew);
                detailsPayload.setAllocatedResAmt(allocatedResAmtNew);
                BigDecimal occupiedResAmt = detailsPayload.getOccupiedResAmt() == null ? BigDecimal.ZERO : detailsPayload.getOccupiedResAmt();
                BigDecimal settledResAmt = detailsPayload.getSettledResAmt() == null ? BigDecimal.ZERO : detailsPayload.getSettledResAmt();
                BigDecimal remainingResAmt = allocatedResAmtNew.subtract(occupiedResAmt).subtract(settledResAmt);
                detailsPayload.setRemainingResAmt(remainingResAmt);
            });
            List<PmsWbsBudgetDetailsVO> detailsVOS = this.insertAll(list);
            this.calculateMainTableInformation(budgetId1);
            return detailsVOS;
        }
        return null;
    }

    @Transactional
    public void calculateMainTableInformation(Long budgetId) {
        PmsWbsBudgetVO pmsWbsBudgetVO = this.pmsWbsBudgetService.queryByKey(budgetId);
        PmsWbsBudgetDetailsQuery budgetDetailsQuery = new PmsWbsBudgetDetailsQuery();
        budgetDetailsQuery.setBudgetId(budgetId);
        List<PmsWbsBudgetDetailsVO> pmsWbsBudgetDetailsVOS = this.queryList(budgetDetailsQuery);
        BigDecimal occupiedResAmtNew = pmsWbsBudgetDetailsVOS.stream().map(PmsWbsBudgetDetailsVO::getOccupiedResAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal settledResAmtNew = pmsWbsBudgetDetailsVOS.stream().map(PmsWbsBudgetDetailsVO::getSettledResAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalResAmt = pmsWbsBudgetVO.getTotalResAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetVO.getTotalResAmt();
        BigDecimal totalRemainingResAmt = totalResAmt.subtract(occupiedResAmtNew).subtract(settledResAmtNew);
        PmsWbsBudgetPayload pmsWbsBudgetPayload = new PmsWbsBudgetPayload();
        pmsWbsBudgetPayload.setId(budgetId);
        pmsWbsBudgetPayload.setTotalResAmt(totalResAmt);
        pmsWbsBudgetPayload.setTotalOccupiedResAmt(occupiedResAmtNew);
        pmsWbsBudgetPayload.setTotalSettledResAmt(settledResAmtNew);
        pmsWbsBudgetPayload.setTotalRemainingResAmt(totalRemainingResAmt);
        BigDecimal totalFeeAmt = pmsWbsBudgetVO.getTotalFeeAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetVO.getTotalFeeAmt();
        pmsWbsBudgetPayload.setTotalFeeAmt(totalFeeAmt);
        BigDecimal totalOccupiedFeeAmt = pmsWbsBudgetVO.getTotalOccupiedFeeAmt() == null ? BigDecimal.ZERO : pmsWbsBudgetVO.getTotalOccupiedFeeAmt();
        pmsWbsBudgetPayload.setTotalOccupiedFeeAmt(totalOccupiedFeeAmt);
        BigDecimal totalRemainingFeeAmt = totalFeeAmt.subtract(totalOccupiedFeeAmt).subtract(totalOccupiedFeeAmt);
        pmsWbsBudgetPayload.setTotalRemainingFeeAmt(totalRemainingFeeAmt);
        this.pmsWbsBudgetService.updateDynamic(pmsWbsBudgetPayload);
    }

    @Transactional
    public List<PmsWbsBudgetDetailsVO> releaseOk(List<Long> releaseIdList) {
        ArrayList<PmsWbsBudgetDetailsVO> updateList = new ArrayList<PmsWbsBudgetDetailsVO>();
        if (!CollectionUtils.isEmpty(releaseIdList)) {
            PmsWbsBudgetReleaseQuery releaseQuery = new PmsWbsBudgetReleaseQuery();
            releaseQuery.setIds(releaseIdList);
            List pmsWbsBudgetReleaseVOS = this.pmsWbsBudgetReleaseService.queryList(releaseQuery);
            AtomicReference budgetIdAtomic = new AtomicReference();
            pmsWbsBudgetReleaseVOS.forEach(release -> {
                PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
                BigDecimal confirmSettledRes = release.getConfirmSettledRes() == null ? BigDecimal.ZERO : release.getConfirmSettledRes();
                BigDecimal changeResAmt = release.getChangeResAmt() == null ? BigDecimal.ZERO : release.getChangeResAmt();
                BigDecimal allocatedResAmtAfter = release.getOccupiedResAmtAfter() == null ? BigDecimal.ZERO : release.getOccupiedResAmtAfter();
                BigDecimal settledResAmtBefore = release.getSettledResAmtBefore() == null ? BigDecimal.ZERO : release.getSettledResAmtBefore();
                detailsQuery.setWbsId(release.getWbsId());
                List<PmsWbsBudgetDetailsVO> detailsVOS = this.queryList(detailsQuery);
                detailsVOS.forEach(details -> {
                    PmsWbsBudgetDetailsPayload detailsPayload = new PmsWbsBudgetDetailsPayload();
                    detailsPayload.setId(details.getId());
                    BigDecimal allocatedResAmt = details.getAllocatedResAmt() == null ? BigDecimal.ZERO : details.getAllocatedResAmt();
                    BigDecimal changeResAmtNegate = changeResAmt.negate();
                    detailsPayload.setChangeResAmt(changeResAmtNegate);
                    detailsPayload.setChangedAllocatedResAmt(allocatedResAmt.add(changeResAmtNegate));
                    detailsPayload.setSettledResAmt(settledResAmtBefore.add(confirmSettledRes));
                    BigDecimal occupiedResAmt = allocatedResAmtAfter;
                    detailsPayload.setOccupiedResAmt(allocatedResAmtAfter);
                    detailsPayload.setRemainingResAmt(detailsPayload.getChangedAllocatedResAmt().subtract(occupiedResAmt).subtract(confirmSettledRes));
                    PmsWbsBudgetDetailsVO pmsWbsBudgetDetailsVO = this.updateDynamic(detailsPayload);
                    updateList.add(pmsWbsBudgetDetailsVO);
                    budgetIdAtomic.set(details.getBudgetId());
                });
            });
            Long budgetId = (Long)budgetIdAtomic.get();
            if (null != budgetId) {
                this.calculateMainTableInformation(budgetId);
            }
        }
        return updateList;
    }

    public PmsWbsBudgetDetailsVO getByWbsId(Long wbsId, Long projectId) {
        PmsWbsBudgetVersionVO proIdAndVersionNo = this.pmsWbsBudgetVersionService.queryByProjectIdAndVersionNo(projectId, 0);
        Long versionId = proIdAndVersionNo.getId();
        PmsWbsBudgetDetailsQuery detailsQuery = new PmsWbsBudgetDetailsQuery();
        detailsQuery.setWbsId(wbsId);
        detailsQuery.setVersionId(versionId);
        List<PmsWbsBudgetDetailsVO> detailsVOS = this.queryList(detailsQuery);
        if (!CollectionUtils.isEmpty(detailsVOS)) {
            if (detailsVOS.size() > 1) {
                throw TwException.error("", "\u9884\u7b97\u660e\u7ec6\u6d3b\u52a8\u6570\u636e\u91cd\u590d");
            }
            return detailsVOS.get(0);
        }
        return null;
    }

    @Transactional
    public void updateList(List<PmsWbsBudgetDetailsPayload> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (PmsWbsBudgetDetailsPayload pmsWbsBudgetDetailsPayload : list) {
                this.update(pmsWbsBudgetDetailsPayload);
            }
            Long budgetId = list.get(0).getBudgetId();
            this.calculateMainTableInformation(budgetId);
        }
    }

    private PmsWbsBudgetVO createOneBudget(Long proId) {
        PmsWbsBudgetVersionVO version = this.pmsWbsBudgetVersionService.getVersion(proId, null);
        PmsWbsVersionVO wbsVersion = this.pmsWbsVersionService.getVersion(proId);
        PmsProjectWbsQuery pmsProjectWbsQuery = new PmsProjectWbsQuery();
        Long versionId = wbsVersion.getId();
        pmsProjectWbsQuery.setVersionId(versionId);
        pmsProjectWbsQuery.setWbsType(ProjectWbsTypeEnum.ACT.getCode());
        List wbsList = this.pmsProjectActListService.queryList(pmsProjectWbsQuery);
        PmsWbsBudgetPayload budgetPayload = new PmsWbsBudgetPayload();
        budgetPayload.setProId(proId);
        budgetPayload.setVersionNo(version.getVersionNo());
        budgetPayload.setVersionId(version.getId());
        PmsWbsBudgetVO wbsBudgetVO = this.pmsWbsBudgetService.insert(budgetPayload);
        Long budgetVOId = wbsBudgetVO.getId();
        ArrayList<PmsWbsBudgetDetailsPayload> budgetDetailsPayloads = new ArrayList<PmsWbsBudgetDetailsPayload>();
        for (PmsProjectWbsListVO wbs : wbsList) {
            Long wbsId = wbs.getId();
            PmsWbsBudgetDetailsPayload budgetDetail = this.getPmsWbsBudgetDetailsPayload(proId, wbs, wbsId, versionId, budgetVOId, version);
            budgetDetailsPayloads.add(budgetDetail);
        }
        List<PmsWbsBudgetDetailsVO> detailsVOS = this.insertAll(budgetDetailsPayloads);
        wbsBudgetVO.setDetails(detailsVOS);
        return wbsBudgetVO;
    }

    private PmsWbsBudgetDetailsPayload getPmsWbsBudgetDetailsPayload(Long proId, PmsProjectWbsListVO wbs, Long wbsId, Long versionId, Long budgetId, PmsWbsBudgetVersionVO version) {
        if (wbs == null) {
            throw new IllegalArgumentException("wbs cannot be null");
        }
        BigDecimal preDurationDay = wbs.getPreDurationDay() == null ? BigDecimal.ZERO : wbs.getPreDurationDay();
        PmsProjectWbsResourceQuery pmsProjectWbsResourceQuery = new PmsProjectWbsResourceQuery();
        pmsProjectWbsResourceQuery.setWbsId(wbsId);
        pmsProjectWbsResourceQuery.setVersionId(versionId);
        List wbsResourceVOS = this.pmsProjectWbsResourceService.getList(pmsProjectWbsResourceQuery);
        BigDecimal resCostSum = this.calculateResourceCost(wbsResourceVOS, preDurationDay);
        PmsWbsBudgetDetailsPayload budgetDetail = new PmsWbsBudgetDetailsPayload();
        budgetDetail.setBudgetId(budgetId);
        budgetDetail.setWbsId(wbsId);
        budgetDetail.setWbsName(wbs.getWbsName());
        budgetDetail.setWbsCode(wbs.getWbsCode());
        budgetDetail.setWbsStatus(wbs.getWbsStatus());
        budgetDetail.setProId(proId);
        budgetDetail.setResCost(resCostSum);
        budgetDetail.setVersionId(version.getId());
        budgetDetail.setVersionNo(version.getVersionNo());
        return budgetDetail;
    }

    private BigDecimal calculateResourceCost(List<PmsProjectWbsResourceVO> wbsResourceVOS, BigDecimal preDurationDay) {
        BigDecimal resCostSum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(wbsResourceVOS)) {
            for (PmsProjectWbsResourceVO wbsResourceVO : wbsResourceVOS) {
                Long roleId = wbsResourceVO.getRoleId();
                PmsProjectRoleVO pmsProjectRoleVO = this.pmsProjectRoleService.queryByKey(roleId);
                BigDecimal unitPrice = pmsProjectRoleVO.getUnitPrice() == null ? BigDecimal.ZERO : pmsProjectRoleVO.getUnitPrice();
                BigDecimal input = wbsResourceVO.getInput() == null ? BigDecimal.ZERO : wbsResourceVO.getInput();
                BigDecimal resCost = preDurationDay.multiply(input).multiply(unitPrice).divide(new BigDecimal("100")).setScale(2, 4);
                resCostSum = resCostSum.add(resCost);
            }
        }
        return resCostSum;
    }

    private Long countByProjectIdAndVersion(Long proId, int version) {
        PmsWbsBudgetQuery query = new PmsWbsBudgetQuery();
        query.setProId(proId);
        query.setVersionNo(Integer.valueOf(version));
        return this.pmsWbsBudgetService.queryCount(query);
    }

    private void checkData(PmsWbsBudgetDetailsPayload payload) {
    }

    private void translate(List<PmsWbsBudgetDetailsVO> vos) {
        vos.forEach(vo -> {});
    }

    public PmsWbsBudgetDetailsServiceImpl(PmsWbsBudgetDetailsDao dao, PmsWbsBudgetVersionService pmsWbsBudgetVersionService, PmsWbsVersionService pmsWbsVersionService, PmsProjectActListService pmsProjectActListService, PmsProjectWbsResourceService pmsProjectWbsResourceService, PmsProjectRoleService pmsProjectRoleService, PmsWbsBudgetReleaseService pmsWbsBudgetReleaseService) {
        this.dao = dao;
        this.pmsWbsBudgetVersionService = pmsWbsBudgetVersionService;
        this.pmsWbsVersionService = pmsWbsVersionService;
        this.pmsProjectActListService = pmsProjectActListService;
        this.pmsProjectWbsResourceService = pmsProjectWbsResourceService;
        this.pmsProjectRoleService = pmsProjectRoleService;
        this.pmsWbsBudgetReleaseService = pmsWbsBudgetReleaseService;
    }
}

