/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanDtlVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetService;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetDao;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PmsWbsBudgetServiceImpl
implements PmsWbsBudgetService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsBudgetServiceImpl.class);
    private final PmsWbsBudgetDao dao;
    private final PmsWbsBudgetVersionService pmsWbsBudgetVersionService;
    @Resource
    private PersonPlanService personPlanService;

    public PagingVO<PmsWbsBudgetVO> queryPage(PmsWbsBudgetQuery query) {
        PagingVO<PmsWbsBudgetVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return pageVO;
    }

    public List<PmsWbsBudgetVO> queryList(PmsWbsBudgetQuery query) {
        List<PmsWbsBudgetVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return listVO;
    }

    public long queryCount(PmsWbsBudgetQuery query) {
        return this.dao.queryCount(query);
    }

    public PmsWbsBudgetVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return vo;
    }

    @Transactional
    public PmsWbsBudgetVO insert(PmsWbsBudgetPayload payload) {
        this.checkData(payload);
        PmsWbsBudgetVO save = this.dao.save(payload);
        this.defaultValueAndCalculate(save);
        return this.queryByKey(save.getId());
    }

    private void defaultValueAndCalculate(PmsWbsBudgetVO save) {
        PmsWbsBudgetPayload updatedPayload = new PmsWbsBudgetPayload();
        updatedPayload.setId(save.getId());
        BigDecimal totalResAmt = save.getTotalResAmt() == null ? BigDecimal.ZERO : save.getTotalResAmt();
        updatedPayload.setTotalResAmt(totalResAmt);
        BigDecimal totalSettledResAmt = save.getTotalSettledResAmt() == null ? BigDecimal.ZERO : save.getTotalSettledResAmt();
        updatedPayload.setTotalSettledResAmt(totalSettledResAmt);
        BigDecimal totalOccupiedResAmt = save.getTotalOccupiedResAmt() == null ? BigDecimal.ZERO : save.getTotalOccupiedResAmt();
        updatedPayload.setTotalOccupiedResAmt(totalOccupiedResAmt);
        updatedPayload.setTotalRemainingResAmt(totalResAmt.subtract(totalSettledResAmt).subtract(totalOccupiedResAmt));
        BigDecimal totalFeeAmt = save.getTotalFeeAmt() == null ? BigDecimal.ZERO : save.getTotalFeeAmt();
        updatedPayload.setTotalFeeAmt(totalFeeAmt);
        BigDecimal totalSettledFeeAmt = save.getTotalSettledFeeAmt() == null ? BigDecimal.ZERO : save.getTotalSettledFeeAmt();
        updatedPayload.setTotalSettledFeeAmt(totalSettledFeeAmt);
        BigDecimal totalOccupiedFeeAmt = save.getTotalOccupiedFeeAmt() == null ? BigDecimal.ZERO : save.getTotalOccupiedFeeAmt();
        updatedPayload.setTotalOccupiedFeeAmt(totalOccupiedFeeAmt);
        updatedPayload.setTotalRemainingFeeAmt(totalFeeAmt.subtract(totalSettledFeeAmt).subtract(totalOccupiedFeeAmt));
        this.dao.updateByKeyDynamic(updatedPayload);
    }

    @Transactional
    public PmsWbsBudgetVO update(PmsWbsBudgetPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsWbsBudgetVO save = this.dao.save(payload);
        this.defaultValueAndCalculate(save);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetVO updateDynamic(PmsWbsBudgetPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        PmsWbsBudgetVO pmsWbsBudgetVO = this.queryByKey(payload.getId());
        this.defaultValueAndCalculate(pmsWbsBudgetVO);
        return pmsWbsBudgetVO;
    }

    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dao.deleteSoft(ids);
    }

    @Transactional
    public List<PmsWbsBudgetVO> insertAll(List<PmsWbsBudgetPayload> newBudgetList) {
        ArrayList<PmsWbsBudgetVO> list = new ArrayList<PmsWbsBudgetVO>();
        if (!CollectionUtils.isEmpty(newBudgetList)) {
            newBudgetList.forEach(item -> {
                PmsWbsBudgetVO wbsBudgetVO = this.insert((PmsWbsBudgetPayload)item);
                list.add(wbsBudgetVO);
            });
        }
        return list;
    }

    public PmsWbsBudgetVO getByProIdAndVersionId(Long proId, Long versionId) {
        Assert.notNull((Object)proId, (String)"proId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)versionId, (String)"versionId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PmsWbsBudgetVersionVO versionVO = this.pmsWbsBudgetVersionService.queryByKey(versionId);
        PmsWbsBudgetVO wbsBudgetCurrentVO = this.dao.getByProIdAndVersionId(proId, versionId);
        Integer versionNo = versionVO.getVersionNo();
        if (null != versionVO && versionNo > 0) {
            int lastVersionNo = versionNo - 1;
            PmsWbsBudgetVersionVO lastVersionVO = this.pmsWbsBudgetVersionService.getProIdAndVersionNo(proId, lastVersionNo);
            PmsWbsBudgetVO wbsBudgetLastVO = this.dao.getByProIdAndVersionId(proId, lastVersionVO.getId());
            wbsBudgetCurrentVO.setLastBudget(wbsBudgetLastVO);
        }
        PmsWbsBudgetVersionVO zerotVersionVO = this.pmsWbsBudgetVersionService.getProIdAndVersionNo(proId, 0);
        PmsWbsBudgetVO wbsBudgetZeroVO = this.dao.getByProIdAndVersionId(proId, zerotVersionVO.getId());
        wbsBudgetCurrentVO.setZeroBudget(wbsBudgetZeroVO);
        return wbsBudgetCurrentVO;
    }

    @Transactional
    public BigDecimal updateByResPlan(Long proId, Long budgetId) {
        PersonPlanVO resPlan = this.personPlanService.getByProId(proId);
        if (null == resPlan) {
            return BigDecimal.ZERO;
        }
        List personPlanDtlVOList = resPlan.getPersonPlanDtlVOList();
        BigDecimal totalResAmt = personPlanDtlVOList.stream().map(PersonPlanDtlVO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        return totalResAmt;
    }

    private void checkData(PmsWbsBudgetPayload payload) {
    }

    private void translate(List<PmsWbsBudgetVO> vos) {
        vos.forEach(vo -> {});
    }

    public PmsWbsBudgetServiceImpl(PmsWbsBudgetDao dao, PmsWbsBudgetVersionService pmsWbsBudgetVersionService) {
        this.dao = dao;
        this.pmsWbsBudgetVersionService = pmsWbsBudgetVersionService;
    }
}

