/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.budget.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.payload.PmsWbsBudgetVersionPayload;
import com.elitesland.tw.tw5.api.prd.pms.budget.query.PmsWbsBudgetVersionQuery;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetVersionService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetVersionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.budget.constants.BudgetVersionStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.budget.dao.PmsWbsBudgetVersionDao;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PmsWbsBudgetVersionServiceImpl
implements PmsWbsBudgetVersionService {
    private static final Logger log = LoggerFactory.getLogger(PmsWbsBudgetVersionServiceImpl.class);
    private final PmsWbsBudgetVersionDao dao;

    public PmsWbsBudgetVersionVO getVersion(Long proId, String objStatus) {
        PmsWbsBudgetVersionVO pmsWbsVersionVO = this.dao.getVersion(proId, objStatus);
        if (null != pmsWbsVersionVO) {
            return pmsWbsVersionVO;
        }
        if (StringUtils.hasText((String)objStatus)) {
            return null;
        }
        PmsWbsBudgetVersionPayload payload = new PmsWbsBudgetVersionPayload();
        payload.setProId(proId);
        payload.setObjectStatus(BudgetVersionStatusEnum.CREATE.getCode());
        payload.setStepNum(Integer.valueOf(3));
        payload.setVersionNo(Integer.valueOf(0));
        PmsWbsBudgetVersionVO save = this.dao.save(payload);
        return save;
    }

    public PagingVO<PmsWbsBudgetVersionVO> queryPage(PmsWbsBudgetVersionQuery query) {
        PagingVO<PmsWbsBudgetVersionVO> pageVO = this.dao.queryPage(query);
        this.translate(pageVO.getRecords());
        return pageVO;
    }

    public List<PmsWbsBudgetVersionVO> queryList(PmsWbsBudgetVersionQuery query) {
        List<PmsWbsBudgetVersionVO> listVO = this.dao.queryList(query);
        this.translate(listVO);
        return listVO;
    }

    public long queryCount(PmsWbsBudgetVersionQuery query) {
        return this.dao.queryCount(query);
    }

    public PmsWbsBudgetVersionVO queryByKey(Long id) {
        if (null == id) {
            return null;
        }
        PmsWbsBudgetVersionVO vo = this.dao.queryByKey(id);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u7248\u672c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return vo;
    }

    public PmsWbsBudgetVersionVO queryByProjectIdAndVersionNo(Long projectId, int versionNo) {
        PmsWbsBudgetVersionVO pmsWbsBudgetVersionVO = this.dao.queryByProjectIdAndVersionNo(projectId, versionNo);
        Assert.notNull((Object)pmsWbsBudgetVersionVO, (String)"\u67e5\u8be2\u7684\u7248\u672c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        return pmsWbsBudgetVersionVO;
    }

    @Transactional
    public PmsWbsBudgetVersionVO insert(PmsWbsBudgetVersionPayload payload) {
        this.checkData(payload);
        PmsWbsBudgetVersionVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetVersionVO update(PmsWbsBudgetVersionPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        PmsWbsBudgetVersionVO save = this.dao.save(payload);
        return this.queryByKey(save.getId());
    }

    @Transactional
    public PmsWbsBudgetVersionVO updateDynamic(PmsWbsBudgetVersionPayload payload) {
        Assert.notNull((Object)payload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkData(payload);
        this.dao.updateByKeyDynamic(payload);
        return this.queryByKey(payload.getId());
    }

    @Transactional
    public Long deleteSoft(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw TwException.error("", "ids\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dao.deleteSoft(ids);
    }

    public PmsWbsBudgetVersionVO getProIdAndVersionNo(Long proId, int lastVersionNo) {
        Assert.notNull((Object)proId, (String)"proId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)lastVersionNo, (String)"versionNo\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PmsWbsBudgetVersionVO vo = this.dao.getProIdAndVersionNo(proId, lastVersionNo);
        Assert.notNull((Object)vo, (String)"\u67e5\u8be2\u7684\u7248\u672c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.translate(List.of(vo));
        return vo;
    }

    private void checkData(PmsWbsBudgetVersionPayload payload) {
    }

    private void translate(List<PmsWbsBudgetVersionVO> vos) {
        vos.forEach(vo -> {});
    }

    public PmsWbsBudgetVersionServiceImpl(PmsWbsBudgetVersionDao dao) {
        this.dao = dao;
    }
}

