/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.common.log.vo.ComLogVO;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSchedulingPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSnapshotPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsSubmitDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsSnapshotQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsSnapshotVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u9879\u76eewbs\u8868"})
@RestController
@RequestMapping(value={"/api/crm/pmsProjectWbs"})
public class PmsProjectWbsController {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectWbsController.class);
    private final PmsProjectWbsService pmsProjectWbsService;
    private final ProRelatedPartiesService proRelatedPartiesService;
    private final PmsDeliverItemService pmsDeliverItemService;

    @PostMapping
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539")
    public TwOutputUtil batchInsertOrUpdate(@RequestBody PmsProjectWbsDataPayload payload) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.batchInsertOrUpdate(payload));
    }

    @PostMapping(value={"updateState"})
    @ApiOperation(value="\u4fee\u6539wbs\u72b6\u6001")
    public TwOutputUtil updateState(@RequestBody PmsProjectWbsPayload payload) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.updateState(payload));
    }

    @PostMapping(value={"submit"})
    @ApiOperation(value="\u63d0\u4ea4")
    public TwOutputUtil submit(@RequestBody List<Long> wbsId) {
        List pmsProjectWbsVOList = this.pmsProjectWbsService.submitVer(wbsId);
        return TwOutputUtil.ok(pmsProjectWbsVOList);
    }

    @PostMapping(value={"submitPro"})
    @ApiOperation(value="\u63d0\u4ea4")
    public TwOutputUtil<PmsProjectWbsVO> submitPro(@RequestBody PmsProjectWbsSubmitDataPayload payload) {
        List pmsProjectWbsVOList = this.pmsProjectWbsService.submitVerPro(payload);
        return TwOutputUtil.ok(pmsProjectWbsVOList);
    }

    @PostMapping(value={"savePro"})
    @ApiOperation(value="\u4fdd\u5b58")
    public TwOutputUtil savePro(@RequestBody PmsProjectWbsSubmitDataPayload payload) {
        this.pmsProjectWbsService.savePro(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<PmsProjectWbsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.queryByKey(key));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<PmsProjectWbsVO> queryList(PmsProjectWbsQuery query) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.pmsProjectWbsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryLogList"})
    @ApiOperation(value="\u67e5\u8be2\u65e5\u5fd7\u5217\u8868")
    public TwOutputUtil<ComLogVO> queryLogList(PmsProjectWbsLogQuery query) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.queryLogList(query));
    }

    @PostMapping(value={"/insertSnapshot"})
    @ApiOperation(value="\u65b0\u589e\u5feb\u7167")
    public TwOutputUtil<PmsProjectWbsSnapshotVO> insertSnapshot(@RequestBody PmsProjectWbsSnapshotPayload payload) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.insertSnapshot(payload));
    }

    @GetMapping(value={"/querySnapshotList"})
    @ApiOperation(value="\u67e5\u8be2\u5feb\u7167\u5217\u8868")
    public TwOutputUtil<List<PmsProjectWbsSnapshotVO>> querySnapshotList(PmsProjectWbsSnapshotQuery query) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.querySnapshotList(query));
    }

    @DeleteMapping(value={"/deleteSoftSnapshot"})
    @ApiOperation(value="\u5220\u9664\u5feb\u7167")
    public TwOutputUtil deleteSoftSnapshot(Long[] snapshotKeys) {
        this.pmsProjectWbsService.deleteSoftSnapshot(Arrays.asList(snapshotKeys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/autoScheduling"})
    @ApiOperation(value="\u81ea\u52a8\u6392\u671f")
    public TwOutputUtil autoScheduling(@RequestBody PmsProjectWbsSchedulingPayload payload) {
        this.pmsProjectWbsService.autoScheduling(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/getProjectProgress"})
    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u8fdb\u5ea6")
    public TwOutputUtil getProjectProgress(Long projectId) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.getProjectProgress(projectId));
    }

    @GetMapping(value={"checkDate"})
    @ApiOperation(value="\u5fc5\u8981\u9879\u68c0\u67e51\u76f8\u5173\u65b9\u6570\u636e2\u4ea4\u4ed8\u6e05\u5355\u6570\u636e true\u4e3a\u901a\u8fc7")
    public TwOutputUtil checkDate(Long proId) {
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        ProRelatedPartiesQuery partiesQuery = new ProRelatedPartiesQuery();
        partiesQuery.setProId(proId);
        Long count1 = this.proRelatedPartiesService.count(partiesQuery);
        res.put("1", count1 > 0L);
        PmsDeliverItemQuery pmsDeliverItemQuery = new PmsDeliverItemQuery();
        pmsDeliverItemQuery.setProjectId(proId);
        pmsDeliverItemQuery.setShowFlag(true);
        Long count2 = this.pmsDeliverItemService.count(pmsDeliverItemQuery);
        res.put("2", count2 > 0L);
        return TwOutputUtil.ok(res);
    }

    @GetMapping(value={"/listMilestone"})
    @ApiOperation(value="\u9879\u76ee\u91cc\u7a0b\u7891\u5217\u8868")
    public TwOutputUtil<List<PmsProjectWbsVO>> listMilestone(PmsProjectWbsQuery query) {
        List list = this.pmsProjectWbsService.listMilestone(query);
        return TwOutputUtil.ok(list);
    }

    @GetMapping(value={"/listStage"})
    @ApiOperation(value="Wbs\u9636\u6bb5\u5217\u8868")
    public TwOutputUtil<List<PmsProjectWbsVO>> listStage(PmsProjectWbsQuery query) {
        List list = this.pmsProjectWbsService.listStage(query);
        return TwOutputUtil.ok(list);
    }

    @GetMapping(value={"/checkStep2"})
    @ApiOperation(value="Wbs\u6821\u9a8c\u7b2c\u4e8c\u6b65\u5217\u8868")
    public TwOutputUtil checkStep2(PmsProjectWbsQuery query) {
        this.pmsProjectWbsService.checkStep2(query);
        return TwOutputUtil.ok(true);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/batchImport/{projectId}"}, consumes={"multipart/form-data"})
    public TwOutputUtil batchImport(MultipartFile file, @PathVariable Long projectId) {
        return TwOutputUtil.ok(this.pmsProjectWbsService.importElecPlanTask(file, projectId));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @PostMapping(value={"/batchExport"})
    public void batchExport(HttpServletResponse response, @RequestBody PmsProjectWbsQuery query) {
        this.pmsProjectWbsService.exportElecPlanTask(response, query);
    }

    public PmsProjectWbsController(PmsProjectWbsService pmsProjectWbsService, ProRelatedPartiesService proRelatedPartiesService, PmsDeliverItemService pmsDeliverItemService) {
        this.pmsProjectWbsService = pmsProjectWbsService;
        this.proRelatedPartiesService = proRelatedPartiesService;
        this.pmsDeliverItemService = pmsDeliverItemService;
    }
}

