/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsListVO;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.personplan.entity.QProRelatedPartiesDO;
import com.elitesland.tw.tw5.server.prd.pms.budget.model.entity.QPmsWbsBudgetDetailsDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsResourceDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class PmsProjectActListDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final QPmsProjectWbsDO qdo = QPmsProjectWbsDO.pmsProjectWbsDO;
    private static final QPmsProjectWbsResourceDO qPmsProjectWbsResourceDO = QPmsProjectWbsResourceDO.pmsProjectWbsResourceDO;
    private static final QProRelatedPartiesDO qProRelatedPartiesDO = QProRelatedPartiesDO.proRelatedPartiesDO;
    private static final QPmsWbsBudgetDetailsDO qPmsWbsBudgetDetailsDO = QPmsWbsBudgetDetailsDO.pmsWbsBudgetDetailsDO;

    private JPAQuery<PmsProjectWbsListVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(PmsProjectWbsListVO.class, (Expression[])new Expression[]{PmsProjectActListDAO.qPmsProjectWbsResourceDO.relatePartiesId.as("managerRelatePartiesId"), PmsProjectActListDAO.qProRelatedPartiesDO.name.as("managerRelatePartiesName"), PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.resCost, PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.allocatedResAmt, PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.remainingResAmt, PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.occupiedResAmt, PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.settledResAmt, this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.projectId, this.qdo.parentId, this.qdo.wbsName, this.qdo.wbsType, this.qdo.wbsCode, this.qdo.nodeCode, this.qdo.parentWbsCode, this.qdo.wbsStatus, this.qdo.cancelShowFlag, this.qdo.managerUserId, this.qdo.subjectDist, this.qdo.startDate, this.qdo.endDate, this.qdo.preStartDate, this.qdo.preEndDate, this.qdo.preDurationDay, this.qdo.wbsProgress, this.qdo.durationDay, this.qdo.earlyStartDate, this.qdo.earlyEndDate, this.qdo.lateStartDate, this.qdo.lateEndDate, this.qdo.totalFloat, this.qdo.freeFloat, this.qdo.delayLag, this.qdo.isKeyNode, this.qdo.autoScheduling, this.qdo.costType, this.qdo.invoiceAttr, this.qdo.costPlan, this.qdo.wbsWeight, this.qdo.manualSettingWeight, this.qdo.versionId, this.qdo.versionNo, this.qdo.effRelateId, this.qdo.releaseFlag})).from((EntityPath)this.qdo)).leftJoin((EntityPath)qPmsProjectWbsResourceDO)).on((Predicate)this.qdo.id.eq(PmsProjectActListDAO.qPmsProjectWbsResourceDO.wbsId).and((Predicate)PmsProjectActListDAO.qPmsProjectWbsResourceDO.managerUserFlag.eq(Boolean.valueOf(true))))).leftJoin((EntityPath)qProRelatedPartiesDO)).on((Predicate)PmsProjectActListDAO.qProRelatedPartiesDO.id.eq(PmsProjectActListDAO.qPmsProjectWbsResourceDO.relatePartiesId))).leftJoin((EntityPath)qPmsWbsBudgetDetailsDO)).on((Predicate)this.qdo.id.eq(PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.wbsId).and((Predicate)PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.versionNo.eq((Object)0)));
    }

    public long count(PmsProjectWbsQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.countDistinct()).from((EntityPath)this.qdo)).leftJoin((EntityPath)qPmsProjectWbsResourceDO)).on((Predicate)this.qdo.id.eq(PmsProjectActListDAO.qPmsProjectWbsResourceDO.wbsId).and((Predicate)PmsProjectActListDAO.qPmsProjectWbsResourceDO.managerUserFlag.eq(Boolean.valueOf(true))))).leftJoin((EntityPath)qProRelatedPartiesDO)).on((Predicate)PmsProjectActListDAO.qProRelatedPartiesDO.id.eq(PmsProjectActListDAO.qPmsProjectWbsResourceDO.relatePartiesId))).leftJoin((EntityPath)qPmsWbsBudgetDetailsDO)).on((Predicate)this.qdo.id.eq(PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.wbsId).and((Predicate)PmsProjectActListDAO.qPmsWbsBudgetDetailsDO.versionNo.eq((Object)0)))).where(this.where(query))).fetchOne();
        return total;
    }

    private JPAQuery<PmsProjectWbsListVO> getJpaQueryWhere(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsListVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(PmsProjectWbsQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getManagerRelatePartiesId())) {
            list.add(PmsProjectActListDAO.qPmsProjectWbsResourceDO.relatePartiesId.eq((Object)query.getManagerRelatePartiesId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerRelatePartiesName())) {
            list.add(PmsProjectActListDAO.qProRelatedPartiesDO.name.like(SqlUtil.toSqlLikeString(query.getManagerRelatePartiesName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIdList())) {
            list.add(this.qdo.id.in((Collection)query.getIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsSearch())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString(query.getWbsSearch())).or((Predicate)this.qdo.wbsCode.like(SqlUtil.toSqlLikeString(query.getWbsSearch()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.like(SqlUtil.toSqlLikeString(query.getWbsName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsType())) {
            list.add(this.qdo.wbsType.eq((Object)query.getWbsType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsCode())) {
            list.add(this.qdo.wbsCode.like(SqlUtil.toSqlLikeString(query.getWbsCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNodeCode())) {
            list.add(this.qdo.nodeCode.eq((Object)query.getNodeCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentWbsCode())) {
            list.add(this.qdo.parentWbsCode.eq((Object)query.getParentWbsCode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentWbsCodes())) {
            list.add(this.qdo.parentWbsCode.in((Collection)query.getParentWbsCodes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostPlan())) {
            list.add(this.qdo.costPlan.eq((Object)query.getCostPlan()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSubjectDist())) {
            list.add(this.qdo.subjectDist.eq((Object)query.getSubjectDist()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInvoiceAttr())) {
            list.add(this.qdo.invoiceAttr.eq((Object)query.getInvoiceAttr()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDurationDay())) {
            list.add(this.qdo.durationDay.eq((Object)query.getDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostType())) {
            list.add(this.qdo.costType.eq((Object)query.getCostType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStartDate())) {
            list.add(this.qdo.startDate.eq((Object)query.getStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEndDate())) {
            list.add(this.qdo.endDate.eq((Object)query.getEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreStartDate())) {
            list.add(this.qdo.preStartDate.goe((Comparable)query.getPreStartDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreEndDate())) {
            list.add(this.qdo.preEndDate.loe((Comparable)query.getPreEndDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreDurationDay())) {
            list.add(this.qdo.preDurationDay.eq((Object)query.getPreDurationDay()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsProgress())) {
            list.add(this.qdo.wbsProgress.eq((Object)query.getWbsProgress()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManagerUserIds())) {
            list.add(this.qdo.managerUserId.in((Collection)query.getManagerUserIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsStatus())) {
            list.add(this.qdo.wbsStatus.eq((Object)query.getWbsStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsStatusPro())) {
            BooleanExpression expression = this.qdo.wbsStatus.eq((Object)query.getWbsStatusPro());
            if (query.getWbsStatusPro().equals(ProjectWbsStatusEnum.NOGIONG.getCode())) {
                expression = expression.or((Predicate)this.qdo.cancelShowFlag.eq(Boolean.valueOf(true)));
            }
            list.add(expression);
        }
        if (!ObjectUtils.isEmpty((Object)query.getState())) {
            list.add(this.qdo.state.eq((Object)query.getState()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersionNo())) {
            list.add(this.qdo.versionNo.eq((Object)query.getVersionNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVersionId())) {
            list.add(this.qdo.versionId.eq((Object)query.getVersionId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<PmsProjectWbsListVO> queryByProjectId(Long projectId) {
        JPAQuery<PmsProjectWbsListVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsListVO> queryListDynamic(PmsProjectWbsQuery query) {
        JPAQuery<PmsProjectWbsListVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateManagerUserId(Long projectId, List<Long> managerUserIds, Long managerUserId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.managerUserId, (Object)managerUserId).where(new Predicate[]{this.qdo.projectId.eq((Object)projectId).and((Predicate)this.qdo.managerUserId.in(managerUserIds))});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateWbsProgress(Long id, BigDecimal wbsProgress, String wbsStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.wbsProgress, (Object)wbsProgress).set((Path)this.qdo.wbsStatus, (Object)wbsStatus).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateWbsProgress(Long id, BigDecimal wbsProgress) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.wbsProgress, (Object)wbsProgress).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PagingVO<PmsProjectWbsListVO> queryPage(PmsProjectWbsQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectWbsListVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public Long updateWbsStatus(Long id, String wbsStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.wbsStatus, (Object)wbsStatus).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        if (StringUtils.hasText((String)wbsStatus) && wbsStatus.equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
            update.set(this.qdo.wbsProgress, (Object)new BigDecimal(100));
        }
        return update.execute();
    }

    public Long updateReleaseFlag(List<Long> idList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.releaseFlag, (Object)true).set((Path)this.qdo.state, (Object)"2").where(new Predicate[]{this.qdo.id.in(idList)});
        return update.execute();
    }

    public Long updateReleaseFlagByEffRelateId(List<Long> effRelateIdList) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.releaseFlag, (Object)true).set((Path)this.qdo.state, (Object)"2").where(new Predicate[]{this.qdo.effRelateId.in(effRelateIdList)});
        return update.execute();
    }

    public Long updateWbsStatusByVersionIdAndEffRelateId(Long versionId, Long effRelateId, String wbsStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.wbsStatus, (Object)wbsStatus).where(new Predicate[]{this.qdo.effRelateId.eq((Object)effRelateId).and((Predicate)this.qdo.versionId.eq((Object)versionId))});
        return update.execute();
    }

    public PmsProjectActListDAO(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

