/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectWbsRelyPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsRelyQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsRelyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectWbsRelyDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectWbsRelyDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectWbsRelyRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsProjectWbsRelyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsProjectWbsRelyRepo repo;
    private final QPmsProjectWbsRelyDO qdo = QPmsProjectWbsRelyDO.pmsProjectWbsRelyDO;
    private final QPmsProjectWbsDO qPmsProjectWbsDO = QPmsProjectWbsDO.pmsProjectWbsDO;

    private JPAQuery<PmsProjectWbsRelyVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsProjectWbsRelyVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.wbsId, this.qdo.wbsName, this.qdo.wbsRelyId, this.qdo.wbsRelyName, this.qdo.relationType, this.qdo.relyType, this.qdo.versionNo, this.qdo.versionId, this.qdo.effRelateId, this.qdo.wbsCode})).from((EntityPath)this.qdo);
    }

    public List<PmsProjectWbsRelyVO> listLeftJoinWbs(PmsProjectWbsRelyQuery query) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)Projections.bean(PmsProjectWbsRelyVO.class, (Expression[])new Expression[]{this.qPmsProjectWbsDO.wbsStatus, this.qdo.id, this.qdo.projectId, this.qdo.wbsId, this.qdo.wbsName, this.qdo.wbsRelyId, this.qdo.wbsRelyName, this.qdo.relationType, this.qdo.relyType})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPmsProjectWbsDO)).on((Predicate)this.qdo.wbsId.eq(this.qPmsProjectWbsDO.id))).where(this.whereLeftJoinWbs(query))).fetch();
    }

    private Predicate whereLeftJoinWbs(PmsProjectWbsRelyQuery query) {
        Predicate where = this.where(query);
        return where;
    }

    private JPAQuery<PmsProjectWbsRelyVO> getJpaQueryWhere(PmsProjectWbsRelyQuery query) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsProjectWbsRelyQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsProjectWbsRelyQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectId())) {
            list.add(this.qdo.projectId.eq((Object)query.getProjectId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsId())) {
            list.add(this.qdo.wbsId.eq((Object)query.getWbsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsIdList())) {
            list.add(this.qdo.wbsId.in((Collection)query.getWbsIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsName())) {
            list.add(this.qdo.wbsName.eq((Object)query.getWbsName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsRelyId())) {
            list.add(this.qdo.wbsRelyId.eq((Object)query.getWbsRelyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWbsRelyName())) {
            list.add(this.qdo.wbsRelyName.eq((Object)query.getWbsRelyName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRelyType())) {
            list.add(this.qdo.relyType.eq((Object)query.getRelyType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsProjectWbsRelyVO queryByKey(Long id) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsRelyVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectWbsRelyVO> queryByProjectId(Long projectId) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsRelyVO> queryByProjectIdAndVersionNo(Long projectId, Integer versionNo) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.projectId.eq((Object)projectId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.versionNo.eq((Object)versionNo));
        return jpaQuery.fetch();
    }

    public List<PmsProjectWbsRelyVO> queryByWbsIds(List<Long> wbsIds) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.in(wbsIds).or((Predicate)this.qdo.wbsRelyId.in(wbsIds)));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PmsProjectWbsRelyVO queryWbsIdAndWbsRelyIds(Long wbsId, List<Long> relyIds) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.eq((Object)wbsId));
        jpaQuery.where((Predicate)this.qdo.wbsRelyId.in(relyIds));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsRelyVO)jpaQuery.fetchFirst();
    }

    public PmsProjectWbsRelyVO queryWbsIdsAndWbsRelyId(List<Long> wbsIds, Long relyId) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.wbsId.in(wbsIds));
        jpaQuery.where((Predicate)this.qdo.wbsRelyId.eq((Object)relyId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsProjectWbsRelyVO)jpaQuery.fetchFirst();
    }

    public List<PmsProjectWbsRelyVO> queryListDynamic(PmsProjectWbsRelyQuery query) {
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsProjectWbsRelyVO> queryPaging(PmsProjectWbsRelyQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsProjectWbsRelyVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsProjectWbsRelyDO save(PmsProjectWbsRelyDO ado) {
        return (PmsProjectWbsRelyDO)this.repo.save(ado);
    }

    public List<PmsProjectWbsRelyDO> saveAll(List<PmsProjectWbsRelyDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsProjectWbsRelyPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getProjectId() != null) {
            update.set(this.qdo.projectId, (Object)payload.getProjectId());
        }
        if (payload.getWbsId() != null) {
            update.set(this.qdo.wbsId, (Object)payload.getWbsId());
        }
        if (payload.getWbsName() != null) {
            update.set((Path)this.qdo.wbsName, (Object)payload.getWbsName());
        }
        if (payload.getWbsRelyId() != null) {
            update.set(this.qdo.wbsRelyId, (Object)payload.getWbsRelyId());
        }
        if (payload.getWbsRelyName() != null) {
            update.set((Path)this.qdo.wbsRelyName, (Object)payload.getWbsRelyName());
        }
        if (payload.getRelyType() != null) {
            update.set((Path)this.qdo.relyType, (Object)payload.getRelyType());
        }
        if (payload.getEffRelateId() != null) {
            update.set(this.qdo.effRelateId, (Object)payload.getEffRelateId());
        }
        if (payload.getWbsCode() != null) {
            update.set((Path)this.qdo.wbsCode, (Object)payload.getWbsCode());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("projectId")) {
                update.setNull(this.qdo.projectId);
            }
            if (nullFields.contains("wbsId")) {
                update.setNull(this.qdo.wbsId);
            }
            if (nullFields.contains("wbsName")) {
                update.setNull((Path)this.qdo.wbsName);
            }
            if (nullFields.contains("wbsRelyId")) {
                update.setNull(this.qdo.wbsRelyId);
            }
            if (nullFields.contains("wbsRelyName")) {
                update.setNull((Path)this.qdo.wbsRelyName);
            }
            if (nullFields.contains("relyType")) {
                update.setNull((Path)this.qdo.relyType);
            }
        }
        return update.execute();
    }

    public long deleteSoftByWbsIds(List<Long> wbsIds) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.wbsId.in(wbsIds).or((Predicate)this.qdo.wbsRelyId.in(wbsIds))});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public void delByWbsId(Long wbsId, Integer versionNo) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.wbsId.eq((Object)wbsId)}).where(new Predicate[]{this.qdo.versionNo.eq((Object)versionNo)}).execute();
    }

    public void delByV0(List<Long> relyDelIds, Long wbsId) {
        long res = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.notIn(relyDelIds)}).where(new Predicate[]{this.qdo.versionNo.eq((Object)0)}).where(new Predicate[]{this.qdo.wbsId.eq((Object)wbsId)}).execute();
    }

    public PmsProjectWbsRelyDAO(JPAQueryFactory jpaQueryFactory, PmsProjectWbsRelyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

