/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.deliver.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSsoService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectWbsAcceptQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsAcceptService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsAcceptVO;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.deliver.constants.DeliverItemStatisticsStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.deliver.constants.DeliverItemStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.deliver.convert.PmsDeliverItemConvert;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.entity.PmsDeliverItemDO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.payload.PmsDeliverItemPayload;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.query.PmsDeliverItemQuery;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemStatisticsVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsDeliverItemVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.model.vo.PmsIframeDocInfoVO;
import com.elitesland.tw.tw5.server.prd.pms.deliver.repo.PmsDeliverItemRepo;
import com.elitesland.tw.tw5.server.prd.pms.deliver.repo.dao.PmsDeliverItemDao;
import com.elitesland.tw.tw5.server.prd.pms.deliver.service.PmsDeliverItemService;
import com.elitesland.tw.tw5.server.yeedocpro.config.YeedocProProperties;
import com.elitesland.tw.tw5.server.yeedocpro.dto.CreateFolderTwPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.FolderListByItemNameDTO;
import com.elitesland.tw.tw5.server.yeedocpro.dto.FolderListByItemNamePayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.ItemInfoPayload;
import com.elitesland.tw.tw5.server.yeedocpro.dto.YeedocCreateFolderForTwDTO;
import com.elitesland.tw.tw5.server.yeedocpro.service.YeedocProService;
import com.elitesland.tw.tw5.server.yeedocref.constants.YeedocRefTypeEnum;
import com.elitesland.tw.tw5.server.yeedocref.model.payload.PrdYeedocRefPayload;
import com.elitesland.tw.tw5.server.yeedocref.model.vo.PrdYeedocRefVO;
import com.elitesland.tw.tw5.server.yeedocref.service.PrdYeedocRefService;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsDeliverItemServiceImpl
implements PmsDeliverItemService {
    private static final Logger log = LoggerFactory.getLogger(PmsDeliverItemServiceImpl.class);
    private final PmsDeliverItemDao pmsDeliverItemDao;
    private final YeedocProProperties yeedocProProperties;
    private final PmsDeliverItemRepo pmsDeliverItemRepo;
    private final ProRelatedPartiesService proRelatedPartiesService;
    private final YeedocProService yeedocProService;
    private final PrdCasSsoService prdCasSsoService;
    @Resource
    @Lazy
    private PmsProjectService pmsProjectService;
    @Resource
    @Lazy
    private PmsProjectWbsAcceptService pmsProjectWbsAcceptService;
    @Resource
    private PrdYeedocRefService prdYeedocRefService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PmsDeliverItemVO save(PmsDeliverItemPayload pmsDeliverItemPayload) {
        this.checkData(pmsDeliverItemPayload);
        PmsDeliverItemDO pmsDeliverItemDO = PmsDeliverItemConvert.INSTANCE.p2d(pmsDeliverItemPayload);
        PmsDeliverItemDO res = (PmsDeliverItemDO)((Object)this.pmsDeliverItemRepo.save((Object)pmsDeliverItemDO));
        return PmsDeliverItemConvert.INSTANCE.d2v(res);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PmsDeliverItemVO updateAll(PmsDeliverItemPayload pmsDeliverItemPayload) {
        Assert.notNull((Object)pmsDeliverItemPayload.getId(), (String)"id is null", (Object[])new Object[0]);
        PmsDeliverItemVO res = this.save(pmsDeliverItemPayload);
        return res;
    }

    @Override
    public PmsDeliverItemVO get(Long id) {
        if (null == id) {
            return null;
        }
        PmsDeliverItemVO res = this.pmsDeliverItemDao.get(id);
        Assert.notNull((Object)res, (String)("\u4ea4\u4ed8\u9879\u4e0d\u5b58\u5728,id=" + id), (Object[])new Object[0]);
        this.translateOne(res);
        return res;
    }

    private void translateOne(PmsDeliverItemVO res) {
        String itemId = res.getItemId();
        if (StringUtils.hasText((String)itemId)) {
            HashSet<String> itemIdList = new HashSet<String>();
            itemIdList.add(itemId);
            ItemInfoPayload itemInfoPayload = new ItemInfoPayload();
            itemInfoPayload.setItemIds(itemIdList);
            Map<String, List<ItemInfoDataFileDTO>> stringListMap = this.yeedocProService.itemInfoReturn(itemInfoPayload);
            ArrayList<PmsDeliverItemPayload> updateStatusList = new ArrayList<PmsDeliverItemPayload>();
            res.setStatus(DeliverItemStatusEnum.NO.getCode());
            List<ItemInfoDataFileDTO> itemInfoDataFileDTOS = stringListMap.get(itemId);
            PmsDeliverItemPayload update = new PmsDeliverItemPayload();
            update.setId(res.getId());
            if (!CollectionUtil.isEmpty(itemInfoDataFileDTOS)) {
                res.setStatus(DeliverItemStatusEnum.OK.getCode());
            }
            update.setStatus(res.getStatus());
            updateStatusList.add(update);
            res.setFileList(itemInfoDataFileDTOS);
        }
    }

    @Override
    @Transactional
    public PagingVO<PmsDeliverItemVO> page(PmsDeliverItemQuery pmsDeliverItemQuery) {
        String submitContent = pmsDeliverItemQuery.getFileList();
        if (StringUtils.hasText((String)submitContent)) {
            PrdYeedocRefVO prdYeedocRefVO = this.prdYeedocRefService.queryByRefTypeAndRefId(YeedocRefTypeEnum.PMS_PROJECT, pmsDeliverItemQuery.getProjectId());
            if (prdYeedocRefVO == null) {
                return PagingVO.empty();
            }
            FolderListByItemNamePayload payload = new FolderListByItemNamePayload();
            payload.setLeafName(submitContent);
            payload.setLibraryId(prdYeedocRefVO.getLibraryId());
            payload.setFolderId(prdYeedocRefVO.getItemId());
            List<FolderListByItemNameDTO> folderListByItemNameDTOS = this.yeedocProService.folderListByItemName(payload);
            if (!CollectionUtil.isEmpty(folderListByItemNameDTOS)) {
                Set<String> itemIdSet = folderListByItemNameDTOS.stream().map(item -> item.getFolderId()).collect(Collectors.toSet());
                pmsDeliverItemQuery.setItemIdSet(itemIdSet);
            } else {
                return PagingVO.empty();
            }
        }
        if (null != pmsDeliverItemQuery.getWbsId()) {
            PmsProjectWbsAcceptQuery pmsProjectWbsAcceptQuery = new PmsProjectWbsAcceptQuery();
            pmsProjectWbsAcceptQuery.setWbsId(pmsDeliverItemQuery.getWbsId());
            List pmsProjectWbsAcceptVOS = this.pmsProjectWbsAcceptService.getList(pmsProjectWbsAcceptQuery);
            Set<Long> idList = pmsProjectWbsAcceptVOS.stream().filter(pmsProjectWbsAcceptVO -> null != pmsProjectWbsAcceptVO.getType() && pmsProjectWbsAcceptVO.getType().equals(0) && StringUtils.hasText((String)pmsProjectWbsAcceptVO.getContent())).map(pmsProjectWbsAcceptVO -> Long.valueOf(pmsProjectWbsAcceptVO.getContent())).collect(Collectors.toSet());
            if (CollectionUtil.isEmpty(idList)) {
                return PagingVO.empty();
            }
            pmsDeliverItemQuery.setIdCollection(idList);
        }
        PagingVO<PmsDeliverItemVO> res = this.pmsDeliverItemDao.page(pmsDeliverItemQuery);
        List<PmsDeliverItemPayload> updateStatusList = this.translate(res.getRecords());
        this.updateStatusBatch(updateStatusList);
        return res;
    }

    @Override
    @Transactional
    public PagingVO<PmsDeliverItemVO> myPage(PmsDeliverItemQuery pmsDeliverItemQuery) {
        Long loginUserId;
        Long projectId = pmsDeliverItemQuery.getProjectId();
        ProRelatedPartiesVO proRelatedPartiesVO = this.proRelatedPartiesService.getListSimpleByProjectIdAndUserId(projectId, loginUserId = GlobalUtil.getLoginUserId());
        if (null == proRelatedPartiesVO) {
            return new PagingVO();
        }
        Long id = proRelatedPartiesVO.getId();
        pmsDeliverItemQuery.setDirectorRelatedPartiesId(id);
        PagingVO<PmsDeliverItemVO> page = this.page(pmsDeliverItemQuery);
        List records = page.getRecords();
        List<PmsDeliverItemPayload> updateStatusList = this.translate(records);
        this.updateStatusBatch(updateStatusList);
        return page;
    }

    @NotNull
    private List<PmsDeliverItemPayload> translate(List<PmsDeliverItemVO> records) {
        if (CollectionUtil.isEmpty(records)) {
            return Collections.emptyList();
        }
        List idList = records.stream().map(item -> item.getId().toString()).collect(Collectors.toList());
        List projectWbsAcceptVOS = this.pmsProjectWbsAcceptService.listByContentAndTypeEqualZero(idList);
        Map<String, List<PmsProjectWbsAcceptVO>> contentMap = projectWbsAcceptVOS.stream().collect(Collectors.groupingBy(PmsProjectWbsAcceptVO::getContent));
        if (!contentMap.isEmpty()) {
            records.forEach(pmsDeliverItemVO -> {
                Long id = pmsDeliverItemVO.getId();
                List projectWbsAcceptVOS1 = (List)contentMap.get("" + id);
                if (!CollectionUtil.isEmpty((Collection)projectWbsAcceptVOS1)) {
                    PmsProjectWbsAcceptVO pmsProjectWbsAcceptVO = (PmsProjectWbsAcceptVO)projectWbsAcceptVOS1.get(0);
                    Long wbsId = pmsProjectWbsAcceptVO.getWbsId();
                    String wbsName = pmsProjectWbsAcceptVO.getWbsName();
                    pmsDeliverItemVO.setWbsId(wbsId);
                    pmsDeliverItemVO.setWbsName(wbsName);
                }
            });
        }
        ItemInfoPayload itemInfoPayload = new ItemInfoPayload();
        Set<String> itemIdList = records.stream().filter(pmsDeliverItemVO -> StringUtils.hasText((String)pmsDeliverItemVO.getItemId())).map(PmsDeliverItemVO::getItemId).collect(Collectors.toSet());
        itemInfoPayload.setItemIds(itemIdList);
        Map<String, List<ItemInfoDataFileDTO>> stringListMap = this.yeedocProService.itemInfoReturn(itemInfoPayload);
        ArrayList<PmsDeliverItemPayload> updateStatusList = new ArrayList<PmsDeliverItemPayload>();
        records.stream().filter(pmsDeliverItemVO -> StringUtils.hasText((String)pmsDeliverItemVO.getItemId())).forEach(pmsDeliverItemVO -> {
            pmsDeliverItemVO.setStatus(DeliverItemStatusEnum.NO.getCode());
            String itemId = pmsDeliverItemVO.getItemId();
            List itemInfoDataFileDTOS = (List)stringListMap.get(itemId);
            PmsDeliverItemPayload update = new PmsDeliverItemPayload();
            update.setId(pmsDeliverItemVO.getId());
            if (!CollectionUtil.isEmpty((Collection)itemInfoDataFileDTOS)) {
                pmsDeliverItemVO.setStatus(DeliverItemStatusEnum.OK.getCode());
            }
            update.setStatus(pmsDeliverItemVO.getStatus());
            updateStatusList.add(update);
            pmsDeliverItemVO.setFileList(itemInfoDataFileDTOS);
        });
        return updateStatusList;
    }

    @Transactional
    @Async
    public void updateStatusBatch(List<PmsDeliverItemPayload> updateStatusList) {
        if (!CollectionUtil.isEmpty(updateStatusList)) {
            updateStatusList.forEach(pmsDeliverItemPayload -> this.update((PmsDeliverItemPayload)((Object)pmsDeliverItemPayload)));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long del(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = this.pmsDeliverItemDao.del(ids);
        return res;
    }

    @Override
    public List<PmsDeliverItemVO> getList(PmsDeliverItemQuery pmsDeliverItemQuery) {
        List<PmsDeliverItemVO> res = this.pmsDeliverItemDao.getList(pmsDeliverItemQuery);
        return res;
    }

    @Override
    public List<PmsDeliverItemVO> list(PmsDeliverItemQuery pmsDeliverItemQuery) {
        List<PmsDeliverItemVO> res = this.pmsDeliverItemDao.list(pmsDeliverItemQuery);
        return res;
    }

    private void checkData(PmsDeliverItemPayload pmsDeliverItemPayload) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long update(PmsDeliverItemPayload pmsDeliverItemPayload) {
        Assert.notNull((Object)pmsDeliverItemPayload.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Long res = this.pmsDeliverItemDao.update(pmsDeliverItemPayload);
        return res;
    }

    @Override
    public Long count(PmsDeliverItemQuery pmsDeliverItemQuery) {
        Long res = this.pmsDeliverItemDao.count(pmsDeliverItemQuery);
        return res;
    }

    @Override
    public long delByProjectId(Long projectId) {
        return this.pmsDeliverItemDao.delByProjectId(projectId);
    }

    @Override
    public Long updateShowFlagByRoleId(Long roleId, boolean showFlag) {
        return this.pmsDeliverItemDao.updateShowFlagByRoleId(roleId, showFlag);
    }

    @Override
    @Transactional
    public PmsIframeDocInfoVO getIframeDocInfo(Long projectId, String appId, HttpServletRequest request, HttpServletResponse response) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PrdYeedocRefVO prdYeedocRefVO = this.prdYeedocRefService.queryByRefTypeAndRefId(YeedocRefTypeEnum.PMS_PROJECT, projectId);
        String pmsLibraryId = this.yeedocProProperties.getPmsLibraryId();
        if (prdYeedocRefVO == null) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(projectId);
            String fileName = pmsProjectVO.getProjName() + "-" + pmsProjectVO.getProjNo();
            CreateFolderTwPayload createFolderTwPayload = new CreateFolderTwPayload();
            createFolderTwPayload.setLibraryId(pmsLibraryId);
            createFolderTwPayload.setPathArry(Arrays.asList("/" + fileName));
            YeedocCreateFolderForTwDTO folderReturn = this.yeedocProService.createFolderForTw(createFolderTwPayload);
            PrdYeedocRefPayload save = new PrdYeedocRefPayload();
            save.setRefType(YeedocRefTypeEnum.PMS_PROJECT.getCode());
            save.setRefId(projectId);
            save.setLibraryId(pmsLibraryId);
            save.setItemId(folderReturn.getFolderId());
            save.setItemName(folderReturn.getLeafName());
            TwOutputUtil<PrdYeedocRefVO> insert = this.prdYeedocRefService.insert(save);
            if (insert.isOk()) {
                prdYeedocRefVO = insert.getData();
            }
        }
        PmsIframeDocInfoVO result = new PmsIframeDocInfoVO();
        result.setLibraryId(pmsLibraryId);
        result.setFolder(prdYeedocRefVO.getItemId());
        result.setRootFolder(prdYeedocRefVO.getItemId());
        result.setSource(this.yeedocProProperties.getSourceIframe());
        Map ticketAndUrl = this.prdCasSsoService.getTicketAndUrl(appId, request, response);
        if (null != ticketAndUrl) {
            Object objTicket = ticketAndUrl.get("ticket");
            result.setTicket(objTicket.toString());
        } else {
            log.error("ticketAndUrl is null");
        }
        return result;
    }

    @Override
    public List<PmsDeliverItemStatisticsVO> statistics(PmsDeliverItemQuery query) {
        List<PmsDeliverItemVO> pmsDeliverItemVOList;
        org.springframework.util.Assert.notNull((Object)query.getProjectId(), (String)"\u9879\u76ee\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<PmsDeliverItemStatisticsVO> result = new ArrayList<PmsDeliverItemStatisticsVO>();
        long okCount = 0L;
        long overdueCount = 0L;
        long todayCount = 0L;
        long surplusCount = 0L;
        if (ObjectUtils.isEmpty((Object)query.getShowFlag())) {
            query.setShowFlag(true);
        }
        if (CollectionUtils.isNotEmpty(pmsDeliverItemVOList = this.list(query))) {
            LocalDate now = LocalDate.now();
            okCount = pmsDeliverItemVOList.stream().filter(pmsDeliverItemVO -> DeliverItemStatusEnum.OK.getCode().equals(pmsDeliverItemVO.getStatus())).count();
            overdueCount = pmsDeliverItemVOList.stream().filter(pmsDeliverItemVO -> DeliverItemStatusEnum.NO.getCode().equals(pmsDeliverItemVO.getStatus()) && pmsDeliverItemVO.getPreStartDate().isBefore(now)).count();
            todayCount = pmsDeliverItemVOList.stream().filter(pmsDeliverItemVO -> DeliverItemStatusEnum.NO.getCode().equals(pmsDeliverItemVO.getStatus()) && pmsDeliverItemVO.getPreStartDate().isEqual(now)).count();
            surplusCount = pmsDeliverItemVOList.stream().filter(pmsDeliverItemVO -> DeliverItemStatusEnum.NO.getCode().equals(pmsDeliverItemVO.getStatus()) && pmsDeliverItemVO.getPreStartDate().isAfter(now)).count();
            Long countSum = okCount + overdueCount + todayCount + surplusCount;
            result.add(new PmsDeliverItemStatisticsVO(DeliverItemStatisticsStatusEnum.OK.getCode(), DeliverItemStatisticsStatusEnum.OK.getDesc(), okCount, countSum));
            result.add(new PmsDeliverItemStatisticsVO(DeliverItemStatisticsStatusEnum.OVERDUE.getCode(), DeliverItemStatisticsStatusEnum.OVERDUE.getDesc(), overdueCount, countSum));
            result.add(new PmsDeliverItemStatisticsVO(DeliverItemStatisticsStatusEnum.TO_BE_COMPLETED_TODAY.getCode(), DeliverItemStatisticsStatusEnum.TO_BE_COMPLETED_TODAY.getDesc(), todayCount, countSum));
            result.add(new PmsDeliverItemStatisticsVO(DeliverItemStatisticsStatusEnum.SURPLUS.getCode(), DeliverItemStatisticsStatusEnum.SURPLUS.getDesc(), surplusCount, countSum));
        }
        return result;
    }

    public PmsDeliverItemServiceImpl(PmsDeliverItemDao pmsDeliverItemDao, YeedocProProperties yeedocProProperties, PmsDeliverItemRepo pmsDeliverItemRepo, ProRelatedPartiesService proRelatedPartiesService, YeedocProService yeedocProService, PrdCasSsoService prdCasSsoService) {
        this.pmsDeliverItemDao = pmsDeliverItemDao;
        this.yeedocProProperties = yeedocProProperties;
        this.pmsDeliverItemRepo = pmsDeliverItemRepo;
        this.proRelatedPartiesService = proRelatedPartiesService;
        this.yeedocProService = yeedocProService;
        this.prdCasSsoService = prdCasSsoService;
    }
}

